/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.blocks;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockState;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import noppes.npcs.NoppesUtilServer;
import noppes.npcs.blocks.BlockChair;
import noppes.npcs.blocks.tiles.TileColorable;
import noppes.npcs.blocks.tiles.TileCouchWood;
import noppes.npcs.client.renderer.ITileRenderer;

public class BlockCouchWood
extends BlockContainer
implements ITileRenderer {
    public static final PropertyInteger DAMAGE = PropertyInteger.func_177719_a((String)"damage", (int)0, (int)5);
    private TileColorable renderTile;

    public BlockCouchWood() {
        super(Material.field_151575_d);
    }

    public boolean func_180639_a(World par1World, BlockPos pos, IBlockState state, EntityPlayer player, EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemStack item = player.field_71071_by.func_70448_g();
        if (item == null || item.func_77973_b() != Items.field_151100_aR) {
            return BlockChair.MountBlock(par1World, pos, player);
        }
        TileColorable tile = (TileColorable)par1World.func_175625_s(pos);
        int color = EnumDyeColor.func_176766_a((int)item.func_77952_i()).func_176765_a();
        if (tile.color != color) {
            NoppesUtilServer.consumeItemStack(1, player);
            tile.color = color;
            par1World.func_175689_h(pos);
        }
        return true;
    }

    public void func_149666_a(Item par1, CreativeTabs par2CreativeTabs, List par3List) {
        par3List.add(new ItemStack(par1, 1, 0));
        par3List.add(new ItemStack(par1, 1, 1));
        par3List.add(new ItemStack(par1, 1, 2));
        par3List.add(new ItemStack(par1, 1, 3));
        par3List.add(new ItemStack(par1, 1, 4));
        par3List.add(new ItemStack(par1, 1, 5));
    }

    public int func_176201_c(IBlockState state) {
        return this.func_180651_a(state);
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)DAMAGE, (Comparable)Integer.valueOf(meta));
    }

    protected BlockState func_180661_e() {
        return new BlockState((Block)this, new IProperty[]{DAMAGE});
    }

    public int func_180651_a(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)DAMAGE) % 7;
    }

    public AxisAlignedBB func_180640_a(World world, BlockPos pos, IBlockState state) {
        return new AxisAlignedBB((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (double)(pos.func_177958_n() + 1), (double)pos.func_177956_o() + 0.5, (double)(pos.func_177952_p() + 1));
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase entity, ItemStack stack) {
        int l = MathHelper.func_76128_c((double)((double)(entity.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        world.func_180501_a(pos, state.func_177226_a((IProperty)DAMAGE, (Comparable)Integer.valueOf(stack.func_77952_i())), 2);
        TileCouchWood tile = (TileCouchWood)world.func_175625_s(pos);
        tile.rotation = l %= 4;
        tile.color = 15 - stack.func_77952_i();
        this.updateModel(world, pos, tile);
        this.func_176204_a(world, pos.func_177974_f(), state, (Block)this);
        this.func_176204_a(world, pos.func_177976_e(), state, (Block)this);
        this.func_176204_a(world, pos.func_177978_c(), state, (Block)this);
        this.func_176204_a(world, pos.func_177968_d(), state, (Block)this);
        this.updateModel(world, pos, tile);
        world.func_175689_h(pos);
    }

    public void func_176204_a(World worldObj, BlockPos pos, IBlockState state, Block block) {
        if (worldObj.field_72995_K || block != this) {
            return;
        }
        TileEntity tile = worldObj.func_175625_s(pos);
        if (tile == null || !(tile instanceof TileCouchWood)) {
            return;
        }
        this.updateModel(worldObj, pos, (TileCouchWood)tile);
        worldObj.func_175689_h(pos);
    }

    private void updateModel(World world, BlockPos pos, TileCouchWood tile) {
        if (world.field_72995_K) {
            return;
        }
        int meta = tile.func_145832_p();
        if (tile.rotation == 0) {
            tile.hasLeft = this.compareTiles(tile, pos.func_177976_e(), world, meta);
            tile.hasRight = this.compareTiles(tile, pos.func_177974_f(), world, meta);
        } else if (tile.rotation == 2) {
            tile.hasLeft = this.compareTiles(tile, pos.func_177974_f(), world, meta);
            tile.hasRight = this.compareTiles(tile, pos.func_177976_e(), world, meta);
        } else if (tile.rotation == 1) {
            tile.hasLeft = this.compareTiles(tile, pos.func_177978_c(), world, meta);
            tile.hasRight = this.compareTiles(tile, pos.func_177968_d(), world, meta);
        } else if (tile.rotation == 3) {
            tile.hasLeft = this.compareTiles(tile, pos.func_177968_d(), world, meta);
            tile.hasRight = this.compareTiles(tile, pos.func_177978_c(), world, meta);
        }
    }

    private boolean compareTiles(TileCouchWood tile, BlockPos pos, World world, int meta) {
        IBlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() != this) {
            return false;
        }
        int meta2 = (Integer)state.func_177229_b((IProperty)DAMAGE);
        if (meta2 != meta) {
            return false;
        }
        TileEntity tile2 = world.func_175625_s(pos);
        if (tile2 == null || !(tile2 instanceof TileCouchWood)) {
            return false;
        }
        TileCouchWood couch = (TileCouchWood)tile2;
        return tile.rotation == couch.rotation;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public TileEntity func_149915_a(World var1, int var2) {
        return new TileCouchWood();
    }

    @Override
    public TileColorable getTile() {
        if (this.renderTile == null) {
            this.renderTile = (TileColorable)this.func_149915_a(null, 0);
        }
        return this.renderTile;
    }
}

