/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.blocks;

import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockState;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import noppes.npcs.blocks.tiles.TileColorable;
import noppes.npcs.client.renderer.ITileRenderer;

public abstract class BlockRotated
extends BlockContainer
implements ITileRenderer {
    private Block block;
    public static final PropertyInteger DAMAGE = PropertyInteger.func_177719_a((String)"damage", (int)0, (int)6);
    public int renderId = -1;
    private TileEntity renderTile;

    protected BlockRotated(Block block) {
        super(block.func_149688_o());
        this.block = block;
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        int l = MathHelper.func_76128_c((double)((double)(placer.field_70177_z * (float)this.maxRotation() / 360.0f) + 0.5)) & this.maxRotation() - 1;
        TileColorable tile = (TileColorable)world.func_175625_s(pos);
        tile.rotation = l %= this.maxRotation();
    }

    public AxisAlignedBB func_180640_a(World world, BlockPos pos, IBlockState state) {
        this.func_180654_a((IBlockAccess)world, pos);
        return super.func_180640_a(world, pos, state);
    }

    public int maxRotation() {
        return 4;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public int func_149645_b() {
        return this.renderId;
    }

    public boolean isSideSolid(IBlockAccess world, BlockPos pos, EnumFacing side) {
        return true;
    }

    @Override
    public TileEntity getTile() {
        if (this.renderTile == null) {
            this.renderTile = this.func_149915_a(null, 0);
        }
        return this.renderTile;
    }

    public int func_176201_c(IBlockState state) {
        return this.func_180651_a(state);
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)DAMAGE, (Comparable)Integer.valueOf(meta));
    }

    protected BlockState func_180661_e() {
        return new BlockState((Block)this, new IProperty[]{DAMAGE});
    }

    public int func_180651_a(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)DAMAGE);
    }
}

