/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.gui;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiConfirmOpenLink;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiYesNoCallback;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.server.MinecraftServer;
import noppes.npcs.NoppesStringUtils;
import noppes.npcs.client.Client;
import noppes.npcs.client.NoppesUtil;
import noppes.npcs.client.gui.GuiScriptList;
import noppes.npcs.client.gui.swing.GuiJTextArea;
import noppes.npcs.client.gui.util.GuiCustomScroll;
import noppes.npcs.client.gui.util.GuiMenuTopButton;
import noppes.npcs.client.gui.util.GuiNPCInterface;
import noppes.npcs.client.gui.util.GuiNpcButton;
import noppes.npcs.client.gui.util.GuiNpcLabel;
import noppes.npcs.client.gui.util.GuiNpcTextArea;
import noppes.npcs.client.gui.util.ICustomScrollListener;
import noppes.npcs.client.gui.util.IGuiData;
import noppes.npcs.client.gui.util.IJTextAreaListener;
import noppes.npcs.constants.EnumPacketServer;
import noppes.npcs.controllers.ScriptContainer;
import noppes.npcs.controllers.ScriptController;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.entity.data.DataScript;

public class GuiScript
extends GuiNPCInterface
implements IGuiData,
GuiYesNoCallback,
ICustomScrollListener,
IJTextAreaListener {
    private int activeTab = 0;
    public DataScript script;
    public Map<String, List<String>> languages = new HashMap<String, List<String>>();

    public GuiScript(EntityNPCInterface npc) {
        super(npc);
        this.script = npc.script;
        this.drawDefaultBackground = true;
        this.closeOnEsc = true;
        this.xSize = 420;
        this.setBackground("menubg.png");
        Client.sendData(EnumPacketServer.ScriptDataGet, new Object[0]);
    }

    @Override
    public void func_73866_w_() {
        this.xSize = (int)((double)this.field_146294_l * 0.88);
        this.ySize = (int)((double)this.xSize * 0.56);
        this.bgScale = (float)this.xSize / 400.0f;
        super.func_73866_w_();
        this.guiTop += 10;
        int yoffset = (int)((double)this.ySize * 0.02);
        GuiMenuTopButton top = new GuiMenuTopButton(0, this.guiLeft + 4, this.guiTop - 17, "gui.settings");
        this.addTopButton(top);
        for (int i = 0; i < this.script.scripts.size(); ++i) {
            ScriptContainer script = this.script.scripts.get(i);
            top = new GuiMenuTopButton(i + 1, top, i + 1 + "");
            this.addTopButton(top);
        }
        if (this.script.scripts.size() < 8) {
            top = new GuiMenuTopButton(12, top, "+");
            this.addTopButton(top);
        }
        if ((top = this.getTopButton(this.activeTab)) == null) {
            this.activeTab = 0;
            top = this.getTopButton(0);
        }
        top.active = true;
        if (this.activeTab > 0) {
            ScriptContainer container = this.script.scripts.get(this.activeTab - 1);
            this.addTextField(new GuiNpcTextArea(2, this, this.guiLeft + 1 + yoffset, this.guiTop + yoffset, this.xSize - 108 - yoffset, (int)((double)this.ySize * 0.96) - yoffset * 2, container == null ? "" : container.script));
            int left = this.guiLeft + this.xSize - 104;
            this.addButton(new GuiNpcButton(102, left, this.guiTop + yoffset, 60, 20, "gui.clear"));
            this.addButton(new GuiNpcButton(101, left + 61, this.guiTop + yoffset, 60, 20, "gui.paste"));
            this.addButton(new GuiNpcButton(100, left, this.guiTop + 21 + yoffset, 60, 20, "gui.copy"));
            this.addButton(new GuiNpcButton(108, left, this.guiTop + 43 + yoffset, 80, 20, "gui.editor"));
            this.addButton(new GuiNpcButton(107, left, this.guiTop + 66 + yoffset, 80, 20, "script.loadscript"));
            GuiCustomScroll scroll = new GuiCustomScroll(this, 0).setUnselectable();
            scroll.setSize(100, (int)((double)this.ySize * 0.54) - yoffset * 2);
            scroll.guiLeft = left;
            scroll.guiTop = this.guiTop + 88 + yoffset;
            if (container != null) {
                scroll.setList(container.scripts);
            }
            this.addScroll(scroll);
        } else {
            int left = this.guiLeft + this.xSize - 150;
            this.addButton(new GuiNpcButton(100, left, this.guiTop + 140, 56, 20, "gui.copy"));
            this.addButton(new GuiNpcButton(102, left, this.guiTop + 162, 56, 20, "gui.clear"));
            this.addLabel(new GuiNpcLabel(1, "script.language", left, this.guiTop + 30));
            this.addButton(new GuiNpcButton(103, left + 60, this.guiTop + 25, 80, 20, this.languages.keySet().toArray(new String[this.languages.keySet().size()]), this.getScriptIndex()));
            this.getButton((int)103).field_146124_l = this.languages.size() > 0;
            this.addLabel(new GuiNpcLabel(2, "gui.enabled", left, this.guiTop + 53));
            this.addButton(new GuiNpcButton(104, left + 60, this.guiTop + 48, 50, 20, new String[]{"gui.no", "gui.yes"}, this.script.enabled ? 1 : 0));
            if (MinecraftServer.func_71276_C() != null) {
                this.addButton(new GuiNpcButton(106, left, this.guiTop + 71, 150, 20, "script.openfolder"));
            }
        }
        this.xSize = 420;
        this.ySize = 256;
    }

    private int getScriptIndex() {
        int i = 0;
        for (String language : this.languages.keySet()) {
            if (language.equalsIgnoreCase(this.script.scriptLanguage)) {
                return i;
            }
            ++i;
        }
        return 0;
    }

    public void func_73878_a(boolean flag, int i) {
        if (flag) {
            this.openLink("http://www.kodevelopment.nl/minecraft/customnpcs/scripting");
        }
        this.displayGuiScreen(this);
    }

    @Override
    protected void func_146284_a(GuiButton guibutton) {
        ScriptContainer container;
        if (guibutton.field_146127_k >= 0 && guibutton.field_146127_k < 12) {
            this.setScript();
            this.activeTab = guibutton.field_146127_k;
            this.func_73866_w_();
        }
        if (guibutton.field_146127_k == 12) {
            this.script.scripts.add(new ScriptContainer());
            this.activeTab = this.script.scripts.size();
            this.func_73866_w_();
        }
        if (guibutton.field_146127_k == 15) {
            GuiConfirmOpenLink guiyesno = new GuiConfirmOpenLink((GuiYesNoCallback)this, "http://www.kodevelopment.nl/minecraft/customnpcs/scripting", 0, true);
            this.field_146297_k.func_147108_a((GuiScreen)guiyesno);
        }
        if (guibutton.field_146127_k == 100) {
            NoppesStringUtils.setClipboardContents(this.getTextField(2).func_146179_b());
        }
        if (guibutton.field_146127_k == 101) {
            this.getTextField(2).func_146180_a(NoppesStringUtils.getClipboardContents());
        }
        if (guibutton.field_146127_k == 103) {
            this.script.scriptLanguage = ((GuiNpcButton)guibutton).field_146126_j;
        }
        if (guibutton.field_146127_k == 104) {
            boolean bl = this.script.enabled = ((GuiNpcButton)guibutton).getValue() == 1;
        }
        if (guibutton.field_146127_k == 106) {
            NoppesUtil.openFolder(ScriptController.Instance.dir);
        }
        if (guibutton.field_146127_k == 107) {
            container = this.script.scripts.get(this.activeTab);
            if (container == null) {
                container = new ScriptContainer();
                this.script.scripts.add(container);
            }
            this.setSubGui(new GuiScriptList(this.languages.get(this.script.scriptLanguage), container));
        }
        if (guibutton.field_146127_k == 108 && (container = this.script.scripts.get(this.activeTab)) != null) {
            this.setScript();
            AWTWindow = new GuiJTextArea(container.script).setListener(this);
        }
    }

    private void setScript() {
        if (this.activeTab > 0) {
            ScriptContainer container = this.script.scripts.get(this.activeTab - 1);
            if (container == null) {
                container = new ScriptContainer();
                this.script.scripts.add(container);
            }
            String text = this.getTextField(2).func_146179_b();
            text = text.replace("\r\n", "\n");
            container.script = text = text.replace("\r", "\n");
        }
    }

    @Override
    public void setGuiData(NBTTagCompound compound) {
        this.script.readFromNBT(compound);
        NBTTagList data = compound.func_150295_c("Languages", 10);
        HashMap<String, List<String>> languages = new HashMap<String, List<String>>();
        for (int i = 0; i < data.func_74745_c(); ++i) {
            NBTTagCompound comp = data.func_150305_b(i);
            ArrayList<String> scripts = new ArrayList<String>();
            NBTTagList list = comp.func_150295_c("Scripts", 8);
            for (int j = 0; j < list.func_74745_c(); ++j) {
                scripts.add(list.func_150307_f(j));
            }
            languages.put(comp.func_74779_i("Language"), scripts);
        }
        this.languages = languages;
        this.func_73866_w_();
    }

    @Override
    public void save() {
        this.setScript();
        Client.sendData(EnumPacketServer.ScriptDataSave, this.script.writeToNBT(new NBTTagCompound()));
    }

    @Override
    public void customScrollClicked(int i, int j, int k, GuiCustomScroll scroll) {
        if (scroll.id == 1) {
            this.setScript();
            this.activeTab = scroll.selected;
            this.func_73866_w_();
        }
    }

    @Override
    public void saveText(String text) {
        ScriptContainer container = this.script.scripts.get(this.activeTab);
        if (container != null) {
            container.script = text;
        }
        this.func_73866_w_();
    }
}

