/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.controllers;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.common.IExtendedEntityProperties;
import noppes.npcs.CustomNpcs;
import noppes.npcs.LogWriter;
import noppes.npcs.controllers.Bank;
import noppes.npcs.controllers.BankController;
import noppes.npcs.controllers.PlayerBankData;
import noppes.npcs.controllers.PlayerData;
import noppes.npcs.controllers.PlayerMail;
import noppes.npcs.util.NBTJsonUtil;

public class PlayerDataController {
    public static PlayerDataController instance;

    public PlayerDataController() {
        instance = this;
    }

    public File getSaveDir() {
        try {
            File file = new File(CustomNpcs.getWorldSaveDirectory(), "playerdata");
            if (!file.exists()) {
                file.mkdir();
            }
            return file;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public NBTTagCompound loadPlayerDataOld(String player) {
        File file;
        File saveDir = this.getSaveDir();
        String filename = player;
        if (filename.isEmpty()) {
            filename = "noplayername";
        }
        filename = filename + ".dat";
        try {
            file = new File(saveDir, filename);
            if (file.exists()) {
                NBTTagCompound comp = CompressedStreamTools.func_74796_a((InputStream)new FileInputStream(file));
                file.delete();
                file = new File(saveDir, filename + "_old");
                if (file.exists()) {
                    file.delete();
                }
                return comp;
            }
        }
        catch (Exception e) {
            LogWriter.except(e);
        }
        try {
            file = new File(saveDir, filename + "_old");
            if (file.exists()) {
                return CompressedStreamTools.func_74796_a((InputStream)new FileInputStream(file));
            }
        }
        catch (Exception e) {
            LogWriter.except(e);
        }
        return new NBTTagCompound();
    }

    public NBTTagCompound loadPlayerData(String player) {
        File saveDir = this.getSaveDir();
        String filename = player;
        if (filename.isEmpty()) {
            filename = "noplayername";
        }
        filename = filename + ".json";
        File file = null;
        try {
            file = new File(saveDir, filename);
            if (file.exists()) {
                return NBTJsonUtil.LoadFile(file);
            }
        }
        catch (Exception e) {
            LogWriter.error("Error loading: " + file.getAbsolutePath(), e);
        }
        return new NBTTagCompound();
    }

    public void savePlayerData(PlayerData data) {
        NBTTagCompound compound = data.getNBT();
        String filename = data.uuid + ".json";
        try {
            File saveDir = this.getSaveDir();
            File file = new File(saveDir, filename + "_new");
            File file1 = new File(saveDir, filename);
            NBTJsonUtil.SaveFile(file, compound);
            if (file1.exists()) {
                file1.delete();
            }
            file.renameTo(file1);
        }
        catch (Exception e) {
            LogWriter.except(e);
        }
    }

    public PlayerBankData getBankData(EntityPlayer player, int bankId) {
        Bank bank = BankController.getInstance().getBank(bankId);
        PlayerBankData data = this.getPlayerData((EntityPlayer)player).bankData;
        if (!data.hasBank(bank.id)) {
            data.loadNew(bank.id);
        }
        return data;
    }

    public PlayerData getPlayerData(EntityPlayer player) {
        PlayerData data = (PlayerData)player.getExtendedProperties("CustomNpcsData");
        if (data == null) {
            data = new PlayerData();
            player.registerExtendedProperties("CustomNpcsData", (IExtendedEntityProperties)data);
            data.player = player;
            data.loadNBTData(null);
        }
        data.player = player;
        return data;
    }

    public String hasPlayer(String username) {
        for (String name : this.getUsernameData().keySet()) {
            if (!name.equalsIgnoreCase(username)) continue;
            return name;
        }
        return "";
    }

    public PlayerData getDataFromUsername(String username) {
        EntityPlayerMP player = MinecraftServer.func_71276_C().func_71203_ab().func_152612_a(username);
        PlayerData data = null;
        if (player == null) {
            Map<String, NBTTagCompound> map = this.getUsernameData();
            for (String name : map.keySet()) {
                if (!name.equalsIgnoreCase(username)) continue;
                data = new PlayerData();
                data.setNBT(map.get(name));
                break;
            }
        } else {
            data = this.getPlayerData((EntityPlayer)player);
        }
        return data;
    }

    public void addPlayerMessage(String username, PlayerMail mail) {
        mail.time = System.currentTimeMillis();
        EntityPlayerMP player = MinecraftServer.func_71276_C().func_71203_ab().func_152612_a(username);
        PlayerData data = this.getDataFromUsername(username);
        data.mailData.playermail.add(mail.copy());
        this.savePlayerData(data);
    }

    public Map<String, NBTTagCompound> getUsernameData() {
        HashMap<String, NBTTagCompound> map = new HashMap<String, NBTTagCompound>();
        for (File file : this.getSaveDir().listFiles()) {
            if (file.isDirectory() || !file.getName().endsWith(".json")) continue;
            try {
                NBTTagCompound compound = NBTJsonUtil.LoadFile(file);
                if (!compound.func_74764_b("PlayerName")) continue;
                map.put(compound.func_74779_i("PlayerName"), compound);
            }
            catch (Exception e) {
                LogWriter.error("Error loading: " + file.getAbsolutePath(), e);
            }
        }
        return map;
    }

    public boolean hasMail(EntityPlayer player) {
        return this.getPlayerData((EntityPlayer)player).mailData.hasMail();
    }
}

