/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.controllers;

import java.util.Vector;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import noppes.npcs.EventHooks;
import noppes.npcs.Server;
import noppes.npcs.api.constants.EnumQuestType;
import noppes.npcs.constants.EnumPacketClient;
import noppes.npcs.constants.EnumQuestRepeat;
import noppes.npcs.controllers.PlayerData;
import noppes.npcs.controllers.PlayerDataController;
import noppes.npcs.controllers.PlayerQuestData;
import noppes.npcs.controllers.Quest;
import noppes.npcs.controllers.QuestData;
import noppes.npcs.quests.QuestDialog;

public class PlayerQuestController {
    public static boolean hasActiveQuests(EntityPlayer player) {
        PlayerQuestData data = PlayerDataController.instance.getPlayerData((EntityPlayer)player).questData;
        return !data.activeQuests.isEmpty();
    }

    public static boolean isQuestActive(EntityPlayer player, int quest) {
        PlayerQuestData data = PlayerDataController.instance.getPlayerData((EntityPlayer)player).questData;
        return data.activeQuests.containsKey(quest);
    }

    public static boolean isQuestFinished(EntityPlayer player, int questid) {
        PlayerQuestData data = PlayerDataController.instance.getPlayerData((EntityPlayer)player).questData;
        return data.finishedQuests.containsKey(questid);
    }

    public static void addActiveQuest(Quest quest, EntityPlayer player) {
        PlayerQuestData data = PlayerDataController.instance.getPlayerData((EntityPlayer)player).questData;
        if (PlayerQuestController.canQuestBeAccepted(quest, player)) {
            if (EventHooks.onQuestStarted(player, quest)) {
                return;
            }
            data.activeQuests.put(quest.id, new QuestData(quest));
            Server.sendData((EntityPlayerMP)player, EnumPacketClient.MESSAGE, "quest.newquest", quest.title);
            Server.sendData((EntityPlayerMP)player, EnumPacketClient.CHAT, "quest.newquest", ": ", quest.title);
        }
    }

    public static void setQuestFinished(Quest quest, EntityPlayer player) {
        PlayerData playerdata = PlayerDataController.instance.getPlayerData(player);
        PlayerQuestData data = playerdata.questData;
        data.activeQuests.remove(quest.id);
        if (quest.repeat == EnumQuestRepeat.RLDAILY || quest.repeat == EnumQuestRepeat.RLWEEKLY) {
            data.finishedQuests.put(quest.id, System.currentTimeMillis());
        } else {
            data.finishedQuests.put(quest.id, player.field_70170_p.func_82737_E());
        }
        if (quest.repeat != EnumQuestRepeat.NONE && quest.type == EnumQuestType.DIALOG) {
            QuestDialog questdialog = (QuestDialog)quest.questInterface;
            for (int dialog : questdialog.dialogs.values()) {
                playerdata.dialogData.dialogsRead.remove(dialog);
            }
        }
    }

    public static boolean canQuestBeAccepted(Quest quest, EntityPlayer player) {
        if (quest == null) {
            return false;
        }
        PlayerQuestData data = PlayerDataController.instance.getPlayerData((EntityPlayer)player).questData;
        if (data.activeQuests.containsKey(quest.id)) {
            return false;
        }
        if (!data.finishedQuests.containsKey(quest.id) || quest.repeat == EnumQuestRepeat.REPEATABLE) {
            return true;
        }
        if (quest.repeat == EnumQuestRepeat.NONE) {
            return false;
        }
        long questTime = data.finishedQuests.get(quest.id);
        if (quest.repeat == EnumQuestRepeat.MCDAILY) {
            return player.field_70170_p.func_82737_E() - questTime >= 24000L;
        }
        if (quest.repeat == EnumQuestRepeat.MCWEEKLY) {
            return player.field_70170_p.func_82737_E() - questTime >= 168000L;
        }
        if (quest.repeat == EnumQuestRepeat.RLDAILY) {
            return System.currentTimeMillis() - questTime >= 86400000L;
        }
        if (quest.repeat == EnumQuestRepeat.RLWEEKLY) {
            return System.currentTimeMillis() - questTime >= 604800000L;
        }
        return false;
    }

    public static Vector<Quest> getActiveQuests(EntityPlayer player) {
        Vector<Quest> quests = new Vector<Quest>();
        PlayerQuestData data = PlayerDataController.instance.getPlayerData((EntityPlayer)player).questData;
        for (QuestData questdata : data.activeQuests.values()) {
            if (questdata.quest == null) continue;
            quests.add(questdata.quest);
        }
        return quests;
    }
}

