/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs;

import java.net.InetAddress;
import java.net.UnknownHostException;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import noppes.npcs.NPCSpawning;
import noppes.npcs.client.AnalyticsTracking;
import noppes.npcs.controllers.MassBlockController;
import noppes.npcs.controllers.SchematicController;
import noppes.npcs.entity.data.DataScenes;

public class ServerTickHandler {
    public int ticks = 0;
    private String serverName = null;

    @SubscribeEvent
    public void onServerTick(TickEvent.WorldTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            NPCSpawning.findChunksForSpawning((WorldServer)event.world);
        }
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.START && this.ticks++ >= 20) {
            SchematicController.Instance.updateBuilding();
            MassBlockController.Update();
            this.ticks = 0;
            if (DataScenes.HasStarted) {
                ++DataScenes.Ticks;
            }
        }
    }

    @SubscribeEvent
    public void playerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        if (this.serverName == null) {
            String e = "local";
            MinecraftServer server = MinecraftServer.func_71276_C();
            if (server.func_71262_S()) {
                try {
                    e = InetAddress.getByName(server.func_71211_k()).getCanonicalHostName();
                }
                catch (UnknownHostException e1) {
                    e = MinecraftServer.func_71276_C().func_71211_k();
                }
                if (server.func_71234_u() != 25565) {
                    e = e + ":" + server.func_71234_u();
                }
            }
            if (e == null || e.startsWith("192.168") || e.contains("127.0.0.1") || e.startsWith("localhost")) {
                e = "local";
            }
            this.serverName = e;
        }
        AnalyticsTracking.sendData(event.player, "join", this.serverName);
    }
}

