/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.api.wrapper;

import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.BlockPos;
import noppes.npcs.NoppesUtilServer;
import noppes.npcs.api.CustomNPCsException;
import noppes.npcs.api.IItemStack;
import noppes.npcs.api.ITimers;
import noppes.npcs.api.entity.ICustomNpc;
import noppes.npcs.api.entity.IEntityLivingBase;
import noppes.npcs.api.entity.IPlayer;
import noppes.npcs.api.entity.data.INPCAi;
import noppes.npcs.api.entity.data.INPCDisplay;
import noppes.npcs.api.entity.data.INPCInventory;
import noppes.npcs.api.entity.data.INPCJob;
import noppes.npcs.api.entity.data.INPCRole;
import noppes.npcs.api.entity.data.INPCStats;
import noppes.npcs.api.handler.data.IFaction;
import noppes.npcs.api.wrapper.EntityLivingWrapper;
import noppes.npcs.controllers.Faction;
import noppes.npcs.controllers.FactionController;
import noppes.npcs.controllers.Line;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.util.ValueUtil;

public class NPCWrapper
extends EntityLivingWrapper
implements ICustomNpc {
    private EntityNPCInterface npc;

    public NPCWrapper(EntityNPCInterface npc) {
        super((EntityLiving)npc);
        this.npc = npc;
    }

    @Override
    public void setMaxHealth(float health) {
        super.setMaxHealth(health);
        this.npc.stats.maxHealth = (int)health;
    }

    @Override
    public INPCDisplay getDisplay() {
        return this.npc.display;
    }

    @Override
    public INPCInventory getInventory() {
        return this.npc.inventory;
    }

    @Override
    public INPCAi getAi() {
        return this.npc.ai;
    }

    @Override
    public INPCStats getStats() {
        return this.npc.stats;
    }

    @Override
    public IFaction getFaction() {
        return this.npc.faction;
    }

    @Override
    public ITimers getTimers() {
        return this.npc.timers;
    }

    @Override
    public void setFaction(int id) {
        Faction faction = FactionController.getInstance().getFaction(id);
        if (faction == null) {
            throw new CustomNPCsException("Unknown faction id: " + id, new Object[0]);
        }
        this.npc.setFaction(id);
    }

    @Override
    public INPCRole getRole() {
        return this.npc.roleInterface;
    }

    @Override
    public INPCJob getJob() {
        return this.npc.jobInterface;
    }

    @Override
    public int getHomeX() {
        return this.npc.ai.startPos().func_177958_n();
    }

    @Override
    public int getHomeY() {
        return this.npc.ai.startPos().func_177956_o();
    }

    @Override
    public int getHomeZ() {
        return this.npc.ai.startPos().func_177952_p();
    }

    @Override
    public void setHome(int x, int y, int z) {
        this.npc.ai.setStartPos(new BlockPos(x, y, z));
    }

    public int getOffsetX() {
        return (int)this.npc.ai.bodyOffsetX;
    }

    public int getOffsetY() {
        return (int)this.npc.ai.bodyOffsetY;
    }

    public int getOffsetZ() {
        return (int)this.npc.ai.bodyOffsetZ;
    }

    public void setOffset(int x, int y, int z) {
        this.npc.ai.bodyOffsetX = ValueUtil.correctFloat(x, 0.0f, 9.0f);
        this.npc.ai.bodyOffsetY = ValueUtil.correctFloat(y, 0.0f, 9.0f);
        this.npc.ai.bodyOffsetZ = ValueUtil.correctFloat(z, 0.0f, 9.0f);
    }

    @Override
    public void say(String message) {
        this.npc.saySurrounding(new Line(message));
    }

    @Override
    public void kill() {
        this.npc.func_70106_y();
    }

    @Override
    public void reset() {
        this.npc.reset();
    }

    @Override
    public long getAge() {
        return this.npc.totalTicksAlive;
    }

    @Override
    public void shootItem(IEntityLivingBase target, IItemStack item, int accuracy) {
        if (item == null) {
            throw new CustomNPCsException("No item was given", new Object[0]);
        }
        if (target == null) {
            throw new CustomNPCsException("No target was given", new Object[0]);
        }
        accuracy = ValueUtil.CorrectInt(accuracy, 1, 100);
        this.npc.shoot(target.getMCEntity(), accuracy, item.getMCItemStack(), false);
    }

    @Override
    public void giveItem(IPlayer player, IItemStack item) {
        this.npc.givePlayerItem((EntityPlayer)player.getMCEntity(), item.getMCItemStack());
    }

    @Override
    public void executeCommand(String command) {
        NoppesUtilServer.runCommand(this.npc, this.npc.func_70005_c_(), command, null);
    }

    @Override
    public int getType() {
        return 2;
    }

    @Override
    public boolean typeOf(int type) {
        return type == 2 ? true : super.typeOf(type);
    }
}

