/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.blocks;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockState;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import noppes.npcs.CustomItems;
import noppes.npcs.CustomNpcsPermissions;
import noppes.npcs.NoppesUtilServer;
import noppes.npcs.blocks.tiles.TileBigSign;
import noppes.npcs.blocks.tiles.TileTombstone;
import noppes.npcs.client.renderer.ITileRenderer;
import noppes.npcs.constants.EnumGuiType;

public class BlockTombstone
extends BlockContainer
implements ITileRenderer {
    public static final PropertyInteger DAMAGE = PropertyInteger.func_177719_a((String)"damage", (int)0, (int)6);
    private TileEntity renderTile;

    public BlockTombstone() {
        super(Blocks.field_150347_e.func_149688_o());
    }

    public int func_176201_c(IBlockState state) {
        return this.func_180651_a(state);
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)DAMAGE, (Comparable)Integer.valueOf(meta));
    }

    protected BlockState func_180661_e() {
        return new BlockState((Block)this, new IProperty[]{DAMAGE});
    }

    public int func_180651_a(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)DAMAGE);
    }

    public boolean func_180639_a(World par1World, BlockPos pos, IBlockState state, EntityPlayer player, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (par1World.field_72995_K) {
            return false;
        }
        ItemStack currentItem = player.field_71071_by.func_70448_g();
        if (currentItem != null && currentItem.func_77973_b() == CustomItems.wand && CustomNpcsPermissions.hasPermission(player, CustomNpcsPermissions.EDIT_BLOCKS)) {
            TileBigSign tile = (TileBigSign)par1World.func_175625_s(pos);
            if (tile.func_145832_p() >= 2) {
                return false;
            }
            tile.canEdit = true;
            NoppesUtilServer.sendOpenGui(player, EnumGuiType.BigSign, null, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            return true;
        }
        return false;
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase entity, ItemStack stack) {
        int l = MathHelper.func_76128_c((double)((double)(entity.field_70177_z * (float)this.maxRotation() / 360.0f) + 0.5)) & this.maxRotation() - 1;
        TileTombstone tile = (TileTombstone)world.func_175625_s(pos);
        tile.rotation = l %= this.maxRotation();
        world.func_180501_a(pos, state.func_177226_a((IProperty)DAMAGE, (Comparable)Integer.valueOf(stack.func_77952_i())), 2);
        if (entity instanceof EntityPlayer && !world.field_72995_K && stack.func_77952_i() < 2) {
            NoppesUtilServer.sendOpenGui((EntityPlayer)entity, EnumGuiType.BigSign, null, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        }
    }

    public int maxRotation() {
        return 4;
    }

    public void func_180654_a(IBlockAccess world, BlockPos pos) {
        TileEntity tileentity = world.func_175625_s(pos);
        if (!(tileentity instanceof TileTombstone)) {
            super.func_180654_a(world, pos);
            return;
        }
        TileTombstone tile = (TileTombstone)tileentity;
        if (tile.rotation % 2 == 0) {
            this.func_149676_a(0.0f, 0.0f, 0.3f, 1.0f, 1.0f, 0.7f);
        } else {
            this.func_149676_a(0.3f, 0.0f, 0.0f, 0.7f, 1.0f, 1.0f);
        }
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public void func_149666_a(Item par1, CreativeTabs par2CreativeTabs, List par3List) {
        par3List.add(new ItemStack(par1, 1, 0));
        par3List.add(new ItemStack(par1, 1, 1));
        par3List.add(new ItemStack(par1, 1, 2));
    }

    public TileEntity func_149915_a(World var1, int var2) {
        return new TileTombstone();
    }

    @Override
    public TileEntity getTile() {
        if (this.renderTile == null) {
            this.renderTile = this.func_149915_a(null, 0);
        }
        return this.renderTile;
    }
}

