/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.blocks.tiles;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraftforge.fml.common.eventhandler.Event;
import noppes.npcs.CustomItems;
import noppes.npcs.EventHooks;
import noppes.npcs.NBTTags;
import noppes.npcs.NoppesUtilPlayer;
import noppes.npcs.api.block.IBlock;
import noppes.npcs.api.wrapper.BlockScriptedWrapper;
import noppes.npcs.blocks.tiles.TileNpcEntity;
import noppes.npcs.constants.EnumScriptType;
import noppes.npcs.controllers.IScriptBlockHandler;
import noppes.npcs.controllers.ScriptContainer;
import noppes.npcs.controllers.ScriptController;
import noppes.npcs.entity.data.DataTimers;
import noppes.npcs.util.ValueUtil;

public class TileScripted
extends TileNpcEntity
implements ITickable,
IScriptBlockHandler {
    public List<ScriptContainer> scripts = new ArrayList<ScriptContainer>();
    public String scriptLanguage = "ECMAScript";
    public boolean enabled = false;
    private IBlock blockDummy = null;
    public DataTimers timers = new DataTimers(this);
    public boolean hasInited = false;
    private short ticksExisted = 0;
    public ItemStack itemModel = new ItemStack(CustomItems.scripted);
    public boolean needsClientUpdate = false;
    public int powering = 0;
    public int activePowering = 0;
    public int prevPower = 0;
    public boolean isLadder = false;
    public int lightValue = 0;
    public int rotationX = 0;
    public int rotationY = 0;
    public int rotationZ = 0;
    public float scaleX = 1.0f;
    public float scaleY = 1.0f;
    public float scaleZ = 1.0f;
    public TileEntity renderTile;
    public boolean renderTileErrored = true;
    public ITickable renderTileUpdate = null;

    @Override
    public IBlock getBlock() {
        if (this.blockDummy == null) {
            this.blockDummy = new BlockScriptedWrapper(this.func_145831_w(), this.func_145838_q(), this.func_174877_v());
        }
        return this.blockDummy;
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.setNBT(compound);
        this.setDisplayNBT(compound);
    }

    public void setNBT(NBTTagCompound compound) {
        this.scripts = NBTTags.GetScript(compound.func_150295_c("Scripts", 10));
        this.scriptLanguage = compound.func_74779_i("ScriptLanguage");
        this.enabled = compound.func_74767_n("ScriptEnabled");
        this.activePowering = this.powering = compound.func_74762_e("BlockPowering");
        this.prevPower = compound.func_74762_e("BlockPrevPower");
    }

    public void setDisplayNBT(NBTTagCompound compound) {
        this.itemModel = ItemStack.func_77949_a((NBTTagCompound)compound.func_74775_l("ScriptBlockModel"));
        if (this.itemModel == null || this.itemModel.func_77973_b() == null) {
            this.itemModel = new ItemStack(CustomItems.scripted);
        }
        this.renderTileUpdate = null;
        this.renderTile = null;
        this.renderTileErrored = false;
        this.lightValue = compound.func_74762_e("LightValue");
        this.isLadder = compound.func_74767_n("IsLadder");
        this.rotationX = compound.func_74762_e("RotationX");
        this.rotationY = compound.func_74762_e("RotationY");
        this.rotationZ = compound.func_74762_e("RotationZ");
        this.scaleX = compound.func_74760_g("ScaleX");
        this.scaleY = compound.func_74760_g("ScaleY");
        this.scaleZ = compound.func_74760_g("ScaleZ");
        if (this.scaleX <= 0.0f) {
            this.scaleX = 1.0f;
        }
        if (this.scaleY <= 0.0f) {
            this.scaleY = 1.0f;
        }
        if (this.scaleZ <= 0.0f) {
            this.scaleZ = 1.0f;
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound compound) {
        super.func_145841_b(compound);
        this.getNBT(compound);
        this.getDisplayNBT(compound);
    }

    public NBTTagCompound getNBT(NBTTagCompound compound) {
        compound.func_74782_a("Scripts", (NBTBase)NBTTags.NBTScript(this.scripts));
        compound.func_74778_a("ScriptLanguage", this.scriptLanguage);
        compound.func_74757_a("ScriptEnabled", this.enabled);
        compound.func_74768_a("BlockPowering", this.powering);
        compound.func_74768_a("BlockPrevPower", this.prevPower);
        return compound;
    }

    public NBTTagCompound getDisplayNBT(NBTTagCompound compound) {
        NBTTagCompound itemcompound = new NBTTagCompound();
        this.itemModel.func_77955_b(itemcompound);
        compound.func_74782_a("ScriptBlockModel", (NBTBase)itemcompound);
        compound.func_74768_a("LightValue", this.lightValue);
        compound.func_74757_a("IsLadder", this.isLadder);
        compound.func_74768_a("RotationX", this.rotationX);
        compound.func_74768_a("RotationY", this.rotationY);
        compound.func_74768_a("RotationZ", this.rotationZ);
        compound.func_74776_a("ScaleX", this.scaleX);
        compound.func_74776_a("ScaleY", this.scaleY);
        compound.func_74776_a("ScaleZ", this.scaleZ);
        return compound;
    }

    private boolean isEnabled() {
        return this.enabled && ScriptController.HasStart && !this.field_145850_b.field_72995_K;
    }

    public void func_73660_a() {
        if (this.renderTileUpdate != null) {
            try {
                this.renderTileUpdate.func_73660_a();
            }
            catch (Exception e) {
                this.renderTileUpdate = null;
            }
        }
        this.ticksExisted = (short)(this.ticksExisted + 1);
        if (this.ticksExisted >= 10) {
            EventHooks.onScriptBlockUpdate(this);
            this.ticksExisted = 0;
            if (this.needsClientUpdate) {
                this.field_145850_b.func_175689_h(this.field_174879_c);
                this.needsClientUpdate = false;
            }
        }
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        int light = this.lightValue;
        this.setDisplayNBT(pkt.func_148857_g());
        if (light != this.lightValue) {
            this.field_145850_b.func_175664_x(this.field_174879_c);
        }
    }

    public Packet func_145844_m() {
        NBTTagCompound compound = new NBTTagCompound();
        this.getDisplayNBT(compound);
        S35PacketUpdateTileEntity packet = new S35PacketUpdateTileEntity(this.field_174879_c, 0, compound);
        return packet;
    }

    public void setItemModel(ItemStack item) {
        if (item == null || item.func_77973_b() == null) {
            item = new ItemStack(CustomItems.scripted);
        }
        if (NoppesUtilPlayer.compareItems(item, this.itemModel, false, false)) {
            return;
        }
        this.itemModel = item;
        this.needsClientUpdate = true;
    }

    public void setLightValue(int value) {
        if (value == this.lightValue) {
            return;
        }
        this.lightValue = ValueUtil.CorrectInt(value, 0, 15);
        this.needsClientUpdate = true;
    }

    public void setRedstonePower(int strength) {
        if (this.powering == strength) {
            return;
        }
        this.prevPower = this.activePowering = ValueUtil.CorrectInt(strength, 0, 15);
        this.field_145850_b.func_175685_c(this.field_174879_c, this.func_145838_q());
        this.powering = this.activePowering;
    }

    public void setScale(float x, float y, float z) {
        if (this.scaleX == x && this.scaleY == y && this.scaleZ == z) {
            return;
        }
        this.scaleX = ValueUtil.correctFloat(x, 0.0f, 10.0f);
        this.scaleY = ValueUtil.correctFloat(y, 0.0f, 10.0f);
        this.scaleZ = ValueUtil.correctFloat(z, 0.0f, 10.0f);
        this.needsClientUpdate = true;
    }

    public void setRotation(int x, int y, int z) {
        if (this.rotationX == x && this.rotationY == y && this.rotationZ == z) {
            return;
        }
        this.rotationX = ValueUtil.CorrectInt(x, 0, 359);
        this.rotationY = ValueUtil.CorrectInt(y, 0, 359);
        this.rotationZ = ValueUtil.CorrectInt(z, 0, 359);
        this.needsClientUpdate = true;
    }

    @Override
    public void runScript(EnumScriptType type, Event event) {
        if (!this.isEnabled()) {
            return;
        }
        if (!this.hasInited) {
            this.hasInited = true;
            EventHooks.onScriptBlockInit(this);
        }
        for (ScriptContainer script : this.scripts) {
            if (script.errored || !script.hasCode()) continue;
            script.setEngine(this.scriptLanguage);
            if (script.engine == null) continue;
            script.run(type, event);
        }
    }

    @Override
    public boolean isClient() {
        return this.func_145831_w().field_72995_K;
    }
}

