/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.entity.data;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.pathfinding.PathEntity;
import net.minecraft.util.BlockPos;
import noppes.npcs.NoppesUtilServer;
import noppes.npcs.api.wrapper.ItemStackWrapper;
import noppes.npcs.controllers.Line;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.entity.EntityProjectile;

public class DataScenes {
    public static int Ticks = 0;
    public static boolean HasStarted = false;
    private EntityNPCInterface npc;
    public SceneContainer mainScene = new SceneContainer();
    private EntityLivingBase owner = null;

    public DataScenes(EntityNPCInterface npc) {
        this.npc = npc;
    }

    public NBTTagCompound writeToNBT(NBTTagCompound compound) {
        compound.func_74782_a("MainScene", (NBTBase)this.mainScene.writeToNBT(new NBTTagCompound()));
        return compound;
    }

    public void readFromNBT(NBTTagCompound compound) {
        this.mainScene.readFromNBT(compound.func_74775_l("MainScene"));
    }

    public EntityLivingBase getOwner() {
        return this.owner;
    }

    public static void Start(ICommandSender player) {
        if (HasStarted) {
            return;
        }
        HasStarted = true;
        if (Ticks == 0) {
            NoppesUtilServer.NotifyOPs(player, "Scene started");
        } else {
            NoppesUtilServer.NotifyOPs(player, "Scene continued");
        }
    }

    public static void Pause(ICommandSender player) {
        if (!HasStarted) {
            return;
        }
        NoppesUtilServer.NotifyOPs(player, "Scene paused at " + Ticks);
        HasStarted = false;
    }

    public static void Reset(ICommandSender player) {
        if (Ticks <= 0) {
            return;
        }
        Ticks = 0;
        HasStarted = false;
        NoppesUtilServer.NotifyOPs(player, "Scene reset");
    }

    public static void Forward(EntityPlayerMP player, int ticks) {
        if (HasStarted) {
            HasStarted = false;
        }
        if ((Ticks += ticks) < 0) {
            Ticks = 0;
        }
        NoppesUtilServer.NotifyOPs((ICommandSender)player, "Scene time set to " + Ticks);
    }

    public void update() {
        if (!HasStarted && this.owner != null) {
            this.owner = null;
        }
        this.mainScene.update();
    }

    public static enum SceneType {
        ANIMATE,
        MOVE,
        FACTION,
        COMMAND,
        EQUIP,
        THROW,
        ATTACK,
        FOLLOW,
        SAY,
        ROTATE;

    }

    public static class SceneEvent
    implements Comparable<SceneEvent> {
        public int ticks = 0;
        public SceneType type;
        public String param = "";

        public String toString() {
            return this.ticks + " " + this.type.name() + " " + this.param;
        }

        public static SceneEvent parse(String str) {
            SceneEvent event = new SceneEvent();
            int i = str.indexOf(" ");
            if (i <= 0) {
                return null;
            }
            try {
                event.ticks = Integer.parseInt(str.substring(0, i));
                str = str.substring(i + 1);
            }
            catch (NumberFormatException ex) {
                return null;
            }
            i = str.indexOf(" ");
            if (i <= 0) {
                return null;
            }
            String name = str.substring(0, i);
            for (SceneType type : SceneType.values()) {
                if (!name.equalsIgnoreCase(type.name())) continue;
                event.type = type;
            }
            if (event.type == null) {
                return null;
            }
            event.param = str.substring(i + 1);
            return event;
        }

        @Override
        public int compareTo(SceneEvent o) {
            return this.ticks - o.ticks;
        }
    }

    public class SceneContainer {
        public String lines = "";
        public boolean enabled = false;
        private List<SceneEvent> events = new ArrayList<SceneEvent>();
        private int prevTick = -1;

        public NBTTagCompound writeToNBT(NBTTagCompound compound) {
            compound.func_74757_a("Enabled", this.enabled);
            compound.func_74778_a("Lines", this.lines);
            return compound;
        }

        public void readFromNBT(NBTTagCompound compound) {
            this.enabled = compound.func_74767_n("Enabled");
            this.lines = compound.func_74779_i("Lines");
            this.events = new ArrayList<SceneEvent>();
            for (String line : this.lines.split("\r\n|\r|\n")) {
                SceneEvent event = SceneEvent.parse(line);
                if (event == null) continue;
                this.events.add(event);
            }
            Collections.sort(this.events);
        }

        public void update() {
            if (!this.enabled || !HasStarted || this.prevTick == Ticks || this.events.isEmpty()) {
                return;
            }
            for (SceneEvent event : this.events) {
                if (event.ticks > Ticks) break;
                if (event.ticks != Ticks) continue;
                try {
                    this.handle(event);
                }
                catch (Exception exception) {}
            }
            this.prevTick = Ticks;
        }

        private void handle(SceneEvent event) throws Exception {
            if (event.type == SceneType.MOVE) {
                String[] param = event.param.split(" ");
                while (param.length > 1) {
                    boolean move = false;
                    if (param[0].startsWith("to")) {
                        move = true;
                    } else if (!param[0].startsWith("tp")) break;
                    BlockPos pos = null;
                    if (param[0].startsWith("@")) {
                        EntityLivingBase entitylivingbase = (EntityLivingBase)CommandBase.func_175759_a((ICommandSender)DataScenes.this.npc, (String)param[0], EntityLivingBase.class);
                        if (entitylivingbase != null) {
                            pos = entitylivingbase.func_180425_c();
                        }
                        param = Arrays.copyOfRange(param, 2, param.length);
                    } else {
                        if (param.length < 4) {
                            return;
                        }
                        pos = CommandBase.func_175757_a((ICommandSender)DataScenes.this.npc, (String[])param, (int)1, (boolean)false);
                        param = Arrays.copyOfRange(param, 4, param.length);
                    }
                    if (pos == null) continue;
                    ((DataScenes)DataScenes.this).npc.ai.setStartPos(pos);
                    DataScenes.this.npc.func_70661_as().func_75499_g();
                    if (move) {
                        PathEntity pathentity = DataScenes.this.npc.func_70661_as().func_179680_a(pos);
                        DataScenes.this.npc.func_70661_as().func_75484_a(pathentity, 1.0);
                        continue;
                    }
                    if (DataScenes.this.npc.isInRange((double)pos.func_177958_n() + 0.5, pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, 2.0)) continue;
                    DataScenes.this.npc.func_70107_b((double)pos.func_177958_n() + 0.5, pos.func_177956_o(), (double)pos.func_177952_p() + 0.5);
                }
            } else if (event.type == SceneType.SAY) {
                DataScenes.this.npc.saySurrounding(new Line(event.param));
            } else if (event.type == SceneType.ROTATE) {
                ((DataScenes)DataScenes.this).npc.lookAi.func_75251_c();
                if (event.param.startsWith("@")) {
                    EntityLivingBase entitylivingbase = (EntityLivingBase)CommandBase.func_175759_a((ICommandSender)DataScenes.this.npc, (String)event.param, EntityLivingBase.class);
                    ((DataScenes)DataScenes.this).npc.lookAi.rotate((Entity)((DataScenes)DataScenes.this).npc.field_70170_p.func_72890_a((Entity)entitylivingbase, 30.0));
                } else {
                    ((DataScenes)DataScenes.this).npc.lookAi.rotate(Integer.parseInt(event.param));
                }
            } else if (event.type == SceneType.EQUIP) {
                String[] args = event.param.split(" ");
                if (args.length < 2) {
                    return;
                }
                ItemStackWrapper itemstack = null;
                if (!args[1].equalsIgnoreCase("none")) {
                    Item item = CommandBase.func_147179_f((ICommandSender)DataScenes.this.npc, (String)args[1]);
                    int i = args.length >= 3 ? CommandBase.func_175764_a((String)args[2], (int)1, (int)64) : 1;
                    int j = args.length >= 4 ? CommandBase.func_175755_a((String)args[3]) : 0;
                    itemstack = new ItemStackWrapper(new ItemStack(item, i, j));
                }
                if (args[0].equalsIgnoreCase("main")) {
                    ((DataScenes)DataScenes.this).npc.inventory.weapons.put(0, itemstack);
                } else if (args[0].equalsIgnoreCase("off")) {
                    ((DataScenes)DataScenes.this).npc.inventory.weapons.put(2, itemstack);
                } else if (args[0].equalsIgnoreCase("proj")) {
                    ((DataScenes)DataScenes.this).npc.inventory.weapons.put(1, itemstack);
                } else if (args[0].equalsIgnoreCase("head")) {
                    ((DataScenes)DataScenes.this).npc.inventory.armor.put(0, itemstack);
                } else if (args[0].equalsIgnoreCase("body")) {
                    ((DataScenes)DataScenes.this).npc.inventory.armor.put(1, itemstack);
                } else if (args[0].equalsIgnoreCase("legs")) {
                    ((DataScenes)DataScenes.this).npc.inventory.armor.put(2, itemstack);
                } else if (args[0].equalsIgnoreCase("boots")) {
                    ((DataScenes)DataScenes.this).npc.inventory.armor.put(3, itemstack);
                }
            } else if (event.type == SceneType.ATTACK) {
                if (event.param.equals("none")) {
                    DataScenes.this.npc.func_70624_b(null);
                } else {
                    EntityLivingBase entity = (EntityLivingBase)CommandBase.func_175759_a((ICommandSender)DataScenes.this.npc, (String)event.param, EntityLivingBase.class);
                    if (entity != null) {
                        DataScenes.this.npc.func_70624_b(entity);
                    }
                }
            } else if (event.type == SceneType.THROW) {
                String[] args = event.param.split(" ");
                EntityLivingBase entity = (EntityLivingBase)CommandBase.func_175759_a((ICommandSender)DataScenes.this.npc, (String)args[0], EntityLivingBase.class);
                if (entity == null) {
                    return;
                }
                float damage = Float.parseFloat(args[1]);
                if (damage <= 0.0f) {
                    damage = 0.01f;
                }
                ItemStack stack = ItemStackWrapper.MCItem(((DataScenes)DataScenes.this).npc.inventory.getProjectile());
                if (args.length > 2) {
                    Item item = CommandBase.func_147179_f((ICommandSender)DataScenes.this.npc, (String)args[2]);
                    stack = new ItemStack(item, 1, 0);
                }
                EntityProjectile projectile = DataScenes.this.npc.shoot(entity, 100, stack, false);
                projectile.damage = damage;
            } else if (event.type == SceneType.ANIMATE) {
                ((DataScenes)DataScenes.this).npc.animateAi.temp = 0;
                if (event.param.equalsIgnoreCase("sleep")) {
                    ((DataScenes)DataScenes.this).npc.animateAi.temp = 2;
                } else if (event.param.equalsIgnoreCase("sneak")) {
                    ((DataScenes)DataScenes.this).npc.ai.animationType = 4;
                } else if (event.param.equalsIgnoreCase("normal")) {
                    ((DataScenes)DataScenes.this).npc.ai.animationType = 0;
                } else if (event.param.equalsIgnoreCase("sit")) {
                    ((DataScenes)DataScenes.this).npc.animateAi.temp = 1;
                } else if (event.param.equalsIgnoreCase("crawl")) {
                    ((DataScenes)DataScenes.this).npc.ai.animationType = 7;
                } else if (event.param.equalsIgnoreCase("bow")) {
                    ((DataScenes)DataScenes.this).npc.animateAi.temp = 11;
                } else if (event.param.equalsIgnoreCase("yes")) {
                    ((DataScenes)DataScenes.this).npc.animateAi.temp = 13;
                } else if (event.param.equalsIgnoreCase("no")) {
                    ((DataScenes)DataScenes.this).npc.animateAi.temp = 12;
                }
            } else if (event.type == SceneType.COMMAND) {
                NoppesUtilServer.runCommand(DataScenes.this.npc, DataScenes.this.npc.func_70005_c_(), event.param, null);
            } else if (event.type == SceneType.FACTION) {
                DataScenes.this.npc.setFaction(Integer.parseInt(event.param));
            } else if (event.type == SceneType.FOLLOW) {
                if (event.param.equalsIgnoreCase("none")) {
                    DataScenes.this.owner = null;
                } else {
                    EntityLivingBase entity = (EntityLivingBase)CommandBase.func_175759_a((ICommandSender)DataScenes.this.npc, (String)event.param, EntityLivingBase.class);
                    if (entity == null) {
                        return;
                    }
                    DataScenes.this.owner = entity;
                }
            }
        }
    }
}

