/*
 * Decompiled with CFR 0.152.
 */
package noppes.animalbikes.client.renderer;

import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelSlime;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.ResourceLocation;
import noppes.animalbikes.client.layer.LayerSlimeBike;
import noppes.animalbikes.client.model.ModelMagma;
import noppes.animalbikes.client.renderer.RenderAnimalBike;
import noppes.animalbikes.entity.EntitySlimeBike;
import noppes.animalbikes.entity.types.EntityRidable;

public class RenderSlimeBike<T extends EntitySlimeBike>
extends RenderAnimalBike<T> {
    private static final ResourceLocation slimeTextures = new ResourceLocation("animalbikes:textures/entity/slime.png");
    private static final ResourceLocation magmaCubeTextures = new ResourceLocation("textures/entity/slime/magmacube.png");
    private ModelBase slime;
    private ModelBase magma;

    public RenderSlimeBike() {
        super((ModelBase)new ModelSlime(16), 0.25f);
        this.slime = this.field_77045_g;
        this.magma = new ModelMagma();
        this.func_177094_a(new LayerSlimeBike(this));
    }

    protected void preRenderCallback(T bike, float par2) {
        if (!((EntityRidable)((Object)bike)).isSpecial()) {
            float f1 = 2.0f;
            float f2 = (((EntitySlimeBike)((Object)bike)).prevSquishFactor + (((EntitySlimeBike)((Object)bike)).squishFactor - ((EntitySlimeBike)((Object)bike)).prevSquishFactor) * par2) / (f1 * 0.5f + 1.0f);
            float f3 = 1.0f / (f2 + 1.0f);
            ((EntitySlimeBike)((Object)bike)).offset = 1.0f / f3;
            GlStateManager.func_179152_a((float)(f3 * f1), (float)(1.0f / f3 * f1), (float)(f3 * f1));
        } else {
            float f1 = (((EntitySlimeBike)((Object)bike)).prevSquishFactor + (((EntitySlimeBike)((Object)bike)).squishFactor - ((EntitySlimeBike)((Object)bike)).prevSquishFactor) * par2) / 2.0f;
            float f2 = 1.0f / (f1 + 1.0f);
            float f3 = 2.0f;
            GlStateManager.func_179152_a((float)(f2 * f3), (float)2.0f, (float)(f2 * f3));
        }
    }

    protected ResourceLocation getEntityTexture(T entity) {
        return ((EntityRidable)((Object)entity)).isSpecial() ? magmaCubeTextures : slimeTextures;
    }

    @Override
    public void doRender(T entity, double d, double d1, double d2, float f, float f1) {
        this.field_77045_g = ((EntityRidable)((Object)entity)).isSpecial() ? this.magma : this.slime;
        ((EntitySlimeBike)((Object)entity)).canColor = !((EntityRidable)((Object)entity)).isSpecial();
        super.doRender(entity, d, d1, d2, f, f1);
    }
}

