/*
 * Decompiled with CFR 0.152.
 */
package noppes.animalbikes.entity;

import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemPickaxe;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockPos;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import noppes.animalbikes.entity.types.EntityRidable;

public class EntitySilverfishBike
extends EntityRidable {
    private int destroyTimer = 0;

    public EntitySilverfishBike(World world) {
        super(world);
        this.func_70105_a(0.9f, 1.2f);
        this.walkSpeed = 0.15f;
    }

    public EntitySilverfishBike(World world, double d, double d1, double d2) {
        this(world);
        this.func_70107_b(d, d1, d2);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(18, (Object)0);
    }

    public double func_70042_X() {
        if (this.isBigger()) {
            return 0.4;
        }
        return 0.3;
    }

    public boolean isBigger() {
        return this.field_70180_af.func_75683_a(18) == 1;
    }

    private void setBigger(boolean flag) {
        this.field_70180_af.func_75692_b(18, (Object)((byte)(flag ? 1 : 0)));
    }

    public void func_70071_h_() {
        this.field_70761_aq = this.field_70177_z;
        super.func_70071_h_();
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (this.rider != null && !this.field_70170_p.field_72995_K) {
            this.destroyBlocksInAABB();
        }
    }

    private void destroyBlocksInAABB() {
        if (this.destroyTimer > 0) {
            if (this.destroyTimer == 3) {
                this.setBigger(false);
            }
            --this.destroyTimer;
            return;
        }
        if (this.field_70703_bu) {
            return;
        }
        EntityPlayerMP player = (EntityPlayerMP)this.rider;
        if (!player.field_71075_bZ.field_75099_e) {
            return;
        }
        ItemStack item = player.field_71071_by.func_70448_g();
        if (item == null || !(item.func_77973_b() instanceof ItemPickaxe)) {
            return;
        }
        double dx = -MathHelper.func_76126_a((float)((float)((double)(this.field_70177_z / 180.0f) * Math.PI))) * MathHelper.func_76134_b((float)((float)((double)(this.field_70125_A / 180.0f) * Math.PI)));
        double dz = MathHelper.func_76134_b((float)((float)((double)(this.field_70177_z / 180.0f) * Math.PI))) * MathHelper.func_76134_b((float)((float)((double)(this.field_70125_A / 180.0f) * Math.PI)));
        BlockPos pos = new BlockPos(this.field_70165_t + dx, this.field_70163_u, this.field_70161_v + dz);
        this.mine(player, pos);
        this.mine(player, pos.func_177984_a());
        if (this.func_70093_af()) {
            this.mine(player, pos.func_177977_b());
        }
        if (this.isBigger()) {
            item.func_77972_a(1, (EntityLivingBase)player);
        }
    }

    private void mine(EntityPlayerMP player, BlockPos pos) {
        IBlockState state = this.field_70170_p.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (block == null) {
            return;
        }
        if (!block.func_149703_v()) {
            return;
        }
        if (block.func_180640_a(this.field_70170_p, pos, state) == null) {
            return;
        }
        if (!block.func_149688_o().func_76220_a()) {
            return;
        }
        if (block.func_176195_g(this.field_70170_p, pos) < 0.0f) {
            return;
        }
        this.field_70170_p.func_175698_g(pos);
        this.field_70170_p.func_180498_a((EntityPlayer)player, 2001, pos, Block.func_176210_f((IBlockState)state));
        block.func_180657_a(this.field_70170_p, (EntityPlayer)player, pos, state, this.field_70170_p.func_175625_s(pos));
        this.destroyTimer = 30;
        this.setBigger(true);
    }

    protected String func_70639_aQ() {
        return "mob.silverfish.say";
    }

    protected String func_70621_aR() {
        return "mob.silverfish.hit";
    }

    protected String func_70673_aS() {
        return "mob.silverfish.kill";
    }

    protected void func_180429_a(BlockPos pos, Block bock) {
        this.field_70170_p.func_72956_a((Entity)this, "mob.silverfish.step", 1.0f, 1.0f);
    }
}

