/*
 * Decompiled with CFR 0.152.
 */
package me.Austin.client.gui.theme.Laser;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import me.Austin.client.gui.theme.Laser.LaserTheme;
import org.darkstorm.minecraft.gui.component.Button;
import org.darkstorm.minecraft.gui.component.Container;
import org.darkstorm.minecraft.gui.theme.AbstractComponentUI;
import org.darkstorm.minecraft.gui.util.RenderUtil;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class LaserButtonUI
extends AbstractComponentUI<Button> {
    private final LaserTheme theme;

    LaserButtonUI(LaserTheme theme) {
        super(Button.class);
        this.theme = theme;
        this.foreground = Color.WHITE;
        this.background = new Color(255, 100, 100, 192);
    }

    @Override
    protected void renderComponent(Button button) {
        this.translateComponent(button, false);
        Rectangle area = button.getArea();
        GL11.glEnable((int)3042);
        GL11.glDisable((int)2884);
        GL11.glDisable((int)3553);
        RenderUtil.setColor(button.getBackgroundColor());
        GL11.glBegin((int)7);
        GL11.glVertex2d((double)0.0, (double)0.0);
        GL11.glVertex2d((double)area.width, (double)0.0);
        GL11.glVertex2d((double)area.width, (double)area.height);
        GL11.glVertex2d((double)0.0, (double)area.height);
        GL11.glEnd();
        Point mouse = RenderUtil.calculateMouseLocation();
        Container parent = button.getParent();
        while (parent != null) {
            mouse.x -= parent.getX();
            mouse.y -= parent.getY();
            parent = parent.getParent();
        }
        if (area.contains(mouse)) {
            GL11.glColor4f((float)0.0f, (float)0.0f, (float)0.0f, (float)(Mouse.isButtonDown((int)0) ? 0.5f : 0.3f));
            GL11.glBegin((int)7);
            GL11.glVertex2d((double)0.0, (double)0.0);
            GL11.glVertex2d((double)area.width, (double)0.0);
            GL11.glVertex2d((double)area.width, (double)area.height);
            GL11.glVertex2d((double)0.0, (double)area.height);
            GL11.glEnd();
        }
        GL11.glEnable((int)3553);
        String text = button.getText();
        this.theme.getFontRenderer().drawString(text, area.width / 2 - this.theme.getFontRenderer().getStringWidth(text) / 2, area.height / 2 - this.theme.getFontRenderer().FONT_HEIGHT / 2, RenderUtil.toRGBA(button.getForegroundColor()));
        GL11.glEnable((int)2884);
        GL11.glDisable((int)3042);
        this.translateComponent(button, true);
    }

    @Override
    protected Dimension getDefaultComponentSize(Button component) {
        return new Dimension(this.theme.getFontRenderer().getStringWidth(component.getText()) + 4, this.theme.getFontRenderer().FONT_HEIGHT + 4);
    }

    @Override
    protected Rectangle[] getInteractableComponentRegions(Button component) {
        return new Rectangle[]{new Rectangle(0, 0, component.getWidth(), component.getHeight())};
    }

    @Override
    protected void handleComponentInteraction(Button component, Point location, int button) {
        if (location.x <= component.getWidth() && location.y <= component.getHeight() && button == 0) {
            component.press();
        }
    }
}

