//OpenGL version used for this shader (1.2)
#version 120

//Sampler, contains the texture of the Entity FBO
uniform sampler2D DiffuseSamper;

//Contains the size of one texel
uniform vec2 TexelSize;

void main(){
  //Color of the texel at this fragment
  vec4 centerCol = texture2D(DiffuseSamper, gl_TexCoord[0].st);

  //Holds the average color (for blur/glow)
  vec4 colAvg = vec4(0, 0, 0, 0);
  //Iterate through surrounding texels
  for(int xo = -7; xo < 7; xo++) {
    for(int yo = -7; yo < 7; yo++) {
      //Get surrounding texel color
      vec4 currCol = texture2D(DiffuseSamper, gl_TexCoord[0].st + vec2(xo * TexelSize.x, yo * TexelSize.y));

      //If color has been changed (!= 0), add to average color. Alpha depends on distance to center texel
      if(currCol.r != 0.0F || currCol.g != 0.0F || currCol.b != 0.0F) {
      //Add to the average color. Currently uses an RGB of #FF0000.
      //The alpha value is calculated by distance to the center texel
      colAvg += vec4(1, 0, 0, max(0, (6.0f - sqrt(xo*xo*1.0f + yo*yo*1.0f)) / 2.0F));
      }
    }
  }

  //Divide alpha to calculate an average
  colAvg.a /= 64.0F;

  //Return calculated color at this fragment
  gl_FragColor = colAvg;
}