/*
 * Decompiled with CFR 0.152.
 */
package me.protocol_client.utils;

import java.util.ArrayList;
import java.util.UUID;
import me.protocol_client.Wrapper;
import me.protocol_client.friendsList.FriendManager;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.MathHelper;

public class EntityUtils {
    public static boolean lookChanged;
    public static float yaw;
    public static float pitch;
    private static boolean set;
    private static EntityPlayer reference;

    static {
        set = false;
    }

    public static EntityPlayer getReference() {
        EntityPlayer entityPlayer;
        if (reference == null) {
            reference = Wrapper.getPlayer();
            entityPlayer = reference;
        } else {
            entityPlayer = set ? Wrapper.getPlayer() : reference;
        }
        return entityPlayer;
    }

    private static final float limitAngleChange(float current, float intended, float maxChange) {
        float change = intended - current;
        if (change > maxChange) {
            change = maxChange;
        } else if (change < -maxChange) {
            change = -maxChange;
        }
        return current + change;
    }

    public static int getDistanceFromMouse(Entity entity) {
        float[] neededRotations = Wrapper.getRotationsNeeded(entity);
        if (neededRotations != null) {
            float neededYaw = Minecraft.getMinecraft().thePlayer.rotationYaw - neededRotations[0];
            float neededPitch = Minecraft.getMinecraft().thePlayer.rotationPitch - neededRotations[1];
            float distanceFromMouse = MathHelper.sqrt_float(neededYaw * neededYaw + neededPitch * neededPitch);
            return (int)distanceFromMouse;
        }
        return -1;
    }

    public static EntityLivingBase getClosestEntity() {
        EntityLivingBase closestEntity = null;
        for (Object o : Minecraft.getMinecraft().theWorld.loadedEntityList) {
            if (EntityUtils.getDistanceFromMouse((Entity)o) > 360) continue;
            EntityLivingBase en = (EntityLivingBase)o;
            if (o instanceof EntityPlayerSP || en.ticksExisted <= 20 || !FriendManager.isFriend(en.getName()) || en.isDead || !(en.getHealth() > 0.0f) || en.getName().equals(Minecraft.getMinecraft().thePlayer.getName()) || closestEntity != null && !(Minecraft.getMinecraft().thePlayer.getDistanceToEntity(en) < Minecraft.getMinecraft().thePlayer.getDistanceToEntity(closestEntity))) continue;
            closestEntity = en;
        }
        return closestEntity;
    }

    public static ArrayList<EntityLivingBase> getCloseEntities(boolean ignoreFriends, float range) {
        ArrayList<EntityLivingBase> closeEntities = new ArrayList<EntityLivingBase>();
        for (Object o : Minecraft.getMinecraft().theWorld.loadedEntityList) {
            EntityLivingBase en = (EntityLivingBase)o;
            if (o instanceof EntityPlayerSP || en.isDead || !(en.getHealth() > 0.0f) || !Minecraft.getMinecraft().thePlayer.canEntityBeSeen(en) || en.getName().equals(Minecraft.getMinecraft().thePlayer.getName()) || !(Minecraft.getMinecraft().thePlayer.getDistanceToEntity(en) <= range)) continue;
            closeEntities.add(en);
        }
        return closeEntities;
    }

    public static EntityLivingBase getClosestEntityRaw(boolean ignoreFriends) {
        EntityLivingBase closestEntity = null;
        for (Object o : Minecraft.getMinecraft().theWorld.loadedEntityList) {
            EntityLivingBase en = (EntityLivingBase)o;
            if (o instanceof EntityPlayerSP || en.isDead || !(en.getHealth() > 0.0f) || closestEntity != null && !(Minecraft.getMinecraft().thePlayer.getDistanceToEntity(en) < Minecraft.getMinecraft().thePlayer.getDistanceToEntity(closestEntity))) continue;
            closestEntity = en;
        }
        return closestEntity;
    }

    public static EntityLivingBase getClosestEnemy(EntityLivingBase friend) {
        EntityLivingBase closestEnemy = null;
        for (Object o : Minecraft.getMinecraft().theWorld.loadedEntityList) {
            EntityLivingBase en = (EntityLivingBase)o;
            if (o instanceof EntityPlayerSP || o == friend || en.isDead || en.getHealth() <= 0.0f || !Minecraft.getMinecraft().thePlayer.canEntityBeSeen(en) || closestEnemy != null && !(Minecraft.getMinecraft().thePlayer.getDistanceToEntity(en) < Minecraft.getMinecraft().thePlayer.getDistanceToEntity(closestEnemy))) continue;
            closestEnemy = en;
        }
        return closestEnemy;
    }

    public static EntityLivingBase searchEntityByIdRaw(UUID ID) {
        EntityLivingBase newEntity = null;
        for (Object o : Minecraft.getMinecraft().theWorld.loadedEntityList) {
            EntityLivingBase en = (EntityLivingBase)o;
            if (o instanceof EntityPlayerSP || en.isDead || newEntity != null || !en.getUniqueID().equals(ID)) continue;
            newEntity = en;
        }
        return newEntity;
    }

    public static EntityLivingBase searchEntityByName(String name) {
        EntityLivingBase newEntity = null;
        for (Object o : Minecraft.getMinecraft().theWorld.loadedEntityList) {
            EntityLivingBase en = (EntityLivingBase)o;
            if (o instanceof EntityPlayerSP || en.isDead || !Minecraft.getMinecraft().thePlayer.canEntityBeSeen(en) || newEntity != null || !en.getName().equals(name)) continue;
            newEntity = en;
        }
        return newEntity;
    }

    public static EntityLivingBase searchEntityByNameRaw(String name) {
        EntityLivingBase newEntity = null;
        for (Object o : Minecraft.getMinecraft().theWorld.loadedEntityList) {
            EntityLivingBase en = (EntityLivingBase)o;
            if (o instanceof EntityPlayerSP || en.isDead || newEntity != null || !en.getName().equals(name)) continue;
            newEntity = en;
        }
        return newEntity;
    }
}

