/*
 * Decompiled with CFR 0.152.
 */
package me.protocol_client.utils;

import java.util.HashMap;
import org.lwjgl.opengl.GL11;

public final class Stencil {
    private static final Stencil INSTANCE = new Stencil();
    private final HashMap<Integer, StencilFunc> stencilFuncs = new HashMap();
    private int layers = 1;
    private boolean renderMask;

    public static Stencil getInstance() {
        return INSTANCE;
    }

    public void setRenderMask(boolean renderMask) {
        this.renderMask = renderMask;
    }

    public void startLayer() {
        if (this.layers == 1) {
            GL11.glClearStencil((int)0);
            GL11.glClear((int)1024);
        }
        GL11.glEnable((int)2960);
        ++this.layers;
        if (this.layers > this.getMaximumLayers()) {
            System.out.println("StencilUtil: Reached maximum amount of layers!");
            this.layers = 1;
            return;
        }
    }

    public void stopLayer() {
        if (this.layers == 1) {
            System.out.println("StencilUtil: No layers found!");
            return;
        }
        --this.layers;
        if (this.layers == 1) {
            GL11.glDisable((int)2960);
        } else {
            StencilFunc lastStencilFunc = this.stencilFuncs.remove(this.layers);
            if (lastStencilFunc != null) {
                lastStencilFunc.use();
            }
        }
    }

    public void clear() {
        GL11.glClearStencil((int)0);
        GL11.glClear((int)1024);
        this.stencilFuncs.clear();
        this.layers = 1;
    }

    public void setBuffer() {
        this.setStencilFunc(new StencilFunc(!this.renderMask ? 512 : 519, this.layers, this.getMaximumLayers(), 7681, 7680, 7680));
    }

    public void setBuffer(boolean set) {
        this.setStencilFunc(new StencilFunc(!this.renderMask ? 512 : 519, set ? this.layers : this.layers - 1, this.getMaximumLayers(), 7681, 7681, 7681));
    }

    public void cropOutside() {
        this.setStencilFunc(new StencilFunc(517, this.layers, this.getMaximumLayers(), 7680, 7680, 7680));
    }

    public void cropInside() {
        this.setStencilFunc(new StencilFunc(514, this.layers, this.getMaximumLayers(), 7680, 7680, 7680));
    }

    public void setStencilFunc(StencilFunc stencilFunc) {
        GL11.glStencilFunc((int)stencilFunc.func_func, (int)stencilFunc.func_ref, (int)stencilFunc.func_mask);
        GL11.glStencilOp((int)stencilFunc.op_fail, (int)stencilFunc.op_zfail, (int)stencilFunc.op_zpass);
        this.stencilFuncs.put(this.layers, stencilFunc);
    }

    public StencilFunc getStencilFunc() {
        return this.stencilFuncs.get(this.layers);
    }

    public int getLayer() {
        return this.layers;
    }

    public int getStencilBufferSize() {
        return GL11.glGetInteger((int)3415);
    }

    public int getMaximumLayers() {
        return (int)(Math.pow(2.0, this.getStencilBufferSize()) - 1.0);
    }

    public void createCirlce(double x, double y, double radius) {
        GL11.glBegin((int)6);
        int i = 0;
        while (i <= 360) {
            double sin = Math.sin((double)i * Math.PI / 180.0) * radius;
            double cos = Math.cos((double)i * Math.PI / 180.0) * radius;
            GL11.glVertex2d((double)(x + sin), (double)(y + cos));
            ++i;
        }
        GL11.glEnd();
    }

    public void createRect(double x, double y, double x2, double y2) {
        GL11.glBegin((int)7);
        GL11.glVertex2d((double)x, (double)y2);
        GL11.glVertex2d((double)x2, (double)y2);
        GL11.glVertex2d((double)x2, (double)y);
        GL11.glVertex2d((double)x, (double)y);
        GL11.glEnd();
    }

    public class StencilFunc {
        public final int func_func;
        public final int func_ref;
        public final int func_mask;
        public final int op_fail;
        public final int op_zfail;
        public final int op_zpass;

        public StencilFunc(int func_func, int func_ref, int func_mask, int op_fail, int op_zfail, int op_zpass) {
            this.func_func = func_func;
            this.func_ref = func_ref;
            this.func_mask = func_mask;
            this.op_fail = op_fail;
            this.op_zfail = op_zfail;
            this.op_zpass = op_zpass;
        }

        public void use() {
            GL11.glStencilFunc((int)this.func_func, (int)this.func_ref, (int)this.func_mask);
            GL11.glStencilOp((int)this.op_fail, (int)this.op_zfail, (int)this.op_zpass);
        }
    }
}

