/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockVine
extends Block {
    public static final PropertyBool UP = PropertyBool.create("up");
    public static final PropertyBool NORTH = PropertyBool.create("north");
    public static final PropertyBool EAST = PropertyBool.create("east");
    public static final PropertyBool SOUTH = PropertyBool.create("south");
    public static final PropertyBool WEST = PropertyBool.create("west");
    public static final PropertyBool[] ALL_FACES = new PropertyBool[]{UP, NORTH, SOUTH, WEST, EAST};
    protected static final AxisAlignedBB field_185757_g = new AxisAlignedBB(0.0, 0.9375, 0.0, 1.0, 1.0, 1.0);
    protected static final AxisAlignedBB field_185753_B = new AxisAlignedBB(0.0, 0.0, 0.0, 0.0625, 1.0, 1.0);
    protected static final AxisAlignedBB field_185754_C = new AxisAlignedBB(0.9375, 0.0, 0.0, 1.0, 1.0, 1.0);
    protected static final AxisAlignedBB field_185755_D = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 0.0625);
    protected static final AxisAlignedBB field_185756_E = new AxisAlignedBB(0.0, 0.0, 0.9375, 1.0, 1.0, 1.0);

    public BlockVine() {
        super(Material.vine);
        this.setDefaultState(this.blockState.getBaseState().withProperty(UP, false).withProperty(NORTH, false).withProperty(EAST, false).withProperty(SOUTH, false).withProperty(WEST, false));
        this.setTickRandomly(true);
        this.setCreativeTab(CreativeTabs.tabDecorations);
    }

    @Override
    public AxisAlignedBB getSelectedBoundingBox(IBlockState worldIn, World pos, BlockPos p_180646_3_) {
        return NULL_AABB;
    }

    @Override
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        state = state.getActualState(source, pos);
        int i = 0;
        AxisAlignedBB axisalignedbb = FULL_BLOCK_AABB;
        if (state.getValue(UP).booleanValue()) {
            axisalignedbb = field_185757_g;
            ++i;
        }
        if (state.getValue(NORTH).booleanValue()) {
            axisalignedbb = field_185755_D;
            ++i;
        }
        if (state.getValue(EAST).booleanValue()) {
            axisalignedbb = field_185754_C;
            ++i;
        }
        if (state.getValue(SOUTH).booleanValue()) {
            axisalignedbb = field_185756_E;
            ++i;
        }
        if (state.getValue(WEST).booleanValue()) {
            axisalignedbb = field_185753_B;
            ++i;
        }
        return i == 1 ? axisalignedbb : FULL_BLOCK_AABB;
    }

    @Override
    public IBlockState getActualState(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        return state.withProperty(UP, worldIn.getBlockState(pos.up()).isBlockNormalCube());
    }

    @Override
    public boolean isOpaqueCube(IBlockState p_149662_1_) {
        return false;
    }

    @Override
    public boolean isFullCube(IBlockState state) {
        return false;
    }

    @Override
    public boolean isReplaceable(IBlockAccess worldIn, BlockPos pos) {
        return true;
    }

    @Override
    public boolean canPlaceBlockOnSide(World worldIn, BlockPos pos, EnumFacing side) {
        switch (side) {
            case UP: {
                return this.func_185752_x(worldIn.getBlockState(pos.up()));
            }
            case NORTH: 
            case SOUTH: 
            case WEST: 
            case EAST: {
                return this.func_185752_x(worldIn.getBlockState(pos.offset(side.getOpposite())));
            }
        }
        return false;
    }

    private boolean func_185752_x(IBlockState p_185752_1_) {
        return p_185752_1_.isFullCube() && p_185752_1_.getMaterial().blocksMovement();
    }

    private boolean recheckGrownSides(World worldIn, BlockPos pos, IBlockState state) {
        IBlockState iblockstate = state;
        for (EnumFacing enumfacing : EnumFacing.Plane.HORIZONTAL) {
            IBlockState iblockstate1;
            PropertyBool propertybool = BlockVine.getPropertyFor(enumfacing);
            if (!state.getValue(propertybool).booleanValue() || this.func_185752_x(worldIn.getBlockState(pos.offset(enumfacing))) || (iblockstate1 = worldIn.getBlockState(pos.up())).getBlock() == this && iblockstate1.getValue(propertybool).booleanValue()) continue;
            state = state.withProperty(propertybool, false);
        }
        if (BlockVine.getNumGrownFaces(state) == 0) {
            return false;
        }
        if (iblockstate != state) {
            worldIn.setBlockState(pos, state, 2);
        }
        return true;
    }

    @Override
    public void onNeighborBlockChange(World worldIn, BlockPos pos, IBlockState state, Block neighborBlock) {
        if (!worldIn.isRemote && !this.recheckGrownSides(worldIn, pos, state)) {
            this.dropBlockAsItem(worldIn, pos, state, 0);
            worldIn.setBlockToAir(pos);
        }
    }

    @Override
    public void updateTick(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        if (!worldIn.isRemote && worldIn.rand.nextInt(4) == 0) {
            int i = 4;
            int j = 5;
            boolean flag = false;
            int k = -i;
            block0: while (k <= i) {
                int l = -i;
                while (l <= i) {
                    int i1 = -1;
                    while (i1 <= 1) {
                        if (worldIn.getBlockState(pos.add(k, i1, l)).getBlock() == this && --j <= 0) {
                            flag = true;
                            break block0;
                        }
                        ++i1;
                    }
                    ++l;
                }
                ++k;
            }
            EnumFacing enumfacing1 = EnumFacing.random(rand);
            BlockPos blockpos2 = pos.up();
            if (enumfacing1 == EnumFacing.UP && pos.getY() < 255 && worldIn.isAirBlock(blockpos2)) {
                if (!flag) {
                    IBlockState iblockstate2 = state;
                    for (EnumFacing enumfacing2 : EnumFacing.Plane.HORIZONTAL) {
                        if (!rand.nextBoolean() && this.func_185752_x(worldIn.getBlockState(blockpos2.offset(enumfacing2)))) continue;
                        iblockstate2 = iblockstate2.withProperty(BlockVine.getPropertyFor(enumfacing2), false);
                    }
                    if (iblockstate2.getValue(NORTH).booleanValue() || iblockstate2.getValue(EAST).booleanValue() || iblockstate2.getValue(SOUTH).booleanValue() || iblockstate2.getValue(WEST).booleanValue()) {
                        worldIn.setBlockState(blockpos2, iblockstate2, 2);
                    }
                }
            } else if (enumfacing1.getAxis().isHorizontal() && !state.getValue(BlockVine.getPropertyFor(enumfacing1)).booleanValue()) {
                if (!flag) {
                    BlockPos blockpos4 = pos.offset(enumfacing1);
                    IBlockState iblockstate3 = worldIn.getBlockState(blockpos4);
                    Block block1 = iblockstate3.getBlock();
                    if (block1.blockMaterial == Material.air) {
                        EnumFacing enumfacing3 = enumfacing1.rotateY();
                        EnumFacing enumfacing4 = enumfacing1.rotateYCCW();
                        boolean flag1 = state.getValue(BlockVine.getPropertyFor(enumfacing3));
                        boolean flag2 = state.getValue(BlockVine.getPropertyFor(enumfacing4));
                        BlockPos blockpos = blockpos4.offset(enumfacing3);
                        BlockPos blockpos1 = blockpos4.offset(enumfacing4);
                        if (flag1 && this.func_185752_x(worldIn.getBlockState(blockpos))) {
                            worldIn.setBlockState(blockpos4, this.getDefaultState().withProperty(BlockVine.getPropertyFor(enumfacing3), true), 2);
                        } else if (flag2 && this.func_185752_x(worldIn.getBlockState(blockpos1))) {
                            worldIn.setBlockState(blockpos4, this.getDefaultState().withProperty(BlockVine.getPropertyFor(enumfacing4), true), 2);
                        } else if (flag1 && worldIn.isAirBlock(blockpos) && this.func_185752_x(worldIn.getBlockState(pos.offset(enumfacing3)))) {
                            worldIn.setBlockState(blockpos, this.getDefaultState().withProperty(BlockVine.getPropertyFor(enumfacing1.getOpposite()), true), 2);
                        } else if (flag2 && worldIn.isAirBlock(blockpos1) && this.func_185752_x(worldIn.getBlockState(pos.offset(enumfacing4)))) {
                            worldIn.setBlockState(blockpos1, this.getDefaultState().withProperty(BlockVine.getPropertyFor(enumfacing1.getOpposite()), true), 2);
                        } else if (this.func_185752_x(worldIn.getBlockState(blockpos4.up()))) {
                            worldIn.setBlockState(blockpos4, this.getDefaultState(), 2);
                        }
                    } else if (block1.blockMaterial.isOpaque() && iblockstate3.isFullCube()) {
                        worldIn.setBlockState(pos, state.withProperty(BlockVine.getPropertyFor(enumfacing1), true), 2);
                    }
                }
            } else if (pos.getY() > 1) {
                BlockPos blockpos3 = pos.down();
                IBlockState iblockstate = worldIn.getBlockState(blockpos3);
                Block block = iblockstate.getBlock();
                if (block.blockMaterial == Material.air) {
                    IBlockState iblockstate1 = state;
                    for (EnumFacing enumfacing : EnumFacing.Plane.HORIZONTAL) {
                        if (!rand.nextBoolean()) continue;
                        iblockstate1 = iblockstate1.withProperty(BlockVine.getPropertyFor(enumfacing), false);
                    }
                    if (iblockstate1.getValue(NORTH).booleanValue() || iblockstate1.getValue(EAST).booleanValue() || iblockstate1.getValue(SOUTH).booleanValue() || iblockstate1.getValue(WEST).booleanValue()) {
                        worldIn.setBlockState(blockpos3, iblockstate1, 2);
                    }
                } else if (block == this) {
                    IBlockState iblockstate4 = iblockstate;
                    for (EnumFacing enumfacing5 : EnumFacing.Plane.HORIZONTAL) {
                        PropertyBool propertybool = BlockVine.getPropertyFor(enumfacing5);
                        if (!rand.nextBoolean() || !state.getValue(propertybool).booleanValue()) continue;
                        iblockstate4 = iblockstate4.withProperty(propertybool, true);
                    }
                    if (iblockstate4.getValue(NORTH).booleanValue() || iblockstate4.getValue(EAST).booleanValue() || iblockstate4.getValue(SOUTH).booleanValue() || iblockstate4.getValue(WEST).booleanValue()) {
                        worldIn.setBlockState(blockpos3, iblockstate4, 2);
                    }
                }
            }
        }
    }

    @Override
    public IBlockState onBlockPlaced(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        IBlockState iblockstate = this.getDefaultState().withProperty(UP, false).withProperty(NORTH, false).withProperty(EAST, false).withProperty(SOUTH, false).withProperty(WEST, false);
        return facing.getAxis().isHorizontal() ? iblockstate.withProperty(BlockVine.getPropertyFor(facing.getOpposite()), true) : iblockstate;
    }

    @Override
    public Item getItemDropped(IBlockState state, Random rand, int fortune) {
        return null;
    }

    @Override
    public int quantityDropped(Random random) {
        return 0;
    }

    @Override
    public void harvestBlock(World worldIn, EntityPlayer player, BlockPos pos, IBlockState state, TileEntity te, ItemStack p_180657_6_) {
        if (!worldIn.isRemote && p_180657_6_ != null && p_180657_6_.getItem() == Items.shears) {
            player.triggerAchievement(StatList.func_188055_a(this));
            BlockVine.spawnAsEntity(worldIn, pos, new ItemStack(Blocks.vine, 1, 0));
        } else {
            super.harvestBlock(worldIn, player, pos, state, te, p_180657_6_);
        }
    }

    @Override
    public BlockRenderLayer getBlockLayer() {
        return BlockRenderLayer.CUTOUT;
    }

    @Override
    public IBlockState getStateFromMeta(int meta) {
        return this.getDefaultState().withProperty(SOUTH, (meta & 1) > 0).withProperty(WEST, (meta & 2) > 0).withProperty(NORTH, (meta & 4) > 0).withProperty(EAST, (meta & 8) > 0);
    }

    @Override
    public int getMetaFromState(IBlockState state) {
        int i = 0;
        if (state.getValue(SOUTH).booleanValue()) {
            i |= 1;
        }
        if (state.getValue(WEST).booleanValue()) {
            i |= 2;
        }
        if (state.getValue(NORTH).booleanValue()) {
            i |= 4;
        }
        if (state.getValue(EAST).booleanValue()) {
            i |= 8;
        }
        return i;
    }

    @Override
    protected BlockStateContainer createBlockState() {
        return new BlockStateContainer(this, UP, NORTH, EAST, SOUTH, WEST);
    }

    @Override
    public IBlockState withRotation(IBlockState state, Rotation rot) {
        switch (rot) {
            case CLOCKWISE_180: {
                return state.withProperty(NORTH, state.getValue(SOUTH)).withProperty(EAST, state.getValue(WEST)).withProperty(SOUTH, state.getValue(NORTH)).withProperty(WEST, state.getValue(EAST));
            }
            case COUNTERCLOCKWISE_90: {
                return state.withProperty(NORTH, state.getValue(EAST)).withProperty(EAST, state.getValue(SOUTH)).withProperty(SOUTH, state.getValue(WEST)).withProperty(WEST, state.getValue(NORTH));
            }
            case CLOCKWISE_90: {
                return state.withProperty(NORTH, state.getValue(WEST)).withProperty(EAST, state.getValue(NORTH)).withProperty(SOUTH, state.getValue(EAST)).withProperty(WEST, state.getValue(SOUTH));
            }
        }
        return state;
    }

    @Override
    public IBlockState withMirror(IBlockState state, Mirror mirrorIn) {
        switch (mirrorIn) {
            case LEFT_RIGHT: {
                return state.withProperty(NORTH, state.getValue(SOUTH)).withProperty(SOUTH, state.getValue(NORTH));
            }
            case FRONT_BACK: {
                return state.withProperty(EAST, state.getValue(WEST)).withProperty(WEST, state.getValue(EAST));
            }
        }
        return super.withMirror(state, mirrorIn);
    }

    public static PropertyBool getPropertyFor(EnumFacing side) {
        switch (side) {
            case UP: {
                return UP;
            }
            case NORTH: {
                return NORTH;
            }
            case SOUTH: {
                return SOUTH;
            }
            case EAST: {
                return EAST;
            }
            case WEST: {
                return WEST;
            }
        }
        throw new IllegalArgumentException(side + " is an invalid choice");
    }

    public static int getNumGrownFaces(IBlockState state) {
        int i = 0;
        PropertyBool[] propertyBoolArray = ALL_FACES;
        int n = ALL_FACES.length;
        int n2 = 0;
        while (n2 < n) {
            PropertyBool propertybool = propertyBoolArray[n2];
            if (state.getValue(propertybool).booleanValue()) {
                ++i;
            }
            ++n2;
        }
        return i;
    }
}

