/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui;

import net.minecraft.client.Minecraft;
import net.minecraft.util.math.MathHelper;

public class ScaledResolution {
    private final double scaledWidthD;
    private final double scaledHeightD;
    private static int scaledWidth;
    private static int scaledHeight;
    private int scaleFactor;

    public ScaledResolution(Minecraft p_i46445_1_) {
        scaledWidth = p_i46445_1_.displayWidth;
        scaledHeight = p_i46445_1_.displayHeight;
        this.scaleFactor = 1;
        boolean flag = p_i46445_1_.isUnicode();
        int i = p_i46445_1_.gameSettings.guiScale;
        if (i == 0) {
            i = 1000;
        }
        while (this.scaleFactor < i && scaledWidth / (this.scaleFactor + 1) >= 320 && scaledHeight / (this.scaleFactor + 1) >= 240) {
            ++this.scaleFactor;
        }
        if (flag && this.scaleFactor % 2 != 0 && this.scaleFactor != 1) {
            --this.scaleFactor;
        }
        this.scaledWidthD = (double)scaledWidth / (double)this.scaleFactor;
        this.scaledHeightD = (double)scaledHeight / (double)this.scaleFactor;
        scaledWidth = MathHelper.ceiling_double_int(this.scaledWidthD);
        scaledHeight = MathHelper.ceiling_double_int(this.scaledHeightD);
    }

    public static int getScaledWidth() {
        return scaledWidth;
    }

    public static int getScaledHeight() {
        return scaledHeight;
    }

    public double getScaledWidth_double() {
        return this.scaledWidthD;
    }

    public double getScaledHeight_double() {
        return this.scaledHeightD;
    }

    public int getScaleFactor() {
        return this.scaleFactor;
    }
}

