/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.player;

import java.util.Arrays;
import java.util.concurrent.Callable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.ReportedException;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;

public class InventoryPlayer
implements IInventory {
    public final ItemStack[] mainInventory = new ItemStack[36];
    public final ItemStack[] armorInventory = new ItemStack[4];
    public final ItemStack[] field_184439_c = new ItemStack[1];
    private final ItemStack[][] field_184440_g = new ItemStack[][]{this.mainInventory, this.armorInventory, this.field_184439_c};
    public int currentItem;
    public EntityPlayer player;
    private ItemStack itemStack;
    public boolean inventoryChanged;

    public InventoryPlayer(EntityPlayer playerIn) {
        this.player = playerIn;
    }

    public ItemStack getCurrentItem() {
        return InventoryPlayer.func_184435_e(this.currentItem) ? this.mainInventory[this.currentItem] : null;
    }

    public static int getHotbarSize() {
        return 9;
    }

    private boolean func_184436_a(ItemStack p_184436_1_, ItemStack p_184436_2_) {
        return p_184436_1_ != null && this.func_184431_b(p_184436_1_, p_184436_2_) && p_184436_1_.isStackable() && p_184436_1_.stackSize < p_184436_1_.getMaxStackSize() && p_184436_1_.stackSize < this.getInventoryStackLimit();
    }

    private boolean func_184431_b(ItemStack p_184431_1_, ItemStack p_184431_2_) {
        return p_184431_1_.getItem() == p_184431_2_.getItem() && (!p_184431_1_.getHasSubtypes() || p_184431_1_.getMetadata() == p_184431_2_.getMetadata()) && ItemStack.areItemStackTagsEqual(p_184431_1_, p_184431_2_);
    }

    public int getFirstEmptyStack() {
        int i = 0;
        while (i < this.mainInventory.length) {
            if (this.mainInventory[i] == null) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void func_184434_a(ItemStack p_184434_1_) {
        int i = this.func_184429_b(p_184434_1_);
        if (InventoryPlayer.func_184435_e(i)) {
            this.currentItem = i;
        } else if (i == -1) {
            int j;
            this.currentItem = this.func_184433_k();
            if (this.mainInventory[this.currentItem] != null && (j = this.getFirstEmptyStack()) != -1) {
                this.mainInventory[j] = this.mainInventory[this.currentItem];
            }
            this.mainInventory[this.currentItem] = p_184434_1_;
        } else {
            this.func_184430_d(i);
        }
    }

    public void func_184430_d(int p_184430_1_) {
        this.currentItem = this.func_184433_k();
        ItemStack itemstack = this.mainInventory[this.currentItem];
        this.mainInventory[this.currentItem] = this.mainInventory[p_184430_1_];
        this.mainInventory[p_184430_1_] = itemstack;
    }

    public static boolean func_184435_e(int p_184435_0_) {
        return p_184435_0_ >= 0 && p_184435_0_ < 9;
    }

    public int func_184429_b(ItemStack p_184429_1_) {
        int i = 0;
        while (i < this.mainInventory.length) {
            if (this.mainInventory[i] != null && this.func_184431_b(p_184429_1_, this.mainInventory[i])) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int func_184433_k() {
        int i = 0;
        while (i < 9) {
            int j = (this.currentItem + i) % 9;
            if (this.mainInventory[j] == null) {
                return j;
            }
            ++i;
        }
        int k = 0;
        while (k < 9) {
            int l = (this.currentItem + k) % 9;
            if (!this.mainInventory[l].isItemEnchanted()) {
                return l;
            }
            ++k;
        }
        return this.currentItem;
    }

    public void changeCurrentItem(int direction) {
        if (direction > 0) {
            direction = 1;
        }
        if (direction < 0) {
            direction = -1;
        }
        this.currentItem -= direction;
        while (this.currentItem < 0) {
            this.currentItem += 9;
        }
        while (this.currentItem >= 9) {
            this.currentItem -= 9;
        }
    }

    public int clearMatchingItems(Item itemIn, int metadataIn, int removeCount, NBTTagCompound itemNBT) {
        int i = 0;
        int j = 0;
        while (j < this.getSizeInventory()) {
            ItemStack itemstack = this.getStackInSlot(j);
            if (!(itemstack == null || itemIn != null && itemstack.getItem() != itemIn || metadataIn > -1 && itemstack.getMetadata() != metadataIn || itemNBT != null && !NBTUtil.func_181123_a(itemNBT, itemstack.getTagCompound(), true))) {
                int k = removeCount <= 0 ? itemstack.stackSize : Math.min(removeCount - i, itemstack.stackSize);
                i += k;
                if (removeCount != 0) {
                    itemstack.stackSize -= k;
                    if (itemstack.stackSize == 0) {
                        this.setInventorySlotContents(j, null);
                    }
                    if (removeCount > 0 && i >= removeCount) {
                        return i;
                    }
                }
            }
            ++j;
        }
        if (this.itemStack != null) {
            if (itemIn != null && this.itemStack.getItem() != itemIn) {
                return i;
            }
            if (metadataIn > -1 && this.itemStack.getMetadata() != metadataIn) {
                return i;
            }
            if (itemNBT != null && !NBTUtil.func_181123_a(itemNBT, this.itemStack.getTagCompound(), true)) {
                return i;
            }
            int l = removeCount <= 0 ? this.itemStack.stackSize : Math.min(removeCount - i, this.itemStack.stackSize);
            i += l;
            if (removeCount != 0) {
                this.itemStack.stackSize -= l;
                if (this.itemStack.stackSize == 0) {
                    this.itemStack = null;
                }
                if (removeCount > 0 && i >= removeCount) {
                    return i;
                }
            }
        }
        return i;
    }

    private int storePartialItemStack(ItemStack itemStackIn) {
        Item item = itemStackIn.getItem();
        int i = itemStackIn.stackSize;
        int j = this.storeItemStack(itemStackIn);
        if (j == -1) {
            j = this.getFirstEmptyStack();
        }
        if (j == -1) {
            return i;
        }
        ItemStack itemstack = this.getStackInSlot(j);
        if (itemstack == null) {
            itemstack = new ItemStack(item, 0, itemStackIn.getMetadata());
            if (itemStackIn.hasTagCompound()) {
                itemstack.setTagCompound((NBTTagCompound)itemStackIn.getTagCompound().copy());
            }
            this.setInventorySlotContents(j, itemstack);
        }
        int k = i;
        if (i > itemstack.getMaxStackSize() - itemstack.stackSize) {
            k = itemstack.getMaxStackSize() - itemstack.stackSize;
        }
        if (k > this.getInventoryStackLimit() - itemstack.stackSize) {
            k = this.getInventoryStackLimit() - itemstack.stackSize;
        }
        if (k == 0) {
            return i;
        }
        itemstack.stackSize += k;
        itemstack.animationsToGo = 5;
        return i -= k;
    }

    private int storeItemStack(ItemStack itemStackIn) {
        if (this.func_184436_a(this.getStackInSlot(this.currentItem), itemStackIn)) {
            return this.currentItem;
        }
        if (this.func_184436_a(this.getStackInSlot(40), itemStackIn)) {
            return 40;
        }
        int i = 0;
        while (i < this.mainInventory.length) {
            if (this.func_184436_a(this.mainInventory[i], itemStackIn)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void decrementAnimations() {
        int i = 0;
        while (i < this.field_184440_g.length) {
            ItemStack[] aitemstack = this.field_184440_g[i];
            int j = 0;
            while (j < aitemstack.length) {
                if (aitemstack[j] != null) {
                    aitemstack[j].updateAnimation(this.player.worldObj, this.player, j, this.currentItem == j);
                }
                ++j;
            }
            ++i;
        }
    }

    public boolean addItemStackToInventory(final ItemStack itemStackIn) {
        if (itemStackIn != null && itemStackIn.stackSize != 0 && itemStackIn.getItem() != null) {
            int i;
            block10: {
                block8: {
                    block9: {
                        if (!itemStackIn.isItemDamaged()) break block8;
                        int j = this.getFirstEmptyStack();
                        if (j < 0) break block9;
                        this.mainInventory[j] = ItemStack.copyItemStack(itemStackIn);
                        this.mainInventory[j].animationsToGo = 5;
                        itemStackIn.stackSize = 0;
                        return true;
                    }
                    if (this.player.capabilities.isCreativeMode) {
                        itemStackIn.stackSize = 0;
                        return true;
                    }
                    return false;
                }
                try {
                    do {
                        i = itemStackIn.stackSize;
                        itemStackIn.stackSize = this.storePartialItemStack(itemStackIn);
                    } while (itemStackIn.stackSize > 0 && itemStackIn.stackSize < i);
                    if (itemStackIn.stackSize != i || !this.player.capabilities.isCreativeMode) break block10;
                    itemStackIn.stackSize = 0;
                    return true;
                }
                catch (Throwable throwable) {
                    CrashReport crashreport = CrashReport.makeCrashReport(throwable, "Adding item to inventory");
                    CrashReportCategory crashreportcategory = crashreport.makeCategory("Item being added");
                    crashreportcategory.addCrashSection("Item ID", Item.getIdFromItem(itemStackIn.getItem()));
                    crashreportcategory.addCrashSection("Item data", itemStackIn.getMetadata());
                    crashreportcategory.addCrashSectionCallable("Item name", new Callable<String>(){

                        @Override
                        public String call() throws Exception {
                            return itemStackIn.getDisplayName();
                        }
                    });
                    throw new ReportedException(crashreport);
                }
            }
            return itemStackIn.stackSize < i;
        }
        return false;
    }

    @Override
    public ItemStack decrStackSize(int index, int count) {
        ItemStack[] aitemstack = null;
        ItemStack[][] itemStackArray = this.field_184440_g;
        int n = this.field_184440_g.length;
        int n2 = 0;
        while (n2 < n) {
            ItemStack[] aitemstack1 = itemStackArray[n2];
            if (index < aitemstack1.length) {
                aitemstack = aitemstack1;
                break;
            }
            index -= aitemstack1.length;
            ++n2;
        }
        return aitemstack != null && aitemstack[index] != null ? ItemStackHelper.func_188382_a(aitemstack, index, count) : null;
    }

    public void func_184437_d(ItemStack p_184437_1_) {
        ItemStack[][] itemStackArray = this.field_184440_g;
        int n = this.field_184440_g.length;
        int n2 = 0;
        while (n2 < n) {
            ItemStack[] aitemstack = itemStackArray[n2];
            int i = 0;
            while (i < aitemstack.length) {
                if (aitemstack[i] == p_184437_1_) {
                    aitemstack[i] = null;
                    break;
                }
                ++i;
            }
            ++n2;
        }
    }

    @Override
    public ItemStack removeStackFromSlot(int index) {
        ItemStack[] aitemstack = null;
        ItemStack[][] itemStackArray = this.field_184440_g;
        int n = this.field_184440_g.length;
        int n2 = 0;
        while (n2 < n) {
            ItemStack[] aitemstack1 = itemStackArray[n2];
            if (index < aitemstack1.length) {
                aitemstack = aitemstack1;
                break;
            }
            index -= aitemstack1.length;
            ++n2;
        }
        if (aitemstack != null && aitemstack[index] != null) {
            void itemstack = aitemstack[index];
            aitemstack[index] = null;
            return itemstack;
        }
        return null;
    }

    @Override
    public void setInventorySlotContents(int index, ItemStack stack) {
        ItemStack[] aitemstack = null;
        ItemStack[][] itemStackArray = this.field_184440_g;
        int n = this.field_184440_g.length;
        int n2 = 0;
        while (n2 < n) {
            ItemStack[] aitemstack1 = itemStackArray[n2];
            if (index < aitemstack1.length) {
                aitemstack = aitemstack1;
                break;
            }
            index -= aitemstack1.length;
            ++n2;
        }
        if (aitemstack != null) {
            aitemstack[index] = stack;
        }
    }

    public float func_184438_a(IBlockState p_184438_1_) {
        float f = 1.0f;
        if (this.mainInventory[this.currentItem] != null) {
            f *= this.mainInventory[this.currentItem].getStrVsBlock(p_184438_1_);
        }
        return f;
    }

    public NBTTagList writeToNBT(NBTTagList nbtTagListIn) {
        int i = 0;
        while (i < this.mainInventory.length) {
            if (this.mainInventory[i] != null) {
                NBTTagCompound nbttagcompound = new NBTTagCompound();
                nbttagcompound.setByte("Slot", (byte)i);
                this.mainInventory[i].writeToNBT(nbttagcompound);
                nbtTagListIn.appendTag(nbttagcompound);
            }
            ++i;
        }
        int j = 0;
        while (j < this.armorInventory.length) {
            if (this.armorInventory[j] != null) {
                NBTTagCompound nbttagcompound1 = new NBTTagCompound();
                nbttagcompound1.setByte("Slot", (byte)(j + 100));
                this.armorInventory[j].writeToNBT(nbttagcompound1);
                nbtTagListIn.appendTag(nbttagcompound1);
            }
            ++j;
        }
        int k = 0;
        while (k < this.field_184439_c.length) {
            if (this.field_184439_c[k] != null) {
                NBTTagCompound nbttagcompound2 = new NBTTagCompound();
                nbttagcompound2.setByte("Slot", (byte)(k + 150));
                this.field_184439_c[k].writeToNBT(nbttagcompound2);
                nbtTagListIn.appendTag(nbttagcompound2);
            }
            ++k;
        }
        return nbtTagListIn;
    }

    public void readFromNBT(NBTTagList nbtTagListIn) {
        Arrays.fill(this.mainInventory, null);
        Arrays.fill(this.armorInventory, null);
        Arrays.fill(this.field_184439_c, null);
        int i = 0;
        while (i < nbtTagListIn.tagCount()) {
            NBTTagCompound nbttagcompound = nbtTagListIn.getCompoundTagAt(i);
            int j = nbttagcompound.getByte("Slot") & 0xFF;
            ItemStack itemstack = ItemStack.loadItemStackFromNBT(nbttagcompound);
            if (itemstack != null) {
                if (j >= 0 && j < this.mainInventory.length) {
                    this.mainInventory[j] = itemstack;
                } else if (j >= 100 && j < this.armorInventory.length + 100) {
                    this.armorInventory[j - 100] = itemstack;
                } else if (j >= 150 && j < this.field_184439_c.length + 150) {
                    this.field_184439_c[j - 150] = itemstack;
                }
            }
            ++i;
        }
    }

    @Override
    public int getSizeInventory() {
        return this.mainInventory.length + this.armorInventory.length + this.field_184439_c.length;
    }

    @Override
    public ItemStack getStackInSlot(int index) {
        ItemStack[] aitemstack = null;
        ItemStack[][] itemStackArray = this.field_184440_g;
        int n = this.field_184440_g.length;
        int n2 = 0;
        while (n2 < n) {
            ItemStack[] aitemstack1 = itemStackArray[n2];
            if (index < aitemstack1.length) {
                aitemstack = aitemstack1;
                break;
            }
            index -= aitemstack1.length;
            ++n2;
        }
        return aitemstack == null ? null : aitemstack[index];
    }

    @Override
    public String getName() {
        return "container.inventory";
    }

    @Override
    public boolean hasCustomName() {
        return false;
    }

    @Override
    public ITextComponent getDisplayName() {
        return this.hasCustomName() ? new TextComponentString(this.getName()) : new TextComponentTranslation(this.getName(), new Object[0]);
    }

    @Override
    public int getInventoryStackLimit() {
        return 64;
    }

    public boolean func_184432_b(IBlockState p_184432_1_) {
        if (p_184432_1_.getMaterial().isToolNotRequired()) {
            return true;
        }
        ItemStack itemstack = this.getStackInSlot(this.currentItem);
        return itemstack != null ? itemstack.canHarvestBlock(p_184432_1_) : false;
    }

    public ItemStack armorItemInSlot(int slotIn) {
        return this.armorInventory[slotIn];
    }

    public void damageArmor(float damage) {
        if ((damage /= 4.0f) < 1.0f) {
            damage = 1.0f;
        }
        int i = 0;
        while (i < this.armorInventory.length) {
            if (this.armorInventory[i] != null && this.armorInventory[i].getItem() instanceof ItemArmor) {
                this.armorInventory[i].damageItem((int)damage, this.player);
                if (this.armorInventory[i].stackSize == 0) {
                    this.armorInventory[i] = null;
                }
            }
            ++i;
        }
    }

    public void dropAllItems() {
        ItemStack[][] itemStackArray = this.field_184440_g;
        int n = this.field_184440_g.length;
        int n2 = 0;
        while (n2 < n) {
            ItemStack[] aitemstack = itemStackArray[n2];
            int i = 0;
            while (i < aitemstack.length) {
                if (aitemstack[i] != null) {
                    this.player.dropItem(aitemstack[i], true, false);
                    aitemstack[i] = null;
                }
                ++i;
            }
            ++n2;
        }
    }

    @Override
    public void markDirty() {
        this.inventoryChanged = true;
    }

    public void setItemStack(ItemStack itemStackIn) {
        this.itemStack = itemStackIn;
    }

    public ItemStack getItemStack() {
        return this.itemStack;
    }

    @Override
    public boolean isUseableByPlayer(EntityPlayer player) {
        return this.player.isDead ? false : player.getDistanceSqToEntity(this.player) <= 64.0;
    }

    public boolean hasItemStack(ItemStack itemStackIn) {
        ItemStack[][] itemStackArray = this.field_184440_g;
        int n = this.field_184440_g.length;
        int n2 = 0;
        while (n2 < n) {
            ItemStack[] aitemstack = itemStackArray[n2];
            int i = 0;
            while (i < aitemstack.length) {
                if (aitemstack[i] != null && aitemstack[i].isItemEqual(itemStackIn)) {
                    return true;
                }
                ++i;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public void openInventory(EntityPlayer player) {
    }

    @Override
    public void closeInventory(EntityPlayer player) {
    }

    @Override
    public boolean isItemValidForSlot(int index, ItemStack stack) {
        return true;
    }

    public void copyInventory(InventoryPlayer playerInventory) {
        int i = 0;
        while (i < this.getSizeInventory()) {
            this.setInventorySlotContents(i, playerInventory.getStackInSlot(i));
            ++i;
        }
        this.currentItem = playerInventory.currentItem;
    }

    @Override
    public int getField(int id) {
        return 0;
    }

    @Override
    public void setField(int id, int value) {
    }

    @Override
    public int getFieldCount() {
        return 0;
    }

    @Override
    public void clear() {
        ItemStack[][] itemStackArray = this.field_184440_g;
        int n = this.field_184440_g.length;
        int n2 = 0;
        while (n2 < n) {
            ItemStack[] aitemstack = itemStackArray[n2];
            int i = 0;
            while (i < aitemstack.length) {
                aitemstack[i] = null;
                ++i;
            }
            ++n2;
        }
    }
}

