/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.item;

import net.minecraft.block.material.MapColor;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.text.TextFormatting;

public enum EnumDyeColor implements IStringSerializable
{
    WHITE(0, 15, "white", "white", MapColor.snowColor, TextFormatting.WHITE),
    ORANGE(1, 14, "orange", "orange", MapColor.adobeColor, TextFormatting.GOLD),
    MAGENTA(2, 13, "magenta", "magenta", MapColor.magentaColor, TextFormatting.AQUA),
    LIGHT_BLUE(3, 12, "light_blue", "lightBlue", MapColor.lightBlueColor, TextFormatting.BLUE),
    YELLOW(4, 11, "yellow", "yellow", MapColor.yellowColor, TextFormatting.YELLOW),
    LIME(5, 10, "lime", "lime", MapColor.limeColor, TextFormatting.GREEN),
    PINK(6, 9, "pink", "pink", MapColor.pinkColor, TextFormatting.LIGHT_PURPLE),
    GRAY(7, 8, "gray", "gray", MapColor.grayColor, TextFormatting.DARK_GRAY),
    SILVER(8, 7, "silver", "silver", MapColor.silverColor, TextFormatting.GRAY),
    CYAN(9, 6, "cyan", "cyan", MapColor.cyanColor, TextFormatting.DARK_AQUA),
    PURPLE(10, 5, "purple", "purple", MapColor.purpleColor, TextFormatting.DARK_PURPLE),
    BLUE(11, 4, "blue", "blue", MapColor.blueColor, TextFormatting.DARK_BLUE),
    BROWN(12, 3, "brown", "brown", MapColor.brownColor, TextFormatting.GOLD),
    GREEN(13, 2, "green", "green", MapColor.greenColor, TextFormatting.DARK_GREEN),
    RED(14, 1, "red", "red", MapColor.redColor, TextFormatting.DARK_RED),
    BLACK(15, 0, "black", "black", MapColor.blackColor, TextFormatting.BLACK);

    private static final EnumDyeColor[] META_LOOKUP;
    private static final EnumDyeColor[] DYE_DMG_LOOKUP;
    private final int meta;
    private final int dyeDamage;
    private final String name;
    private final String unlocalizedName;
    private final MapColor mapColor;
    private final TextFormatting chatColor;

    static {
        META_LOOKUP = new EnumDyeColor[EnumDyeColor.values().length];
        DYE_DMG_LOOKUP = new EnumDyeColor[EnumDyeColor.values().length];
        EnumDyeColor[] enumDyeColorArray = EnumDyeColor.values();
        int n = enumDyeColorArray.length;
        int n2 = 0;
        while (n2 < n) {
            EnumDyeColor enumdyecolor;
            EnumDyeColor.META_LOOKUP[enumdyecolor.getMetadata()] = enumdyecolor = enumDyeColorArray[n2];
            EnumDyeColor.DYE_DMG_LOOKUP[enumdyecolor.getDyeDamage()] = enumdyecolor;
            ++n2;
        }
    }

    private EnumDyeColor(int meta, int dyeDamage, String name, String unlocalizedName, MapColor mapColorIn, TextFormatting chatColor) {
        this.meta = meta;
        this.dyeDamage = dyeDamage;
        this.name = name;
        this.unlocalizedName = unlocalizedName;
        this.mapColor = mapColorIn;
        this.chatColor = chatColor;
    }

    public int getMetadata() {
        return this.meta;
    }

    public int getDyeDamage() {
        return this.dyeDamage;
    }

    public String getUnlocalizedName() {
        return this.unlocalizedName;
    }

    public MapColor getMapColor() {
        return this.mapColor;
    }

    public static EnumDyeColor byDyeDamage(int damage) {
        if (damage < 0 || damage >= DYE_DMG_LOOKUP.length) {
            damage = 0;
        }
        return DYE_DMG_LOOKUP[damage];
    }

    public static EnumDyeColor byMetadata(int meta) {
        if (meta < 0 || meta >= META_LOOKUP.length) {
            meta = 0;
        }
        return META_LOOKUP[meta];
    }

    public String toString() {
        return this.unlocalizedName;
    }

    @Override
    public String getName() {
        return this.name;
    }
}

