/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.pathfinding;

import net.minecraft.entity.EntityLiving;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.util.IntHashMap;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;

public abstract class NodeProcessor {
    protected IBlockAccess blockaccess;
    protected EntityLiving field_186326_b;
    protected final IntHashMap<PathPoint> pointMap = new IntHashMap();
    protected int entitySizeX;
    protected int entitySizeY;
    protected int entitySizeZ;
    protected boolean canEnterDoors;
    protected boolean canBreakDoors;
    protected boolean canSwim;

    public void func_186315_a(IBlockAccess p_186315_1_, EntityLiving p_186315_2_) {
        this.blockaccess = p_186315_1_;
        this.field_186326_b = p_186315_2_;
        this.pointMap.clearMap();
        this.entitySizeX = MathHelper.floor_float(p_186315_2_.width + 1.0f);
        this.entitySizeY = MathHelper.floor_float(p_186315_2_.height + 1.0f);
        this.entitySizeZ = MathHelper.floor_float(p_186315_2_.width + 1.0f);
    }

    public void postProcess() {
    }

    protected PathPoint openPoint(int x, int y, int z) {
        int i = PathPoint.makeHash(x, y, z);
        PathPoint pathpoint = this.pointMap.lookup(i);
        if (pathpoint == null) {
            pathpoint = new PathPoint(x, y, z);
            this.pointMap.addKey(i, pathpoint);
        }
        return pathpoint;
    }

    public abstract PathPoint func_186318_b();

    public abstract PathPoint func_186325_a(double var1, double var3, double var5);

    public abstract int func_186320_a(PathPoint[] var1, PathPoint var2, PathPoint var3, float var4);

    public abstract PathNodeType func_186319_a(IBlockAccess var1, int var2, int var3, int var4, EntityLiving var5, int var6, int var7, int var8, boolean var9, boolean var10);

    public void func_186317_a(boolean p_186317_1_) {
        this.canEnterDoors = p_186317_1_;
    }

    public void func_186321_b(boolean p_186321_1_) {
        this.canBreakDoors = p_186321_1_;
    }

    public void func_186316_c(boolean p_186316_1_) {
        this.canSwim = p_186316_1_;
    }

    public boolean func_186323_c() {
        return this.canEnterDoors;
    }

    public boolean func_186324_d() {
        return this.canBreakDoors;
    }

    public boolean func_186322_e() {
        return this.canSwim;
    }
}

