/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.biome;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ContiguousSet;
import com.google.common.collect.DiscreteDomain;
import com.google.common.collect.Lists;
import com.google.common.collect.Range;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeDecorator;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.gen.feature.WorldGenSpikes;

public class BiomeEndDecorator
extends BiomeDecorator {
    private static final LoadingCache<Long, WorldGenSpikes.EndSpike[]> field_185427_L = CacheBuilder.newBuilder().expireAfterWrite(5L, TimeUnit.MINUTES).build((CacheLoader)new SpikeCacheLoader());
    private final WorldGenSpikes spikeGen = new WorldGenSpikes();

    @Override
    protected void genDecorations(BiomeGenBase biomeGenBaseIn, World worldIn, Random random) {
        WorldGenSpikes.EndSpike[] aworldgenspikes$endspike;
        this.generateOres(worldIn, random);
        WorldGenSpikes.EndSpike[] endSpikeArray = aworldgenspikes$endspike = BiomeEndDecorator.func_185426_a(worldIn);
        int n = aworldgenspikes$endspike.length;
        int n2 = 0;
        while (n2 < n) {
            WorldGenSpikes.EndSpike worldgenspikes$endspike = endSpikeArray[n2];
            if (worldgenspikes$endspike.func_186154_a(this.field_180294_c)) {
                this.spikeGen.func_186143_a(worldgenspikes$endspike);
                this.spikeGen.generate(worldIn, random, new BlockPos(worldgenspikes$endspike.func_186151_a(), 45, worldgenspikes$endspike.func_186152_b()));
            }
            ++n2;
        }
    }

    public static WorldGenSpikes.EndSpike[] func_185426_a(World p_185426_0_) {
        Random random = new Random(p_185426_0_.getSeed());
        long i = random.nextLong() & 0xFFFFL;
        return (WorldGenSpikes.EndSpike[])field_185427_L.getUnchecked((Object)i);
    }

    static class SpikeCacheLoader
    extends CacheLoader<Long, WorldGenSpikes.EndSpike[]> {
        private SpikeCacheLoader() {
        }

        public WorldGenSpikes.EndSpike[] load(Long p_load_1_) throws Exception {
            ArrayList list = Lists.newArrayList((Iterable)ContiguousSet.create((Range)Range.closedOpen((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(10)), (DiscreteDomain)DiscreteDomain.integers()));
            Collections.shuffle(list, new Random(p_load_1_));
            WorldGenSpikes.EndSpike[] aworldgenspikes$endspike = new WorldGenSpikes.EndSpike[10];
            int i = 0;
            while (i < 10) {
                int j = (int)(42.0 * Math.cos(2.0 * (-Math.PI + 0.3141592653589793 * (double)i)));
                int k = (int)(42.0 * Math.sin(2.0 * (-Math.PI + 0.3141592653589793 * (double)i)));
                int l = (Integer)list.get(i);
                int i1 = 2 + l / 3;
                int j1 = 76 + l * 3;
                boolean flag = l == 1 || l == 2;
                aworldgenspikes$endspike[i] = new WorldGenSpikes.EndSpike(j, k, i1, j1, flag);
                ++i;
            }
            return aworldgenspikes$endspike;
        }
    }
}

