/*
 * Decompiled with CFR 0.152.
 */
package me.protocol_client.ui.tabgui;

import java.util.ArrayList;
import me.protocol_client.Protocol;
import me.protocol_client.Wrapper;
import me.protocol_client.module.Category;
import me.protocol_client.module.Module;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;

public class NodusTabGui {
    private ArrayList<String> category = new ArrayList();
    private FontRenderer fr;
    private int selectedTab;
    private int selectedMod;
    private boolean mainMenu;
    public int linesColor;
    public String topString;

    public NodusTabGui() {
        this.fr = Minecraft.getMinecraft().fontRendererObj;
        this.mainMenu = true;
        this.linesColor = 0x50999999;
        this.topString = String.valueOf(Protocol.name) + "\u00a7f v" + Protocol.version + "(X: " + (int)Wrapper.getPlayer().posX + " Z: " + (int)Wrapper.getPlayer().posZ + ")";
        Category[] arrayOfModCategory = Category.values();
        int j = arrayOfModCategory.length;
        int i = 0;
        while (i < j) {
            Category mc = arrayOfModCategory[i];
            if (!mc.name().equalsIgnoreCase("Other") && !mc.name().equalsIgnoreCase("ProtocolButtons")) {
                this.category.add(String.valueOf(mc.toString().substring(0, 1)) + mc.toString().substring(1, mc.toString().length()).toLowerCase());
            }
            ++i;
        }
    }

    public void drawTabGui() {
        this.linesColor = 0x40999999;
        int x = (int)Wrapper.getPlayer().posX;
        int z = (int)Wrapper.getPlayer().posZ;
        String topString = "Protocol() \u00a7fv1.4 (X: " + x + " Z:" + z;
        Gui.drawRect(2, 2, Wrapper.fr().getStringWidth(topString) + 3, 14, -587202560);
        Wrapper.drawBorderRect(1, 1, Wrapper.fr().getStringWidth(topString) + 4, 15 + this.category.size() * 11, this.linesColor, 0, 1);
        Gui.drawString(Wrapper.mc().fontRendererObj, "Protocol \u00a7fv1.4 (X: " + x + " Z: " + z + ")", 3, 4, -16711936);
        int categoryCount = 0;
        for (String s : this.category) {
            Gui.drawRect(2, 14 + categoryCount * 11, Wrapper.fr().getStringWidth(topString) + 3, 25 + categoryCount * 11, -1879048192);
            if (s.equalsIgnoreCase("Other") || s.equalsIgnoreCase("ProtocolButtons")) continue;
            if (categoryCount == this.selectedTab) {
                Gui.drawString(Wrapper.mc().fontRendererObj, ">" + s, 4, 16 + categoryCount * 11, -16711936);
            } else {
                Gui.drawString(Wrapper.mc().fontRendererObj, s, 4, 16 + categoryCount * 11, -1);
            }
            if (this.mainMenu) {
                if (categoryCount == this.selectedTab) {
                    Gui.drawString(Wrapper.mc().fontRendererObj, ">>", Wrapper.fr().getStringWidth(topString) - 8, 16 + categoryCount * 11, -16711936);
                } else {
                    Gui.drawString(Wrapper.mc().fontRendererObj, ">>", Wrapper.fr().getStringWidth(topString) - 8, 16 + categoryCount * 11, -1);
                }
            } else if (categoryCount == this.selectedTab) {
                Gui.drawString(Wrapper.mc().fontRendererObj, "<<", Wrapper.fr().getStringWidth(topString) - 8, 16 + categoryCount * 11, -16711936);
            } else {
                Gui.drawString(Wrapper.mc().fontRendererObj, ">>", Wrapper.fr().getStringWidth(topString) - 8, 16 + categoryCount * 11, -1);
            }
            ++categoryCount;
        }
        if (!this.mainMenu) {
            if (this.selectedTab == 0) {
                Wrapper.drawBorderRect(Wrapper.fr().getStringWidth(topString) + 6, 14, Wrapper.fr().getStringWidth(topString) + 2 + this.getLongestModWidth(), 15 + this.getModsForCategory().size() * 11, this.linesColor, -1879048192, 1);
            }
            if (this.selectedTab == 1) {
                Wrapper.drawBorderRect(Wrapper.fr().getStringWidth(topString) + 6, 25, Wrapper.fr().getStringWidth(topString) + 2 + this.getLongestModWidth(), 26 + this.getModsForCategory().size() * 11, this.linesColor, -1879048192, 1);
            }
            if (this.selectedTab == 2) {
                Wrapper.drawBorderRect(Wrapper.fr().getStringWidth(topString) + 6, 36, Wrapper.fr().getStringWidth(topString) + 2 + this.getLongestModWidth(), 37 + this.getModsForCategory().size() * 11, this.linesColor, -1879048192, 1);
            }
            if (this.selectedTab == 3) {
                Wrapper.drawBorderRect(Wrapper.fr().getStringWidth(topString) + 6, 47, Wrapper.fr().getStringWidth(topString) + 2 + this.getLongestModWidth(), 48 + this.getModsForCategory().size() * 11, this.linesColor, -1879048192, 1);
            }
            if (this.selectedTab == 4) {
                Wrapper.drawBorderRect(Wrapper.fr().getStringWidth(topString) + 6, 58, Wrapper.fr().getStringWidth(topString) + 2 + this.getLongestModWidth(), 59 + this.getModsForCategory().size() * 11, this.linesColor, -1879048192, 1);
            }
            if (this.selectedTab == 5) {
                Wrapper.drawBorderRect(Wrapper.fr().getStringWidth(topString) + 6, 69, Wrapper.fr().getStringWidth(topString) + 2 + this.getLongestModWidth(), 70 + this.getModsForCategory().size() * 11, this.linesColor, -1879048192, 1);
            }
            if (this.selectedTab == 6) {
                Wrapper.drawBorderRect(Wrapper.fr().getStringWidth(topString) + 6, 80, Wrapper.fr().getStringWidth(topString) + 2 + this.getLongestModWidth(), 81 + this.getModsForCategory().size() * 11, this.linesColor, -1879048192, 1);
            }
            int modCount = 0;
            for (Module mod : this.getModsForCategory()) {
                String name;
                String color = !mod.isToggled() ? "\u00a7f" : "\u00a7r";
                String string = name = modCount == this.selectedMod ? ">" + color + mod.getName() + "\u00a7f" : String.valueOf(color) + mod.getName();
                if (this.selectedTab == 0) {
                    Gui.drawString(Wrapper.mc().fontRendererObj, name, Wrapper.fr().getStringWidth(topString) + 9, 16 + modCount * 11, -16711936);
                }
                if (this.selectedTab == 1) {
                    Gui.drawString(Wrapper.mc().fontRendererObj, name, Wrapper.fr().getStringWidth(topString) + 9, 27 + modCount * 11, -16711936);
                }
                if (this.selectedTab == 2) {
                    Gui.drawString(Wrapper.mc().fontRendererObj, name, Wrapper.fr().getStringWidth(topString) + 9, 38 + modCount * 11, -16711936);
                }
                if (this.selectedTab == 3) {
                    Gui.drawString(Wrapper.mc().fontRendererObj, name, Wrapper.fr().getStringWidth(topString) + 9, 49 + modCount * 11, -16711936);
                }
                if (this.selectedTab == 4) {
                    Gui.drawString(Wrapper.mc().fontRendererObj, name, Wrapper.fr().getStringWidth(topString) + 9, 60 + modCount * 11, -16711936);
                }
                if (this.selectedTab == 5) {
                    Gui.drawString(Wrapper.mc().fontRendererObj, name, Wrapper.fr().getStringWidth(topString) + 9, 71 + modCount * 11, -16711936);
                }
                if (this.selectedTab == 6) {
                    Gui.drawString(Wrapper.mc().fontRendererObj, name, Wrapper.fr().getStringWidth(topString) + 9, 82 + modCount * 11, -16711936);
                }
                ++modCount;
            }
        }
    }

    public void down() {
        if (this.mainMenu) {
            if (this.selectedTab >= this.category.size() - 1) {
                this.selectedTab = -1;
            }
            ++this.selectedTab;
        } else {
            if (this.selectedMod >= this.getModsForCategory().size() - 1) {
                this.selectedMod = -1;
            }
            ++this.selectedMod;
        }
    }

    public void up() {
        if (this.mainMenu) {
            if (this.selectedTab <= 0) {
                this.selectedTab = this.category.size();
            }
            --this.selectedTab;
        } else {
            if (this.selectedMod <= 0) {
                this.selectedMod = this.getModsForCategory().size();
            }
            --this.selectedMod;
        }
    }

    public void left() {
        this.mainMenu = true;
    }

    public void right() {
        if (!this.mainMenu) {
            this.enter();
            this.getModsForCategory().get(this.selectedMod).onToggle();
        } else {
            this.selectedMod = 0;
            this.mainMenu = false;
        }
    }

    public void enter() {
        if (!this.mainMenu) {
            this.getModsForCategory().get(this.selectedMod).toggle();
        }
    }

    private ArrayList<Module> getModsForCategory() {
        ArrayList<Module> mods = new ArrayList<Module>();
        for (Module mod : Protocol.getModules()) {
            if (mod.getCategory() != Category.valueOf(this.category.get(this.selectedTab).toUpperCase())) continue;
            mods.add(mod);
        }
        return mods;
    }

    private int getLongestModWidth() {
        int longest = 0;
        for (Module mod : this.getModsForCategory()) {
            if (this.fr.getStringWidth(mod.getName()) <= longest) continue;
            longest = 9 + this.fr.getStringWidth("> " + mod.getName());
        }
        return longest;
    }
}

