/*
 * Decompiled with CFR 0.152.
 */
package me.protocol_client.ui.tabgui;

import java.util.ArrayList;
import me.protocol_client.Protocol;
import me.protocol_client.Wrapper;
import me.protocol_client.module.Category;
import me.protocol_client.module.Module;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;

public class UglyTabGui {
    private ArrayList<String> category = new ArrayList();
    private FontRenderer fr;
    private int selectedTab;
    private int selectedMod;
    private boolean mainMenu;

    public UglyTabGui() {
        this.fr = Minecraft.getMinecraft().fontRendererObj;
        this.mainMenu = true;
        Category[] arrayOfModCategory = Category.values();
        int j = arrayOfModCategory.length;
        int i = 0;
        while (i < j) {
            Category mc = arrayOfModCategory[i];
            if (!mc.name().equalsIgnoreCase("Other") && !mc.name().equalsIgnoreCase("ProtocolButtons")) {
                this.category.add(String.valueOf(mc.toString().substring(0, 1)) + mc.toString().substring(1, mc.toString().length()).toLowerCase());
            }
            ++i;
        }
    }

    public void drawTabGui() {
        Wrapper.drawBorderRect(1, 1, 75, 32 + this.category.size() * 11, Protocol.color, -1879048192, 1);
        Wrapper.drawBorderRect(1, this.selectedTab * 13 + 16, 75, this.selectedTab * 13 + 32, 203, Protocol.color, 1);
        Wrapper.drawBorderRect(1, 1, 75, 17, Protocol.color, Protocol.color, 1);
        Gui.drawString(Wrapper.mc().fontRendererObj, String.valueOf(Protocol.name) + " v" + Protocol.version, 12, 5, -1);
        int categoryCount = 0;
        for (String s : this.category) {
            if (s.equalsIgnoreCase("Other") || s.equalsIgnoreCase("ProtocolButtons")) continue;
            Gui.drawCenteredString(this.fr, categoryCount == this.selectedTab ? "\u00a7f" + s : "\u00a7f" + s, 37, 20 + categoryCount * 13, -1);
            ++categoryCount;
        }
        if (!this.mainMenu) {
            if (this.selectedTab == 0) {
                Wrapper.drawBorderRect(77, 17, 170, 2 + this.getModsForCategory().size() * 13 + 17, Protocol.color, -1879048192, 1);
                Wrapper.drawBorderRect(77, this.selectedMod * 13 + 17, 170, this.selectedMod * 13 + 33, 203, Protocol.color, 1);
            }
            if (this.selectedTab == 1) {
                Wrapper.drawBorderRect(77, 30, 170, 2 + this.getModsForCategory().size() * 13 + 30, Protocol.color, -1879048192, 1);
                Wrapper.drawBorderRect(77, this.selectedMod * 13 + 30, 170, this.selectedMod * 13 + 46, 203, Protocol.color, 1);
            }
            if (this.selectedTab == 2) {
                Wrapper.drawBorderRect(77, 43, 170, 2 + this.getModsForCategory().size() * 13 + 43, Protocol.color, -1879048192, 1);
                Wrapper.drawBorderRect(77, this.selectedMod * 13 + 43, 170, this.selectedMod * 13 + 59, 203, Protocol.color, 1);
            }
            if (this.selectedTab == 3) {
                Wrapper.drawBorderRect(77, 56, 170, 2 + this.getModsForCategory().size() * 13 + 56, Protocol.color, -1879048192, 1);
                Wrapper.drawBorderRect(77, this.selectedMod * 13 + 56, 170, this.selectedMod * 13 + 72, 203, Protocol.color, 1);
            }
            if (this.selectedTab == 4) {
                Wrapper.drawBorderRect(77, 69, 170, 2 + this.getModsForCategory().size() * 13 + 69, Protocol.color, -1879048192, 1);
                Wrapper.drawBorderRect(77, this.selectedMod * 13 + 69, 170, this.selectedMod * 13 + 85, 203, Protocol.color, 1);
            }
            if (this.selectedTab == 5) {
                Wrapper.drawBorderRect(77, 82, 170, 2 + this.getModsForCategory().size() * 13 + 82, Protocol.color, -1879048192, 1);
                Wrapper.drawBorderRect(77, this.selectedMod * 13 + 82, 170, this.selectedMod * 13 + 98, 203, Protocol.color, 1);
            }
            if (this.selectedTab == 6) {
                Wrapper.drawBorderRect(77, 95, 170, 2 + this.getModsForCategory().size() * 13 + 95, Protocol.color, -1879048192, 1);
                Wrapper.drawBorderRect(77, this.selectedMod * 13 + 95, 170, this.selectedMod * 13 + 111, 203, Protocol.color, 1);
            }
            int modCount = 0;
            for (Module mod : this.getModsForCategory()) {
                String name;
                String color = mod.isToggled() ? "\u00a7e" : "\u00a77";
                String string = name = modCount == this.selectedMod ? String.valueOf(color) + mod.getName() + "\u00a7f" : String.valueOf(color) + mod.getName();
                if (this.selectedTab == 0) {
                    Gui.drawString(this.fr, " \u00a7b" + name, 78, 21 + modCount * 13, -1);
                }
                if (this.selectedTab == 1) {
                    Gui.drawString(this.fr, " \u00a7b" + name, 78, 34 + modCount * 13, -1);
                }
                if (this.selectedTab == 2) {
                    Gui.drawString(this.fr, " \u00a7b" + name, 78, 47 + modCount * 13, -1);
                }
                if (this.selectedTab == 3) {
                    Gui.drawString(this.fr, " \u00a7b" + name, 78, 60 + modCount * 13, -1);
                }
                if (this.selectedTab == 4) {
                    Gui.drawString(this.fr, " \u00a7b" + name, 78, 73 + modCount * 13, -1);
                }
                if (this.selectedTab == 5) {
                    Gui.drawString(this.fr, " \u00a7b" + name, 78, 86 + modCount * 13, -1);
                }
                if (this.selectedTab == 6) {
                    Gui.drawString(this.fr, " \u00a7b" + name, 78, 99 + modCount * 13, -1);
                }
                ++modCount;
            }
        }
    }

    public void down() {
        if (this.mainMenu) {
            if (this.selectedTab >= this.category.size() - 1) {
                this.selectedTab = -1;
            }
            ++this.selectedTab;
        } else {
            if (this.selectedMod >= this.getModsForCategory().size() - 1) {
                this.selectedMod = -1;
            }
            ++this.selectedMod;
        }
    }

    public void up() {
        if (this.mainMenu) {
            if (this.selectedTab <= 0) {
                this.selectedTab = this.category.size();
            }
            --this.selectedTab;
        } else {
            if (this.selectedMod <= 0) {
                this.selectedMod = this.getModsForCategory().size();
            }
            --this.selectedMod;
        }
    }

    public void left() {
        this.mainMenu = true;
    }

    public void right() {
        if (!this.mainMenu) {
            this.enter();
            this.getModsForCategory().get(this.selectedMod).onToggle();
        } else {
            this.selectedMod = 0;
            this.mainMenu = false;
        }
    }

    public void enter() {
        if (!this.mainMenu) {
            this.getModsForCategory().get(this.selectedMod).toggle();
        }
    }

    private ArrayList<Module> getModsForCategory() {
        ArrayList<Module> mods = new ArrayList<Module>();
        for (Module mod : Protocol.getModules()) {
            if (mod.getCategory() != Category.valueOf(this.category.get(this.selectedTab).toUpperCase())) continue;
            mods.add(mod);
        }
        return mods;
    }

    private int getLongestModWidth() {
        int longest = 0;
        for (Module mod : this.getModsForCategory()) {
            if (this.fr.getStringWidth(mod.getName()) <= longest) continue;
            longest = this.fr.getStringWidth(mod.getName());
        }
        return longest;
    }
}

