/*
 * Decompiled with CFR 0.152.
 */
package me.protocol_client.utils;

import java.util.Random;

public final class MathUtils {
    private static final Random rng = new Random();

    public static Random getRng() {
        return rng;
    }

    public static float getRandom() {
        return rng.nextFloat();
    }

    public static int getRandom(int cap) {
        return rng.nextInt(cap);
    }

    public static int getRandom(int floor, int cap) {
        return floor + rng.nextInt(cap - floor + 1);
    }

    public static int randInt(int min, int max) {
        return new Random().nextInt(max - min + 1) + min;
    }

    public static float clampValue(float value, float floor, float cap) {
        if (value < floor) {
            return floor;
        }
        if (value > cap) {
            return cap;
        }
        return value;
    }

    public static float getSimilarity(String string1, String string2) {
        int halflen = Math.min(string1.length(), string2.length()) / 2 + Math.min(string1.length(), string2.length()) % 2;
        StringBuffer common1 = MathUtils.getCommonCharacters(string1, string2, halflen);
        StringBuffer common2 = MathUtils.getCommonCharacters(string2, string1, halflen);
        if (common1.length() == 0 || common2.length() == 0) {
            return 0.0f;
        }
        if (common1.length() != common2.length()) {
            return 0.0f;
        }
        int transpositions = 0;
        int n = common1.length();
        int i = 0;
        while (i < n) {
            if (common1.charAt(i) != common2.charAt(i)) {
                ++transpositions;
            }
            ++i;
        }
        transpositions = (int)((float)transpositions / 2.0f);
        return (float)(common1.length() / string1.length() + common2.length() / string2.length() + (common1.length() - transpositions) / common1.length()) / 3.0f;
    }

    private static StringBuffer getCommonCharacters(String string1, String string2, int distanceSep) {
        StringBuffer returnCommons = new StringBuffer();
        StringBuffer copy = new StringBuffer(string2);
        int n = string1.length();
        int m = string2.length();
        int i = 0;
        while (i < n) {
            char ch = string1.charAt(i);
            boolean foundIt = false;
            int j = Math.max(0, i - distanceSep);
            while (!foundIt && j < Math.min(i + distanceSep, m - 1)) {
                if (copy.charAt(j) == ch) {
                    foundIt = true;
                    returnCommons.append(ch);
                    copy.setCharAt(j, '\u0000');
                }
                ++j;
            }
            ++i;
        }
        return returnCommons;
    }
}

