/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.BlockDirectional;
import net.minecraft.block.BlockPistonBase;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.CommandBlockBaseLogic;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityCommandBlock;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.StringUtils;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class BlockCommandBlock
extends BlockContainer {
    public static final PropertyDirection FACING = BlockDirectional.FACING;
    public static final PropertyBool CONDITIONAL = PropertyBool.create("conditional");

    public BlockCommandBlock(MapColor p_i46688_1_) {
        super(Material.iron, p_i46688_1_);
        this.setDefaultState(this.blockState.getBaseState().withProperty(FACING, EnumFacing.NORTH).withProperty(CONDITIONAL, false));
    }

    @Override
    public TileEntity createNewTileEntity(World worldIn, int meta) {
        TileEntityCommandBlock tileentitycommandblock = new TileEntityCommandBlock();
        tileentitycommandblock.setAuto(this == Blocks.chain_command_block);
        return tileentitycommandblock;
    }

    @Override
    public void onNeighborBlockChange(World worldIn, BlockPos pos, IBlockState state, Block neighborBlock) {
        TileEntity tileentity;
        if (!worldIn.isRemote && (tileentity = worldIn.getTileEntity(pos)) instanceof TileEntityCommandBlock) {
            TileEntityCommandBlock tileentitycommandblock = (TileEntityCommandBlock)tileentity;
            boolean flag = worldIn.isBlockPowered(pos);
            boolean flag1 = tileentitycommandblock.isPowered();
            boolean flag2 = tileentitycommandblock.isAuto();
            if (flag && !flag1) {
                tileentitycommandblock.setPowered(true);
                if (tileentitycommandblock.func_184251_i() != TileEntityCommandBlock.Mode.SEQUENCE && !flag2) {
                    boolean flag3 = !tileentitycommandblock.func_184258_j() || this.func_185562_e(worldIn, pos, state);
                    tileentitycommandblock.setConditionMet(flag3);
                    worldIn.scheduleUpdate(pos, this, this.tickRate(worldIn));
                    if (flag3) {
                        this.func_185563_c(worldIn, pos);
                    }
                }
            } else if (!flag && flag1) {
                tileentitycommandblock.setPowered(false);
            }
        }
    }

    @Override
    public void updateTick(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        TileEntity tileentity;
        if (!worldIn.isRemote && (tileentity = worldIn.getTileEntity(pos)) instanceof TileEntityCommandBlock) {
            TileEntityCommandBlock tileentitycommandblock = (TileEntityCommandBlock)tileentity;
            CommandBlockBaseLogic commandblockbaselogic = tileentitycommandblock.getCommandBlockLogic();
            boolean flag = !StringUtils.isNullOrEmpty(commandblockbaselogic.getCommand());
            TileEntityCommandBlock.Mode tileentitycommandblock$mode = tileentitycommandblock.func_184251_i();
            boolean flag1 = !tileentitycommandblock.func_184258_j() || this.func_185562_e(worldIn, pos, state);
            boolean flag2 = tileentitycommandblock.isConditionMet();
            boolean flag3 = false;
            if (tileentitycommandblock$mode != TileEntityCommandBlock.Mode.SEQUENCE && flag2 && flag) {
                commandblockbaselogic.trigger(worldIn);
                flag3 = true;
            }
            if (tileentitycommandblock.isPowered() || tileentitycommandblock.isAuto()) {
                if (tileentitycommandblock$mode == TileEntityCommandBlock.Mode.SEQUENCE && flag1 && flag) {
                    commandblockbaselogic.trigger(worldIn);
                    flag3 = true;
                }
                if (tileentitycommandblock$mode == TileEntityCommandBlock.Mode.AUTO) {
                    worldIn.scheduleUpdate(pos, this, this.tickRate(worldIn));
                    if (flag1) {
                        this.func_185563_c(worldIn, pos);
                    }
                }
            }
            if (!flag3) {
                commandblockbaselogic.func_184167_a(0);
            }
            tileentitycommandblock.setConditionMet(flag1);
            worldIn.updateComparatorOutputLevel(pos, this);
        }
    }

    public boolean func_185562_e(World p_185562_1_, BlockPos p_185562_2_, IBlockState p_185562_3_) {
        EnumFacing enumfacing = p_185562_3_.getValue(FACING);
        TileEntity tileentity = p_185562_1_.getTileEntity(p_185562_2_.offset(enumfacing.getOpposite()));
        return tileentity instanceof TileEntityCommandBlock && ((TileEntityCommandBlock)tileentity).getCommandBlockLogic().getSuccessCount() > 0;
    }

    @Override
    public int tickRate(World worldIn) {
        return 1;
    }

    @Override
    public boolean onBlockActivated(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand side, ItemStack hitX, EnumFacing hitY, float hitZ, float p_180639_9_, float p_180639_10_) {
        TileEntity tileentity = worldIn.getTileEntity(pos);
        if (tileentity instanceof TileEntityCommandBlock) {
            if (!playerIn.capabilities.isCreativeMode) {
                return false;
            }
            playerIn.func_184824_a((TileEntityCommandBlock)tileentity);
            return true;
        }
        return false;
    }

    @Override
    public boolean hasComparatorInputOverride(IBlockState state) {
        return true;
    }

    @Override
    public int getComparatorInputOverride(IBlockState worldIn, World pos, BlockPos p_180641_3_) {
        TileEntity tileentity = pos.getTileEntity(p_180641_3_);
        return tileentity instanceof TileEntityCommandBlock ? ((TileEntityCommandBlock)tileentity).getCommandBlockLogic().getSuccessCount() : 0;
    }

    @Override
    public void onBlockPlacedBy(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        TileEntity tileentity = worldIn.getTileEntity(pos);
        if (tileentity instanceof TileEntityCommandBlock) {
            TileEntityCommandBlock tileentitycommandblock = (TileEntityCommandBlock)tileentity;
            CommandBlockBaseLogic commandblockbaselogic = tileentitycommandblock.getCommandBlockLogic();
            if (stack.hasDisplayName()) {
                commandblockbaselogic.setName(stack.getDisplayName());
            }
            if (!worldIn.isRemote) {
                NBTTagCompound nbttagcompound = stack.getTagCompound();
                if (nbttagcompound == null || !nbttagcompound.hasKey("BlockEntityTag", 10)) {
                    commandblockbaselogic.setTrackOutput(worldIn.getGameRules().getBoolean("sendCommandFeedback"));
                    tileentitycommandblock.setAuto(this == Blocks.chain_command_block);
                }
                if (tileentitycommandblock.func_184251_i() == TileEntityCommandBlock.Mode.SEQUENCE) {
                    boolean flag = worldIn.isBlockPowered(pos);
                    tileentitycommandblock.setPowered(flag);
                }
            }
        }
    }

    @Override
    public int quantityDropped(Random random) {
        return 0;
    }

    @Override
    public EnumBlockRenderType getRenderType(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    @Override
    public IBlockState getStateFromMeta(int meta) {
        return this.getDefaultState().withProperty(FACING, EnumFacing.getFront(meta & 7)).withProperty(CONDITIONAL, (meta & 8) != 0);
    }

    @Override
    public int getMetaFromState(IBlockState state) {
        return state.getValue(FACING).getIndex() | (state.getValue(CONDITIONAL) != false ? 8 : 0);
    }

    @Override
    public IBlockState withRotation(IBlockState state, Rotation rot) {
        return state.withProperty(FACING, rot.func_185831_a(state.getValue(FACING)));
    }

    @Override
    public IBlockState withMirror(IBlockState state, Mirror mirrorIn) {
        return state.withRotation(mirrorIn.func_185800_a(state.getValue(FACING)));
    }

    @Override
    protected BlockStateContainer createBlockState() {
        return new BlockStateContainer(this, FACING, CONDITIONAL);
    }

    @Override
    public IBlockState onBlockPlaced(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.getDefaultState().withProperty(FACING, BlockPistonBase.func_185647_a(pos, placer)).withProperty(CONDITIONAL, false);
    }

    public void func_185563_c(World p_185563_1_, BlockPos p_185563_2_) {
        IBlockState iblockstate = p_185563_1_.getBlockState(p_185563_2_);
        if (iblockstate.getBlock() == Blocks.command_block || iblockstate.getBlock() == Blocks.repeating_command_block) {
            BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos(p_185563_2_);
            blockpos$mutableblockpos.func_185337_c(iblockstate.getValue(FACING));
            TileEntity tileentity = p_185563_1_.getTileEntity(blockpos$mutableblockpos);
            while (tileentity instanceof TileEntityCommandBlock) {
                IBlockState iblockstate1;
                Block block;
                TileEntityCommandBlock tileentitycommandblock = (TileEntityCommandBlock)tileentity;
                if (tileentitycommandblock.func_184251_i() != TileEntityCommandBlock.Mode.SEQUENCE || (block = (iblockstate1 = p_185563_1_.getBlockState(blockpos$mutableblockpos)).getBlock()) != Blocks.chain_command_block || p_185563_1_.func_184145_b(blockpos$mutableblockpos, block)) break;
                p_185563_1_.scheduleUpdate(new BlockPos(blockpos$mutableblockpos), block, this.tickRate(p_185563_1_));
                blockpos$mutableblockpos.func_185337_c(iblockstate1.getValue(FACING));
                tileentity = p_185563_1_.getTileEntity(blockpos$mutableblockpos);
            }
        }
    }
}

