/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.block.model;

import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.EnumFacing;

public class MultipartBakedModel
implements IBakedModel {
    private final Map<Predicate<IBlockState>, IBakedModel> field_188626_f;
    protected final boolean field_188621_a;
    protected final boolean field_188622_b;
    protected final TextureAtlasSprite field_188623_c;
    protected final ItemCameraTransforms field_188624_d;
    protected final ItemOverrideList field_188625_e;

    public MultipartBakedModel(Map<Predicate<IBlockState>, IBakedModel> p_i46536_1_) {
        this.field_188626_f = p_i46536_1_;
        IBakedModel ibakedmodel = p_i46536_1_.values().iterator().next();
        this.field_188621_a = ibakedmodel.isAmbientOcclusion();
        this.field_188622_b = ibakedmodel.isGui3d();
        this.field_188623_c = ibakedmodel.getParticleTexture();
        this.field_188624_d = ibakedmodel.getItemCameraTransforms();
        this.field_188625_e = ibakedmodel.getOverrides();
    }

    @Override
    public List<BakedQuad> getQuads(IBlockState state, EnumFacing side, long rand) {
        ArrayList list = Lists.newArrayList();
        if (state != null) {
            for (Map.Entry<Predicate<IBlockState>, IBakedModel> entry : this.field_188626_f.entrySet()) {
                if (!entry.getKey().apply((Object)state)) continue;
                list.addAll(entry.getValue().getQuads(state, side, rand++));
            }
        }
        return list;
    }

    @Override
    public boolean isAmbientOcclusion() {
        return this.field_188621_a;
    }

    @Override
    public boolean isGui3d() {
        return this.field_188622_b;
    }

    @Override
    public boolean isBuiltInRenderer() {
        return false;
    }

    @Override
    public TextureAtlasSprite getParticleTexture() {
        return this.field_188623_c;
    }

    @Override
    public ItemCameraTransforms getItemCameraTransforms() {
        return this.field_188624_d;
    }

    @Override
    public ItemOverrideList getOverrides() {
        return this.field_188625_e;
    }

    public static class Builder {
        private Map<Predicate<IBlockState>, IBakedModel> field_188649_a = Maps.newLinkedHashMap();

        public void func_188648_a(Predicate<IBlockState> p_188648_1_, IBakedModel p_188648_2_) {
            this.field_188649_a.put(p_188648_1_, p_188648_2_);
        }

        public IBakedModel func_188647_a() {
            return new MultipartBakedModel(this.field_188649_a);
        }
    }
}

