/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.entity;

import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelHorse;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderLiving;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.texture.LayeredTexture;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.passive.HorseArmorType;
import net.minecraft.util.ResourceLocation;

public class RenderHorse
extends RenderLiving<EntityHorse> {
    private static final Map<String, ResourceLocation> field_110852_a = Maps.newHashMap();

    public RenderHorse(RenderManager rendermanagerIn, ModelHorse model, float shadowSizeIn) {
        super(rendermanagerIn, model, shadowSizeIn);
    }

    @Override
    protected void preRenderCallback(EntityHorse entitylivingbaseIn, float partialTickTime) {
        float f = 1.0f;
        HorseArmorType horsearmortype = entitylivingbaseIn.getType();
        if (horsearmortype == HorseArmorType.DONKEY) {
            f *= 0.87f;
        } else if (horsearmortype == HorseArmorType.MULE) {
            f *= 0.92f;
        }
        GlStateManager.scale(f, f, f);
        super.preRenderCallback(entitylivingbaseIn, partialTickTime);
    }

    @Override
    protected ResourceLocation getEntityTexture(EntityHorse entity) {
        return !entity.func_110239_cn() ? entity.getType().func_188592_e() : this.func_188328_b(entity);
    }

    private ResourceLocation func_188328_b(EntityHorse p_188328_1_) {
        String s = p_188328_1_.getHorseTexture();
        if (!p_188328_1_.func_175507_cI()) {
            return null;
        }
        ResourceLocation resourcelocation = field_110852_a.get(s);
        if (resourcelocation == null) {
            resourcelocation = new ResourceLocation(s);
            Minecraft.getMinecraft().getTextureManager().loadTexture(resourcelocation, new LayeredTexture(p_188328_1_.getVariantTexturePaths()));
            field_110852_a.put(s, resourcelocation);
        }
        return resourcelocation;
    }
}

