/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.command.server;

import java.util.Collections;
import java.util.List;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;

public class CommandBroadcast
extends CommandBase {
    @Override
    public String getCommandName() {
        return "say";
    }

    @Override
    public int getRequiredPermissionLevel() {
        return 1;
    }

    @Override
    public String getCommandUsage(ICommandSender sender) {
        return "commands.say.usage";
    }

    @Override
    public void execute(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (args.length <= 0 || args[0].length() <= 0) {
            throw new WrongUsageException("commands.say.usage", new Object[0]);
        }
        ITextComponent itextcomponent = CommandBroadcast.getChatComponentFromNthArg(sender, args, 0, true);
        server.getPlayerList().sendChatMsg(new TextComponentTranslation("chat.type.announcement", sender.getDisplayName(), itextcomponent));
    }

    @Override
    public List<String> getTabCompletionOptions(MinecraftServer server, ICommandSender sender, String[] args, BlockPos pos) {
        return args.length >= 1 ? CommandBroadcast.getListOfStringsMatchingLastWord(args, server.getAllUsernames()) : Collections.emptyList();
    }
}

