/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.enchantment;

import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Enchantments;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.MathHelper;

public class EnchantmentProtection
extends Enchantment {
    public final Type protectionType;

    public EnchantmentProtection(Enchantment.Rarity rarityIn, Type protectionTypeIn, EntityEquipmentSlot ... slots) {
        super(rarityIn, EnumEnchantmentType.ARMOR, slots);
        this.protectionType = protectionTypeIn;
        if (protectionTypeIn == Type.FALL) {
            this.type = EnumEnchantmentType.ARMOR_FEET;
        }
    }

    @Override
    public int getMinEnchantability(int enchantmentLevel) {
        return this.protectionType.func_185316_b() + (enchantmentLevel - 1) * this.protectionType.func_185315_c();
    }

    @Override
    public int getMaxEnchantability(int enchantmentLevel) {
        return this.getMinEnchantability(enchantmentLevel) + this.protectionType.func_185315_c();
    }

    @Override
    public int getMaxLevel() {
        return 4;
    }

    @Override
    public int calcModifierDamage(int level, DamageSource source) {
        return source.canHarmInCreative() ? 0 : (this.protectionType == Type.ALL ? level : (this.protectionType == Type.FIRE && source.isFireDamage() ? level * 2 : (this.protectionType == Type.FALL && source == DamageSource.fall ? level * 3 : (this.protectionType == Type.EXPLOSION && source.isExplosion() ? level * 2 : (this.protectionType == Type.PROJECTILE && source.isProjectile() ? level * 2 : 0)))));
    }

    @Override
    public String getName() {
        return "enchantment.protect." + this.protectionType.func_185314_a();
    }

    @Override
    public boolean canApplyTogether(Enchantment ench) {
        if (ench instanceof EnchantmentProtection) {
            EnchantmentProtection enchantmentprotection = (EnchantmentProtection)ench;
            return this.protectionType == enchantmentprotection.protectionType ? false : this.protectionType == Type.FALL || enchantmentprotection.protectionType == Type.FALL;
        }
        return super.canApplyTogether(ench);
    }

    public static int getFireTimeForEntity(EntityLivingBase p_92093_0_, int p_92093_1_) {
        int i = EnchantmentHelper.func_185284_a(Enchantments.fireProtection, p_92093_0_);
        if (i > 0) {
            p_92093_1_ -= MathHelper.floor_float((float)p_92093_1_ * (float)i * 0.15f);
        }
        return p_92093_1_;
    }

    public static double func_92092_a(EntityLivingBase p_92092_0_, double p_92092_1_) {
        int i = EnchantmentHelper.func_185284_a(Enchantments.blastProtection, p_92092_0_);
        if (i > 0) {
            p_92092_1_ -= (double)MathHelper.floor_double(p_92092_1_ * (double)((float)i * 0.15f));
        }
        return p_92092_1_;
    }

    public static enum Type {
        ALL("all", 1, 11, 20),
        FIRE("fire", 10, 8, 12),
        FALL("fall", 5, 6, 10),
        EXPLOSION("explosion", 5, 8, 12),
        PROJECTILE("projectile", 3, 6, 15);

        private final String field_185322_f;
        private final int field_185323_g;
        private final int field_185324_h;
        private final int field_185325_i;

        private Type(String p_i47051_3_, int p_i47051_4_, int p_i47051_5_, int p_i47051_6_) {
            this.field_185322_f = p_i47051_3_;
            this.field_185323_g = p_i47051_4_;
            this.field_185324_h = p_i47051_5_;
            this.field_185325_i = p_i47051_6_;
        }

        public String func_185314_a() {
            return this.field_185322_f;
        }

        public int func_185316_b() {
            return this.field_185323_g;
        }

        public int func_185315_c() {
            return this.field_185324_h;
        }
    }
}

