/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.item;

import java.util.List;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.stats.AchievementList;
import net.minecraft.world.World;

public class ItemAppleGold
extends ItemFood {
    public ItemAppleGold(int amount, float saturation, boolean isWolfFood) {
        super(amount, saturation, isWolfFood);
        this.setHasSubtypes(true);
    }

    @Override
    public boolean hasEffect(ItemStack stack) {
        return stack.getMetadata() > 0;
    }

    @Override
    public EnumRarity getRarity(ItemStack stack) {
        return stack.getMetadata() == 0 ? EnumRarity.RARE : EnumRarity.EPIC;
    }

    @Override
    protected void onFoodEaten(ItemStack stack, World worldIn, EntityPlayer player) {
        if (!worldIn.isRemote) {
            if (stack.getMetadata() > 0) {
                player.triggerAchievement(AchievementList.field_187980_M);
                player.addPotionEffect(new PotionEffect(MobEffects.regeneration, 400, 1));
                player.addPotionEffect(new PotionEffect(MobEffects.resistance, 6000, 0));
                player.addPotionEffect(new PotionEffect(MobEffects.fireResistance, 6000, 0));
                player.addPotionEffect(new PotionEffect(MobEffects.absorption, 2400, 3));
            } else {
                player.addPotionEffect(new PotionEffect(MobEffects.regeneration, 100, 1));
                player.addPotionEffect(new PotionEffect(MobEffects.absorption, 2400, 0));
            }
        }
    }

    @Override
    public void getSubItems(Item itemIn, CreativeTabs tab, List<ItemStack> subItems) {
        subItems.add(new ItemStack(itemIn));
        subItems.add(new ItemStack(itemIn, 1, 1));
    }
}

