/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.item;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.UUID;
import net.minecraft.block.BlockDispenser;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.dispenser.BehaviorDefaultDispenseItem;
import net.minecraft.dispenser.IBehaviorDispenseItem;
import net.minecraft.dispenser.IBlockSource;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class ItemArmor
extends Item {
    private static final int[] maxDamageArray = new int[]{13, 15, 16, 11};
    private static final UUID[] field_185084_n = new UUID[]{UUID.fromString("845DB27C-C624-495F-8C9F-6020A9A58B6B"), UUID.fromString("D8499B04-0E66-4726-AB29-64469D734E0D"), UUID.fromString("9F3D476D-C118-4544-8365-64846904B48E"), UUID.fromString("2AD3F246-FEE1-4E67-B886-69FD380BB150")};
    public static final String[] EMPTY_SLOT_NAMES = new String[]{"minecraft:items/empty_armor_slot_boots", "minecraft:items/empty_armor_slot_leggings", "minecraft:items/empty_armor_slot_chestplate", "minecraft:items/empty_armor_slot_helmet"};
    public static final IBehaviorDispenseItem dispenserBehavior = new BehaviorDefaultDispenseItem(){

        @Override
        protected ItemStack dispenseStack(IBlockSource source, ItemStack stack) {
            ItemStack itemstack = ItemArmor.func_185082_a(source, stack);
            return itemstack != null ? itemstack : super.dispenseStack(source, stack);
        }
    };
    public final EntityEquipmentSlot armorType;
    public final int damageReduceAmount;
    public final int renderIndex;
    private final ArmorMaterial material;

    public static ItemStack func_185082_a(IBlockSource p_185082_0_, ItemStack p_185082_1_) {
        BlockPos blockpos = p_185082_0_.getBlockPos().offset(BlockDispenser.getFacing(p_185082_0_.getBlockMetadata()));
        int i = blockpos.getX();
        int j = blockpos.getY();
        int k = blockpos.getZ();
        AxisAlignedBB axisalignedbb = new AxisAlignedBB(i, j, k, i + 1, j + 1, k + 1);
        List<EntityLivingBase> list = p_185082_0_.getWorld().getEntitiesWithinAABB(EntityLivingBase.class, axisalignedbb, Predicates.and(EntitySelectors.NOT_SPECTATING, (Predicate)new EntitySelectors.ArmoredMob(p_185082_1_)));
        if (list.isEmpty()) {
            return null;
        }
        EntityLivingBase entitylivingbase = list.get(0);
        EntityEquipmentSlot entityequipmentslot = EntityLiving.func_184640_d(p_185082_1_);
        ItemStack itemstack = p_185082_1_.copy();
        itemstack.stackSize = 1;
        entitylivingbase.setItemStackToSlot(entityequipmentslot, itemstack);
        if (entitylivingbase instanceof EntityLiving) {
            ((EntityLiving)entitylivingbase).func_184642_a(entityequipmentslot, 2.0f);
        }
        --p_185082_1_.stackSize;
        return p_185082_1_;
    }

    public ItemArmor(ArmorMaterial p_i46750_1_, int p_i46750_2_, EntityEquipmentSlot p_i46750_3_) {
        this.material = p_i46750_1_;
        this.armorType = p_i46750_3_;
        this.renderIndex = p_i46750_2_;
        this.damageReduceAmount = p_i46750_1_.getDamageReductionAmount(p_i46750_3_);
        this.setMaxDamage(p_i46750_1_.getDurability(p_i46750_3_));
        this.maxStackSize = 1;
        this.setCreativeTab(CreativeTabs.tabCombat);
        BlockDispenser.dispenseBehaviorRegistry.putObject(this, dispenserBehavior);
    }

    public EntityEquipmentSlot func_185083_B_() {
        return this.armorType;
    }

    @Override
    public int getItemEnchantability() {
        return this.material.getEnchantability();
    }

    public ArmorMaterial getArmorMaterial() {
        return this.material;
    }

    public boolean hasColor(ItemStack stack) {
        if (this.material != ArmorMaterial.LEATHER) {
            return false;
        }
        NBTTagCompound nbttagcompound = stack.getTagCompound();
        return nbttagcompound != null && nbttagcompound.hasKey("display", 10) ? nbttagcompound.getCompoundTag("display").hasKey("color", 3) : false;
    }

    public int getColor(ItemStack stack) {
        NBTTagCompound nbttagcompound1;
        if (this.material != ArmorMaterial.LEATHER) {
            return 0xFFFFFF;
        }
        NBTTagCompound nbttagcompound = stack.getTagCompound();
        if (nbttagcompound != null && (nbttagcompound1 = nbttagcompound.getCompoundTag("display")) != null && nbttagcompound1.hasKey("color", 3)) {
            return nbttagcompound1.getInteger("color");
        }
        return 10511680;
    }

    public void removeColor(ItemStack stack) {
        NBTTagCompound nbttagcompound1;
        NBTTagCompound nbttagcompound;
        if (this.material == ArmorMaterial.LEATHER && (nbttagcompound = stack.getTagCompound()) != null && (nbttagcompound1 = nbttagcompound.getCompoundTag("display")).hasKey("color")) {
            nbttagcompound1.removeTag("color");
        }
    }

    public void setColor(ItemStack stack, int color) {
        if (this.material != ArmorMaterial.LEATHER) {
            throw new UnsupportedOperationException("Can't dye non-leather!");
        }
        NBTTagCompound nbttagcompound = stack.getTagCompound();
        if (nbttagcompound == null) {
            nbttagcompound = new NBTTagCompound();
            stack.setTagCompound(nbttagcompound);
        }
        NBTTagCompound nbttagcompound1 = nbttagcompound.getCompoundTag("display");
        if (!nbttagcompound.hasKey("display", 10)) {
            nbttagcompound.setTag("display", nbttagcompound1);
        }
        nbttagcompound1.setInteger("color", color);
    }

    @Override
    public boolean getIsRepairable(ItemStack toRepair, ItemStack repair) {
        return this.material.getRepairItem() == repair.getItem() ? true : super.getIsRepairable(toRepair, repair);
    }

    @Override
    public ActionResult<ItemStack> onItemRightClick(ItemStack itemStackIn, World worldIn, EntityPlayer playerIn, EnumHand hand) {
        EntityEquipmentSlot entityequipmentslot = EntityLiving.func_184640_d(itemStackIn);
        ItemStack itemstack = playerIn.getItemStackFromSlot(entityequipmentslot);
        if (itemstack == null) {
            playerIn.setItemStackToSlot(entityequipmentslot, itemStackIn.copy());
            itemStackIn.stackSize = 0;
            return new ActionResult<ItemStack>(EnumActionResult.SUCCESS, itemStackIn);
        }
        return new ActionResult<ItemStack>(EnumActionResult.FAIL, itemStackIn);
    }

    @Override
    public Multimap<String, AttributeModifier> getItemAttributeModifiers(EntityEquipmentSlot p_111205_1_) {
        Multimap<String, AttributeModifier> multimap = super.getItemAttributeModifiers(p_111205_1_);
        if (p_111205_1_ == this.armorType) {
            multimap.put((Object)SharedMonsterAttributes.ARMOR.getAttributeUnlocalizedName(), (Object)new AttributeModifier(field_185084_n[p_111205_1_.func_188454_b()], "Armor modifier", this.damageReduceAmount, 0));
        }
        return multimap;
    }

    public static enum ArmorMaterial {
        LEATHER("leather", 5, new int[]{1, 2, 3, 1}, 15, SoundEvents.item_armor_equip_leather),
        CHAIN("chainmail", 15, new int[]{1, 4, 5, 2}, 12, SoundEvents.item_armor_equip_chain),
        IRON("iron", 15, new int[]{2, 5, 6, 2}, 9, SoundEvents.item_armor_equip_iron),
        GOLD("gold", 7, new int[]{1, 3, 5, 2}, 25, SoundEvents.item_armor_equip_gold),
        DIAMOND("diamond", 33, new int[]{3, 6, 8, 3}, 10, SoundEvents.item_armor_equip_diamond);

        private final String name;
        private final int maxDamageFactor;
        private final int[] damageReductionAmountArray;
        private final int enchantability;
        private final SoundEvent field_185020_j;

        private ArmorMaterial(String p_i46796_3_, int p_i46796_4_, int[] p_i46796_5_, int p_i46796_6_, SoundEvent p_i46796_7_) {
            this.name = p_i46796_3_;
            this.maxDamageFactor = p_i46796_4_;
            this.damageReductionAmountArray = p_i46796_5_;
            this.enchantability = p_i46796_6_;
            this.field_185020_j = p_i46796_7_;
        }

        public int getDurability(EntityEquipmentSlot armorType) {
            return maxDamageArray[armorType.func_188454_b()] * this.maxDamageFactor;
        }

        public int getDamageReductionAmount(EntityEquipmentSlot armorType) {
            return this.damageReductionAmountArray[armorType.func_188454_b()];
        }

        public int getEnchantability() {
            return this.enchantability;
        }

        public SoundEvent func_185017_b() {
            return this.field_185020_j;
        }

        public Item getRepairItem() {
            return this == LEATHER ? Items.leather : (this == CHAIN ? Items.iron_ingot : (this == GOLD ? Items.gold_ingot : (this == IRON ? Items.iron_ingot : (this == DIAMOND ? Items.diamond : null))));
        }

        public String getName() {
            return this.name;
        }
    }
}

