/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.item;

import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;

public class ItemBucket
extends Item {
    private Block isFull;

    public ItemBucket(Block containedBlock) {
        this.maxStackSize = 1;
        this.isFull = containedBlock;
        this.setCreativeTab(CreativeTabs.tabMisc);
    }

    @Override
    public ActionResult<ItemStack> onItemRightClick(ItemStack itemStackIn, World worldIn, EntityPlayer playerIn, EnumHand hand) {
        BlockPos blockpos1;
        boolean flag = this.isFull == Blocks.air;
        RayTraceResult raytraceresult = this.getMovingObjectPositionFromPlayer(worldIn, playerIn, flag);
        if (raytraceresult == null) {
            return new ActionResult<ItemStack>(EnumActionResult.PASS, itemStackIn);
        }
        if (raytraceresult.typeOfHit != RayTraceResult.Type.BLOCK) {
            return new ActionResult<ItemStack>(EnumActionResult.PASS, itemStackIn);
        }
        BlockPos blockpos = raytraceresult.getBlockPos();
        if (!worldIn.isBlockModifiable(playerIn, blockpos)) {
            return new ActionResult<ItemStack>(EnumActionResult.FAIL, itemStackIn);
        }
        if (flag) {
            if (!playerIn.canPlayerEdit(blockpos.offset(raytraceresult.sideHit), raytraceresult.sideHit, itemStackIn)) {
                return new ActionResult<ItemStack>(EnumActionResult.FAIL, itemStackIn);
            }
            IBlockState iblockstate = worldIn.getBlockState(blockpos);
            Material material = iblockstate.getMaterial();
            if (material == Material.water && iblockstate.getValue(BlockLiquid.LEVEL) == 0) {
                worldIn.setBlockState(blockpos, Blocks.air.getDefaultState(), 11);
                playerIn.triggerAchievement(StatList.func_188057_b(this));
                playerIn.playSound(SoundEvents.item_bucket_fill, 1.0f, 1.0f);
                return new ActionResult<ItemStack>(EnumActionResult.SUCCESS, this.fillBucket(itemStackIn, playerIn, Items.water_bucket));
            }
            if (material == Material.lava && iblockstate.getValue(BlockLiquid.LEVEL) == 0) {
                playerIn.playSound(SoundEvents.item_bucket_fill_lava, 1.0f, 1.0f);
                worldIn.setBlockState(blockpos, Blocks.air.getDefaultState(), 11);
                playerIn.triggerAchievement(StatList.func_188057_b(this));
                return new ActionResult<ItemStack>(EnumActionResult.SUCCESS, this.fillBucket(itemStackIn, playerIn, Items.lava_bucket));
            }
            return new ActionResult<ItemStack>(EnumActionResult.FAIL, itemStackIn);
        }
        boolean flag1 = worldIn.getBlockState(blockpos).getBlock().isReplaceable(worldIn, blockpos);
        BlockPos blockPos = blockpos1 = flag1 && raytraceresult.sideHit == EnumFacing.UP ? blockpos : blockpos.offset(raytraceresult.sideHit);
        if (!playerIn.canPlayerEdit(blockpos1, raytraceresult.sideHit, itemStackIn)) {
            return new ActionResult<ItemStack>(EnumActionResult.FAIL, itemStackIn);
        }
        if (this.tryPlaceContainedLiquid(playerIn, worldIn, blockpos1)) {
            playerIn.triggerAchievement(StatList.func_188057_b(this));
            return !playerIn.capabilities.isCreativeMode ? new ActionResult<ItemStack>(EnumActionResult.SUCCESS, new ItemStack(Items.bucket)) : new ActionResult<ItemStack>(EnumActionResult.SUCCESS, itemStackIn);
        }
        return new ActionResult<ItemStack>(EnumActionResult.FAIL, itemStackIn);
    }

    private ItemStack fillBucket(ItemStack emptyBuckets, EntityPlayer player, Item fullBucket) {
        if (player.capabilities.isCreativeMode) {
            return emptyBuckets;
        }
        if (--emptyBuckets.stackSize <= 0) {
            return new ItemStack(fullBucket);
        }
        if (!player.inventory.addItemStackToInventory(new ItemStack(fullBucket))) {
            player.dropPlayerItemWithRandomChoice(new ItemStack(fullBucket), false);
        }
        return emptyBuckets;
    }

    public boolean tryPlaceContainedLiquid(EntityPlayer worldIn, World pos, BlockPos p_180616_3_) {
        if (this.isFull == Blocks.air) {
            return false;
        }
        IBlockState iblockstate = pos.getBlockState(p_180616_3_);
        Material material = iblockstate.getMaterial();
        boolean flag = !material.isSolid();
        boolean flag1 = iblockstate.getBlock().isReplaceable(pos, p_180616_3_);
        if (!(pos.isAirBlock(p_180616_3_) || flag || flag1)) {
            return false;
        }
        if (pos.provider.doesWaterVaporize() && this.isFull == Blocks.flowing_water) {
            int l = p_180616_3_.getX();
            int i = p_180616_3_.getY();
            int j = p_180616_3_.getZ();
            pos.func_184133_a(worldIn, p_180616_3_, SoundEvents.block_fire_extinguish, SoundCategory.BLOCKS, 0.5f, 2.6f + (pos.rand.nextFloat() - pos.rand.nextFloat()) * 0.8f);
            int k = 0;
            while (k < 8) {
                pos.spawnParticle(EnumParticleTypes.SMOKE_LARGE, (double)l + Math.random(), (double)i + Math.random(), (double)j + Math.random(), 0.0, 0.0, 0.0, new int[0]);
                ++k;
            }
        } else {
            if (!pos.isRemote && (flag || flag1) && !material.isLiquid()) {
                pos.destroyBlock(p_180616_3_, true);
            }
            SoundEvent soundevent = this.isFull == Blocks.flowing_lava ? SoundEvents.item_bucket_empty_lava : SoundEvents.item_bucket_empty;
            pos.func_184133_a(worldIn, p_180616_3_, soundevent, SoundCategory.BLOCKS, 1.0f, 1.0f);
            pos.setBlockState(p_180616_3_, this.isFull.getDefaultState(), 11);
        }
        return true;
    }
}

