/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.item;

import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityEnderCrystal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldProviderEnd;
import net.minecraft.world.end.DragonFightManager;

public class ItemEndCrystal
extends Item {
    public ItemEndCrystal() {
        this.setUnlocalizedName("end_crystal");
        this.setCreativeTab(CreativeTabs.tabDecorations);
    }

    @Override
    public EnumActionResult onItemUse(ItemStack stack, EntityPlayer playerIn, World worldIn, BlockPos pos, EnumHand side, EnumFacing hitX, float hitY, float hitZ, float p_180614_9_) {
        double d2;
        double d1;
        IBlockState iblockstate = worldIn.getBlockState(pos);
        if (iblockstate.getBlock() != Blocks.obsidian && iblockstate.getBlock() != Blocks.bedrock) {
            return EnumActionResult.FAIL;
        }
        BlockPos blockpos = pos.up();
        if (!playerIn.canPlayerEdit(blockpos, hitX, stack)) {
            return EnumActionResult.FAIL;
        }
        BlockPos blockpos1 = blockpos.up();
        boolean flag = !worldIn.isAirBlock(blockpos) && !worldIn.getBlockState(blockpos).getBlock().isReplaceable(worldIn, blockpos);
        if (flag |= !worldIn.isAirBlock(blockpos1) && !worldIn.getBlockState(blockpos1).getBlock().isReplaceable(worldIn, blockpos1)) {
            return EnumActionResult.FAIL;
        }
        double d0 = blockpos.getX();
        List<Entity> list = worldIn.getEntitiesWithinAABBExcludingEntity(null, new AxisAlignedBB(d0, d1 = (double)blockpos.getY(), d2 = (double)blockpos.getZ(), d0 + 1.0, d1 + 2.0, d2 + 1.0));
        if (!list.isEmpty()) {
            return EnumActionResult.FAIL;
        }
        if (!worldIn.isRemote) {
            EntityEnderCrystal entityendercrystal = new EntityEnderCrystal(worldIn, (float)pos.getX() + 0.5f, pos.getY() + 1, (float)pos.getZ() + 0.5f);
            entityendercrystal.setShowBottom(false);
            worldIn.spawnEntityInWorld(entityendercrystal);
            if (worldIn.provider instanceof WorldProviderEnd) {
                DragonFightManager dragonfightmanager = ((WorldProviderEnd)worldIn.provider).getDragonFightManager();
                dragonfightmanager.func_186106_e();
            }
        }
        --stack.stackSize;
        return EnumActionResult.SUCCESS;
    }

    @Override
    public boolean hasEffect(ItemStack stack) {
        return true;
    }
}

