/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.play.server;

import java.io.IOException;
import java.util.List;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.Packet;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.play.INetHandlerPlayClient;

public class SPacketSpawnPlayer
implements Packet<INetHandlerPlayClient> {
    private int entityId;
    private UUID playerId;
    private double x;
    private double y;
    private double z;
    private byte yaw;
    private byte pitch;
    private EntityDataManager watcher;
    private List<EntityDataManager.DataEntry<?>> dataManagerEntries;

    public SPacketSpawnPlayer() {
    }

    public SPacketSpawnPlayer(EntityPlayer p_i46971_1_) {
        this.entityId = p_i46971_1_.getEntityId();
        this.playerId = p_i46971_1_.getGameProfile().getId();
        this.x = p_i46971_1_.posX;
        this.y = p_i46971_1_.posY;
        this.z = p_i46971_1_.posZ;
        this.yaw = (byte)(p_i46971_1_.rotationYaw * 256.0f / 360.0f);
        this.pitch = (byte)(p_i46971_1_.rotationPitch * 256.0f / 360.0f);
        this.watcher = p_i46971_1_.getDataManager();
    }

    @Override
    public void readPacketData(PacketBuffer buf) throws IOException {
        this.entityId = buf.readVarIntFromBuffer();
        this.playerId = buf.readUuid();
        this.x = buf.readDouble();
        this.y = buf.readDouble();
        this.z = buf.readDouble();
        this.yaw = buf.readByte();
        this.pitch = buf.readByte();
        this.dataManagerEntries = EntityDataManager.readEntries(buf);
    }

    @Override
    public void writePacketData(PacketBuffer buf) throws IOException {
        buf.writeVarIntToBuffer(this.entityId);
        buf.writeUuid(this.playerId);
        buf.writeDouble(this.x);
        buf.writeDouble(this.y);
        buf.writeDouble(this.z);
        buf.writeByte(this.yaw);
        buf.writeByte(this.pitch);
        this.watcher.writeEntries(buf);
    }

    @Override
    public void processPacket(INetHandlerPlayClient handler) {
        handler.handleSpawnPlayer(this);
    }

    public List<EntityDataManager.DataEntry<?>> getDataManagerEntries() {
        if (this.dataManagerEntries == null) {
            this.dataManagerEntries = this.watcher.getAll();
        }
        return this.dataManagerEntries;
    }

    public int getEntityID() {
        return this.entityId;
    }

    public UUID getPlayer() {
        return this.playerId;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    public byte getYaw() {
        return this.yaw;
    }

    public byte getPitch() {
        return this.pitch;
    }
}

