/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.pathfinding;

import net.minecraft.network.PacketBuffer;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.math.MathHelper;

public class PathPoint {
    public final int xCoord;
    public final int yCoord;
    public final int zCoord;
    private final int hash;
    public int index = -1;
    public float totalPathDistance;
    public float distanceToNext;
    public float distanceToTarget;
    public PathPoint previous;
    public boolean visited;
    public float field_186284_j = 0.0f;
    public float field_186285_k = 0.0f;
    public float field_186286_l = 0.0f;
    public PathNodeType field_186287_m = PathNodeType.BLOCKED;

    public PathPoint(int x, int y, int z) {
        this.xCoord = x;
        this.yCoord = y;
        this.zCoord = z;
        this.hash = PathPoint.makeHash(x, y, z);
    }

    public PathPoint func_186283_a(int p_186283_1_, int p_186283_2_, int p_186283_3_) {
        PathPoint pathpoint = new PathPoint(p_186283_1_, p_186283_2_, p_186283_3_);
        pathpoint.index = this.index;
        pathpoint.totalPathDistance = this.totalPathDistance;
        pathpoint.distanceToNext = this.distanceToNext;
        pathpoint.distanceToTarget = this.distanceToTarget;
        pathpoint.previous = this.previous;
        pathpoint.visited = this.visited;
        pathpoint.field_186284_j = this.field_186284_j;
        pathpoint.field_186285_k = this.field_186285_k;
        pathpoint.field_186286_l = this.field_186286_l;
        pathpoint.field_186287_m = this.field_186287_m;
        return pathpoint;
    }

    public static int makeHash(int x, int y, int z) {
        return y & 0xFF | (x & Short.MAX_VALUE) << 8 | (z & Short.MAX_VALUE) << 24 | (x < 0 ? Integer.MIN_VALUE : 0) | (z < 0 ? 32768 : 0);
    }

    public float distanceTo(PathPoint pathpointIn) {
        float f = pathpointIn.xCoord - this.xCoord;
        float f1 = pathpointIn.yCoord - this.yCoord;
        float f2 = pathpointIn.zCoord - this.zCoord;
        return MathHelper.sqrt_float(f * f + f1 * f1 + f2 * f2);
    }

    public float distanceToSquared(PathPoint pathpointIn) {
        float f = pathpointIn.xCoord - this.xCoord;
        float f1 = pathpointIn.yCoord - this.yCoord;
        float f2 = pathpointIn.zCoord - this.zCoord;
        return f * f + f1 * f1 + f2 * f2;
    }

    public float func_186281_c(PathPoint p_186281_1_) {
        float f = Math.abs(p_186281_1_.xCoord - this.xCoord);
        float f1 = Math.abs(p_186281_1_.yCoord - this.yCoord);
        float f2 = Math.abs(p_186281_1_.zCoord - this.zCoord);
        return f + f1 + f2;
    }

    public boolean equals(Object p_equals_1_) {
        if (!(p_equals_1_ instanceof PathPoint)) {
            return false;
        }
        PathPoint pathpoint = (PathPoint)p_equals_1_;
        return this.hash == pathpoint.hash && this.xCoord == pathpoint.xCoord && this.yCoord == pathpoint.yCoord && this.zCoord == pathpoint.zCoord;
    }

    public int hashCode() {
        return this.hash;
    }

    public boolean isAssigned() {
        return this.index >= 0;
    }

    public String toString() {
        return String.valueOf(this.xCoord) + ", " + this.yCoord + ", " + this.zCoord;
    }

    public static PathPoint func_186282_b(PacketBuffer p_186282_0_) {
        PathPoint pathpoint = new PathPoint(p_186282_0_.readInt(), p_186282_0_.readInt(), p_186282_0_.readInt());
        pathpoint.field_186284_j = p_186282_0_.readFloat();
        pathpoint.field_186285_k = p_186282_0_.readFloat();
        pathpoint.field_186286_l = p_186282_0_.readFloat();
        pathpoint.visited = p_186282_0_.readBoolean();
        pathpoint.field_186287_m = PathNodeType.values()[p_186282_0_.readInt()];
        pathpoint.distanceToTarget = p_186282_0_.readFloat();
        return pathpoint;
    }
}

