/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world;

import net.minecraft.entity.player.PlayerCapabilities;
import net.minecraft.world.WorldType;
import net.minecraft.world.storage.WorldInfo;

public final class WorldSettings {
    private final long seed;
    private final GameType theGameType;
    private final boolean mapFeaturesEnabled;
    private final boolean hardcoreEnabled;
    private final WorldType terrainType;
    private boolean commandsAllowed;
    private boolean bonusChestEnabled;
    private String worldName = "";

    public WorldSettings(long seedIn, GameType gameType, boolean enableMapFeatures, boolean hardcoreMode, WorldType worldTypeIn) {
        this.seed = seedIn;
        this.theGameType = gameType;
        this.mapFeaturesEnabled = enableMapFeatures;
        this.hardcoreEnabled = hardcoreMode;
        this.terrainType = worldTypeIn;
    }

    public WorldSettings(WorldInfo info) {
        this(info.getSeed(), info.getGameType(), info.isMapFeaturesEnabled(), info.isHardcoreModeEnabled(), info.getTerrainType());
    }

    public WorldSettings enableBonusChest() {
        this.bonusChestEnabled = true;
        return this;
    }

    public WorldSettings enableCommands() {
        this.commandsAllowed = true;
        return this;
    }

    public WorldSettings setWorldName(String name) {
        this.worldName = name;
        return this;
    }

    public boolean isBonusChestEnabled() {
        return this.bonusChestEnabled;
    }

    public long getSeed() {
        return this.seed;
    }

    public GameType getGameType() {
        return this.theGameType;
    }

    public boolean getHardcoreEnabled() {
        return this.hardcoreEnabled;
    }

    public boolean isMapFeaturesEnabled() {
        return this.mapFeaturesEnabled;
    }

    public WorldType getTerrainType() {
        return this.terrainType;
    }

    public boolean areCommandsAllowed() {
        return this.commandsAllowed;
    }

    public static GameType getGameTypeById(int id) {
        return GameType.getByID(id);
    }

    public String getWorldName() {
        return this.worldName;
    }

    public static enum GameType {
        NOT_SET(-1, "", ""),
        SURVIVAL(0, "survival", "s"),
        CREATIVE(1, "creative", "c"),
        ADVENTURE(2, "adventure", "a"),
        SPECTATOR(3, "spectator", "sp");

        int id;
        String name;
        String field_185330_h;

        private GameType(int p_i46718_3_, String p_i46718_4_, String p_i46718_5_) {
            this.id = p_i46718_3_;
            this.name = p_i46718_4_;
            this.field_185330_h = p_i46718_5_;
        }

        public int getID() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public void configurePlayerCapabilities(PlayerCapabilities capabilities) {
            if (this == CREATIVE) {
                capabilities.allowFlying = true;
                capabilities.isCreativeMode = true;
                capabilities.disableDamage = true;
            } else if (this == SPECTATOR) {
                capabilities.allowFlying = true;
                capabilities.isCreativeMode = false;
                capabilities.disableDamage = true;
                capabilities.isFlying = true;
            } else {
                capabilities.allowFlying = false;
                capabilities.isCreativeMode = false;
                capabilities.disableDamage = false;
                capabilities.isFlying = false;
            }
            capabilities.allowEdit = !this.isAdventure();
        }

        public boolean isAdventure() {
            return this == ADVENTURE || this == SPECTATOR;
        }

        public boolean isCreative() {
            return this == CREATIVE;
        }

        public boolean isSurvivalOrAdventure() {
            return this == SURVIVAL || this == ADVENTURE;
        }

        public static GameType getByID(int idIn) {
            return GameType.func_185329_a(idIn, SURVIVAL);
        }

        public static GameType func_185329_a(int p_185329_0_, GameType p_185329_1_) {
            GameType[] gameTypeArray = GameType.values();
            int n = gameTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                GameType worldsettings$gametype = gameTypeArray[n2];
                if (worldsettings$gametype.id == p_185329_0_) {
                    return worldsettings$gametype;
                }
                ++n2;
            }
            return p_185329_1_;
        }

        public static GameType getByName(String gamemodeName) {
            return GameType.func_185328_a(gamemodeName, SURVIVAL);
        }

        public static GameType func_185328_a(String p_185328_0_, GameType p_185328_1_) {
            GameType[] gameTypeArray = GameType.values();
            int n = gameTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                GameType worldsettings$gametype = gameTypeArray[n2];
                if (worldsettings$gametype.name.equals(p_185328_0_) || worldsettings$gametype.field_185330_h.equals(p_185328_0_)) {
                    return worldsettings$gametype;
                }
                ++n2;
            }
            return p_185328_1_;
        }
    }
}

