/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.gen.feature;

import java.util.Random;
import net.minecraft.block.BlockTorch;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;

public class WorldGenEndPodium
extends WorldGenerator {
    public static final BlockPos field_186139_a = BlockPos.ORIGIN;
    public static final BlockPos field_186140_b = new BlockPos(field_186139_a.getX() - 4 & 0xFFFFFFF0, 0, field_186139_a.getZ() - 4 & 0xFFFFFFF0);
    private final boolean field_186141_c;

    public WorldGenEndPodium(boolean p_i46666_1_) {
        this.field_186141_c = p_i46666_1_;
    }

    @Override
    public boolean generate(World worldIn, Random rand, BlockPos position) {
        for (BlockPos.MutableBlockPos blockpos$mutableblockpos : BlockPos.getAllInBoxMutable(new BlockPos(position.getX() - 4, position.getY() - 1, position.getZ() - 4), new BlockPos(position.getX() + 4, position.getY() + 32, position.getZ() + 4))) {
            double d0 = blockpos$mutableblockpos.func_185332_f(position.getX(), blockpos$mutableblockpos.getY(), position.getZ());
            if (!(d0 <= 3.5)) continue;
            if (blockpos$mutableblockpos.getY() < position.getY()) {
                if (d0 <= 2.5) {
                    this.setBlockAndNotifyAdequately(worldIn, blockpos$mutableblockpos, Blocks.bedrock.getDefaultState());
                    continue;
                }
                if (blockpos$mutableblockpos.getY() >= position.getY()) continue;
                this.setBlockAndNotifyAdequately(worldIn, blockpos$mutableblockpos, Blocks.end_stone.getDefaultState());
                continue;
            }
            if (blockpos$mutableblockpos.getY() > position.getY()) {
                this.setBlockAndNotifyAdequately(worldIn, blockpos$mutableblockpos, Blocks.air.getDefaultState());
                continue;
            }
            if (d0 > 2.5) {
                this.setBlockAndNotifyAdequately(worldIn, blockpos$mutableblockpos, Blocks.bedrock.getDefaultState());
                continue;
            }
            if (this.field_186141_c) {
                this.setBlockAndNotifyAdequately(worldIn, new BlockPos(blockpos$mutableblockpos), Blocks.end_portal.getDefaultState());
                continue;
            }
            this.setBlockAndNotifyAdequately(worldIn, new BlockPos(blockpos$mutableblockpos), Blocks.air.getDefaultState());
        }
        int i = 0;
        while (i < 4) {
            this.setBlockAndNotifyAdequately(worldIn, position.up(i), Blocks.bedrock.getDefaultState());
            ++i;
        }
        BlockPos blockpos = position.up(2);
        for (EnumFacing enumfacing : EnumFacing.Plane.HORIZONTAL) {
            this.setBlockAndNotifyAdequately(worldIn, blockpos.offset(enumfacing), Blocks.torch.getDefaultState().withProperty(BlockTorch.FACING, enumfacing));
        }
        return true;
    }
}

