/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.gen.structure;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.gen.structure.MapGenStructure;
import net.minecraft.world.gen.structure.StructureComponent;
import net.minecraft.world.gen.structure.StructureStart;
import net.minecraft.world.gen.structure.StructureStrongholdPieces;

public class MapGenStronghold
extends MapGenStructure {
    private List<BiomeGenBase> field_151546_e;
    private boolean ranBiomeCheck;
    private ChunkCoordIntPair[] structureCoords = new ChunkCoordIntPair[128];
    private double field_82671_h = 32.0;
    private int field_82672_i = 3;

    public MapGenStronghold() {
        this.field_151546_e = Lists.newArrayList();
        for (BiomeGenBase biomegenbase : BiomeGenBase.biomeRegistry) {
            if (biomegenbase == null || !(biomegenbase.getBaseHeight() > 0.0f)) continue;
            this.field_151546_e.add(biomegenbase);
        }
    }

    public MapGenStronghold(Map<String, String> p_i2068_1_) {
        this();
        for (Map.Entry<String, String> entry : p_i2068_1_.entrySet()) {
            if (entry.getKey().equals("distance")) {
                this.field_82671_h = MathHelper.parseDoubleWithDefaultAndMax(entry.getValue(), this.field_82671_h, 1.0);
                continue;
            }
            if (entry.getKey().equals("count")) {
                this.structureCoords = new ChunkCoordIntPair[MathHelper.parseIntWithDefaultAndMax(entry.getValue(), this.structureCoords.length, 1)];
                continue;
            }
            if (!entry.getKey().equals("spread")) continue;
            this.field_82672_i = MathHelper.parseIntWithDefaultAndMax(entry.getValue(), this.field_82672_i, 1);
        }
    }

    @Override
    public String getStructureName() {
        return "Stronghold";
    }

    @Override
    public BlockPos getClosestStrongholdPos(World worldIn, BlockPos pos) {
        if (!this.ranBiomeCheck) {
            this.func_189104_c();
            this.ranBiomeCheck = true;
        }
        BlockPos blockpos = null;
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos(0, 0, 0);
        double d0 = Double.MAX_VALUE;
        ChunkCoordIntPair[] chunkCoordIntPairArray = this.structureCoords;
        int n = this.structureCoords.length;
        int n2 = 0;
        while (n2 < n) {
            ChunkCoordIntPair chunkcoordintpair = chunkCoordIntPairArray[n2];
            blockpos$mutableblockpos.set((chunkcoordintpair.chunkXPos << 4) + 8, 32, (chunkcoordintpair.chunkZPos << 4) + 8);
            double d1 = blockpos$mutableblockpos.distanceSq(pos);
            if (blockpos == null) {
                blockpos = new BlockPos(blockpos$mutableblockpos);
                d0 = d1;
            } else if (d1 < d0) {
                blockpos = new BlockPos(blockpos$mutableblockpos);
                d0 = d1;
            }
            ++n2;
        }
        return blockpos;
    }

    @Override
    protected boolean canSpawnStructureAtCoords(int chunkX, int chunkZ) {
        if (!this.ranBiomeCheck) {
            this.func_189104_c();
            this.ranBiomeCheck = true;
        }
        ChunkCoordIntPair[] chunkCoordIntPairArray = this.structureCoords;
        int n = this.structureCoords.length;
        int n2 = 0;
        while (n2 < n) {
            ChunkCoordIntPair chunkcoordintpair = chunkCoordIntPairArray[n2];
            if (chunkX == chunkcoordintpair.chunkXPos && chunkZ == chunkcoordintpair.chunkZPos) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private void func_189104_c() {
        this.initializeStructureData(this.worldObj);
        int i = 0;
        for (StructureStart structurestart : this.structureMap.values()) {
            if (i >= this.structureCoords.length) continue;
            this.structureCoords[i++] = new ChunkCoordIntPair(structurestart.getChunkPosX(), structurestart.getChunkPosZ());
        }
        Random random = new Random();
        random.setSeed(this.worldObj.getSeed());
        double d1 = random.nextDouble() * Math.PI * 2.0;
        int j = 0;
        int k = 0;
        int l = this.structureMap.size();
        if (l < this.structureCoords.length) {
            int i1 = 0;
            while (i1 < this.structureCoords.length) {
                double d0 = 4.0 * this.field_82671_h + this.field_82671_h * (double)j * 6.0 + (random.nextDouble() - 0.5) * this.field_82671_h * 2.5;
                int j1 = (int)Math.round(Math.cos(d1) * d0);
                int k1 = (int)Math.round(Math.sin(d1) * d0);
                BlockPos blockpos = this.worldObj.getWorldChunkManager().findBiomePosition((j1 << 4) + 8, (k1 << 4) + 8, 112, this.field_151546_e, random);
                if (blockpos != null) {
                    j1 = blockpos.getX() >> 4;
                    k1 = blockpos.getZ() >> 4;
                }
                if (i1 >= l) {
                    this.structureCoords[i1] = new ChunkCoordIntPair(j1, k1);
                }
                d1 += Math.PI * 2 / (double)this.field_82672_i;
                if (++k == this.field_82672_i) {
                    k = 0;
                    this.field_82672_i += 2 * this.field_82672_i / (++j + 1);
                    this.field_82672_i = Math.min(this.field_82672_i, this.structureCoords.length - i1);
                    d1 += random.nextDouble() * Math.PI * 2.0;
                }
                ++i1;
            }
        }
    }

    @Override
    protected List<BlockPos> getCoordList() {
        ArrayList list = Lists.newArrayList();
        ChunkCoordIntPair[] chunkCoordIntPairArray = this.structureCoords;
        int n = this.structureCoords.length;
        int n2 = 0;
        while (n2 < n) {
            ChunkCoordIntPair chunkcoordintpair = chunkCoordIntPairArray[n2];
            if (chunkcoordintpair != null) {
                list.add(chunkcoordintpair.getCenterBlock(64));
            }
            ++n2;
        }
        return list;
    }

    @Override
    protected StructureStart getStructureStart(int chunkX, int chunkZ) {
        Start mapgenstronghold$start = new Start(this.worldObj, this.rand, chunkX, chunkZ);
        while (mapgenstronghold$start.func_186161_c().isEmpty() || ((StructureStrongholdPieces.Stairs2)mapgenstronghold$start.func_186161_c().get((int)0)).strongholdPortalRoom == null) {
            mapgenstronghold$start = new Start(this.worldObj, this.rand, chunkX, chunkZ);
        }
        return mapgenstronghold$start;
    }

    public static class Start
    extends StructureStart {
        public Start() {
        }

        public Start(World worldIn, Random p_i2067_2_, int p_i2067_3_, int p_i2067_4_) {
            super(p_i2067_3_, p_i2067_4_);
            StructureStrongholdPieces.prepareStructurePieces();
            StructureStrongholdPieces.Stairs2 structurestrongholdpieces$stairs2 = new StructureStrongholdPieces.Stairs2(0, p_i2067_2_, (p_i2067_3_ << 4) + 2, (p_i2067_4_ << 4) + 2);
            this.components.add(structurestrongholdpieces$stairs2);
            structurestrongholdpieces$stairs2.buildComponent(structurestrongholdpieces$stairs2, this.components, p_i2067_2_);
            List<StructureComponent> list = structurestrongholdpieces$stairs2.field_75026_c;
            while (!list.isEmpty()) {
                int i = p_i2067_2_.nextInt(list.size());
                StructureComponent structurecomponent = list.remove(i);
                structurecomponent.buildComponent(structurestrongholdpieces$stairs2, this.components, p_i2067_2_);
            }
            this.updateBoundingBox();
            this.markAvailableHeight(worldIn, p_i2067_2_, 10);
        }
    }
}

