/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.gen.structure.template;

import com.google.common.collect.Maps;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.gen.structure.template.Template;
import org.apache.commons.io.IOUtils;

public class TemplateManager {
    private final Map<String, Template> templates = Maps.newHashMap();
    private final String field_186241_b;

    public TemplateManager() {
        this("structures");
    }

    public TemplateManager(String p_i46661_1_) {
        this.field_186241_b = p_i46661_1_;
    }

    public Template getTemplate(MinecraftServer server, ResourceLocation id) {
        String s = id.getResourcePath();
        if (this.templates.containsKey(s)) {
            return this.templates.get(s);
        }
        if (server != null) {
            this.func_186235_b(server, id);
        } else {
            this.func_186236_a(id);
        }
        if (this.templates.containsKey(s)) {
            return this.templates.get(s);
        }
        Template template = new Template();
        this.templates.put(s, template);
        return template;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean func_186235_b(MinecraftServer server, ResourceLocation id) {
        String s = id.getResourcePath();
        File file1 = server.getFile(this.field_186241_b);
        File file2 = new File(file1, String.valueOf(s) + ".nbt");
        if (!file2.exists()) {
            return this.func_186236_a(id);
        }
        FileInputStream inputstream = null;
        try {
            inputstream = new FileInputStream(file2);
            this.func_186239_a(s, inputstream);
        }
        catch (Throwable var12) {
            boolean flag;
            try {
                flag = false;
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(inputstream);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)inputstream);
            return flag;
        }
        IOUtils.closeQuietly((InputStream)inputstream);
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean func_186236_a(ResourceLocation id) {
        String s = id.getResourceDomain();
        String s1 = id.getResourcePath();
        InputStream inputstream = null;
        try {
            inputstream = MinecraftServer.class.getResourceAsStream("/assets/" + s + "/structures/" + s1 + ".nbt");
            this.func_186239_a(s1, inputstream);
        }
        catch (Throwable var10) {
            try {
                boolean flag = false;
                return flag;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                IOUtils.closeQuietly(inputstream);
            }
        }
        IOUtils.closeQuietly((InputStream)inputstream);
        return true;
    }

    private void func_186239_a(String p_186239_1_, InputStream p_186239_2_) throws IOException {
        NBTTagCompound nbttagcompound = CompressedStreamTools.readCompressed(p_186239_2_);
        Template template = new Template();
        template.read(nbttagcompound);
        this.templates.put(p_186239_1_, template);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean func_186238_c(MinecraftServer server, ResourceLocation id) {
        String s = id.getResourcePath();
        if (!this.templates.containsKey(s)) {
            return false;
        }
        File file1 = server.getFile(this.field_186241_b);
        if (!file1.exists() ? !file1.mkdirs() : !file1.isDirectory()) {
            return false;
        }
        File file2 = new File(file1, String.valueOf(s) + ".nbt");
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        Template template = this.templates.get(s);
        FileOutputStream outputstream = null;
        try {
            template.write(nbttagcompound);
            outputstream = new FileOutputStream(file2);
            CompressedStreamTools.writeCompressed(nbttagcompound, outputstream);
        }
        catch (Throwable var14) {
            try {
                boolean flag = false;
                return flag;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                IOUtils.closeQuietly(outputstream);
            }
        }
        IOUtils.closeQuietly((OutputStream)outputstream);
        return true;
    }
}

