/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDirectional;
import net.minecraft.block.BlockPistonExtension;
import net.minecraft.block.BlockPistonMoving;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockPistonStructureHelper;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityPiston;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockPistonBase
extends BlockDirectional {
    public static final PropertyBool EXTENDED = PropertyBool.create("extended");
    protected static final AxisAlignedBB field_185648_b = new AxisAlignedBB(0.0, 0.0, 0.0, 0.75, 1.0, 1.0);
    protected static final AxisAlignedBB field_185649_c = new AxisAlignedBB(0.25, 0.0, 0.0, 1.0, 1.0, 1.0);
    protected static final AxisAlignedBB field_185650_d = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 0.75);
    protected static final AxisAlignedBB field_185651_e = new AxisAlignedBB(0.0, 0.0, 0.25, 1.0, 1.0, 1.0);
    protected static final AxisAlignedBB field_185652_f = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.75, 1.0);
    protected static final AxisAlignedBB field_185653_g = new AxisAlignedBB(0.0, 0.25, 0.0, 1.0, 1.0, 1.0);
    private final boolean isSticky;

    public BlockPistonBase(boolean isSticky) {
        super(Material.piston);
        this.setDefaultState(this.blockState.getBaseState().withProperty(FACING, (Comparable<?>)((Object)EnumFacing.NORTH)).withProperty(EXTENDED, Boolean.valueOf(false)));
        this.isSticky = isSticky;
        this.setStepSound(SoundType.STONE);
        this.setHardness(0.5f);
        this.setCreativeTab(CreativeTabs.tabRedstone);
    }

    @Override
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        if (state.getValue(EXTENDED).booleanValue()) {
            switch (state.getValue(FACING)) {
                case DOWN: {
                    return field_185653_g;
                }
                default: {
                    return field_185652_f;
                }
                case NORTH: {
                    return field_185651_e;
                }
                case SOUTH: {
                    return field_185650_d;
                }
                case WEST: {
                    return field_185649_c;
                }
                case EAST: 
            }
            return field_185648_b;
        }
        return FULL_BLOCK_AABB;
    }

    @Override
    public boolean isFullyOpaque(IBlockState state) {
        return state.getValue(EXTENDED) == false || state.getValue(FACING) == EnumFacing.DOWN;
    }

    @Override
    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB p_185477_4_, List<AxisAlignedBB> p_185477_5_, Entity p_185477_6_) {
        BlockPistonBase.func_185492_a(pos, p_185477_4_, p_185477_5_, state.func_185900_c(worldIn, pos));
    }

    @Override
    public boolean isOpaqueCube(IBlockState p_149662_1_) {
        return false;
    }

    @Override
    public void onBlockPlacedBy(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        worldIn.setBlockState(pos, state.withProperty(FACING, (Comparable<?>)((Object)BlockPistonBase.func_185647_a(pos, placer))), 2);
        if (!worldIn.isRemote) {
            this.checkForMove(worldIn, pos, state);
        }
    }

    @Override
    public void onNeighborBlockChange(World worldIn, BlockPos pos, IBlockState state, Block neighborBlock) {
        if (!worldIn.isRemote) {
            this.checkForMove(worldIn, pos, state);
        }
    }

    @Override
    public void onBlockAdded(World worldIn, BlockPos pos, IBlockState state) {
        if (!worldIn.isRemote && worldIn.getTileEntity(pos) == null) {
            this.checkForMove(worldIn, pos, state);
        }
    }

    @Override
    public IBlockState onBlockPlaced(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.getDefaultState().withProperty(FACING, (Comparable<?>)((Object)BlockPistonBase.func_185647_a(pos, placer))).withProperty(EXTENDED, Boolean.valueOf(false));
    }

    private void checkForMove(World worldIn, BlockPos pos, IBlockState state) {
        EnumFacing enumfacing = state.getValue(FACING);
        boolean flag = this.shouldBeExtended(worldIn, pos, enumfacing);
        if (flag && !state.getValue(EXTENDED).booleanValue()) {
            if (new BlockPistonStructureHelper(worldIn, pos, enumfacing, true).canMove()) {
                worldIn.addBlockEvent(pos, this, 0, enumfacing.getIndex());
            }
        } else if (!flag && state.getValue(EXTENDED).booleanValue()) {
            worldIn.addBlockEvent(pos, this, 1, enumfacing.getIndex());
        }
    }

    private boolean shouldBeExtended(World worldIn, BlockPos pos, EnumFacing facing) {
        EnumFacing[] enumFacingArray = EnumFacing.values();
        int n = enumFacingArray.length;
        int n2 = 0;
        while (n2 < n) {
            EnumFacing enumfacing = enumFacingArray[n2];
            if (enumfacing != facing && worldIn.isSidePowered(pos.offset(enumfacing), enumfacing)) {
                return true;
            }
            ++n2;
        }
        if (worldIn.isSidePowered(pos, EnumFacing.DOWN)) {
            return true;
        }
        BlockPos blockpos = pos.up();
        EnumFacing[] enumFacingArray2 = EnumFacing.values();
        int n3 = enumFacingArray2.length;
        n = 0;
        while (n < n3) {
            EnumFacing enumfacing1 = enumFacingArray2[n];
            if (enumfacing1 != EnumFacing.DOWN && worldIn.isSidePowered(blockpos.offset(enumfacing1), enumfacing1)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    @Override
    public boolean onBlockEventReceived(World worldIn, BlockPos pos, IBlockState state, int eventID, int eventParam) {
        EnumFacing enumfacing = state.getValue(FACING);
        if (!worldIn.isRemote) {
            boolean flag = this.shouldBeExtended(worldIn, pos, enumfacing);
            if (flag && eventID == 1) {
                worldIn.setBlockState(pos, state.withProperty(EXTENDED, Boolean.valueOf(true)), 2);
                return false;
            }
            if (!flag && eventID == 0) {
                return false;
            }
        }
        if (eventID == 0) {
            if (!this.doMove(worldIn, pos, enumfacing, true)) {
                return false;
            }
            worldIn.setBlockState(pos, state.withProperty(EXTENDED, Boolean.valueOf(true)), 2);
            worldIn.func_184133_a(null, pos, SoundEvents.block_piston_extend, SoundCategory.BLOCKS, 0.5f, worldIn.rand.nextFloat() * 0.25f + 0.6f);
        } else if (eventID == 1) {
            TileEntity tileentity1 = worldIn.getTileEntity(pos.offset(enumfacing));
            if (tileentity1 instanceof TileEntityPiston) {
                ((TileEntityPiston)tileentity1).clearPistonTileEntity();
            }
            worldIn.setBlockState(pos, Blocks.piston_extension.getDefaultState().withProperty(BlockPistonMoving.FACING, (Comparable<?>)((Object)enumfacing)).withProperty(BlockPistonMoving.TYPE, (Comparable<?>)((Object)(this.isSticky ? BlockPistonExtension.EnumPistonType.STICKY : BlockPistonExtension.EnumPistonType.DEFAULT))), 3);
            worldIn.setTileEntity(pos, BlockPistonMoving.func_185588_a(this.getStateFromMeta(eventParam), enumfacing, false, true));
            if (this.isSticky) {
                TileEntityPiston tileentitypiston;
                TileEntity tileentity;
                BlockPos blockpos = pos.add(enumfacing.getFrontOffsetX() * 2, enumfacing.getFrontOffsetY() * 2, enumfacing.getFrontOffsetZ() * 2);
                IBlockState iblockstate = worldIn.getBlockState(blockpos);
                Block block = iblockstate.getBlock();
                boolean flag1 = false;
                if (block == Blocks.piston_extension && (tileentity = worldIn.getTileEntity(blockpos)) instanceof TileEntityPiston && (tileentitypiston = (TileEntityPiston)tileentity).getFacing() == enumfacing && tileentitypiston.isExtending()) {
                    tileentitypiston.clearPistonTileEntity();
                    flag1 = true;
                }
                if (!flag1 && iblockstate.getMaterial() != Material.air && BlockPistonBase.func_185646_a(iblockstate, worldIn, blockpos, enumfacing.getOpposite(), false) && (iblockstate.getMobilityFlag() == EnumPushReaction.NORMAL || block == Blocks.piston || block == Blocks.sticky_piston)) {
                    this.doMove(worldIn, pos, enumfacing, false);
                }
            } else {
                worldIn.setBlockToAir(pos.offset(enumfacing));
            }
            worldIn.func_184133_a(null, pos, SoundEvents.block_piston_contract, SoundCategory.BLOCKS, 0.5f, worldIn.rand.nextFloat() * 0.15f + 0.6f);
        }
        return true;
    }

    @Override
    public boolean isFullCube(IBlockState state) {
        return false;
    }

    public static EnumFacing getFacing(int meta) {
        int i = meta & 7;
        return i > 5 ? null : EnumFacing.getFront(i);
    }

    public static EnumFacing func_185647_a(BlockPos p_185647_0_, EntityLivingBase p_185647_1_) {
        if (MathHelper.abs((float)p_185647_1_.posX - (float)p_185647_0_.getX()) < 2.0f && MathHelper.abs((float)p_185647_1_.posZ - (float)p_185647_0_.getZ()) < 2.0f) {
            double d0 = p_185647_1_.posY + (double)p_185647_1_.getEyeHeight();
            if (d0 - (double)p_185647_0_.getY() > 2.0) {
                return EnumFacing.UP;
            }
            if ((double)p_185647_0_.getY() - d0 > 0.0) {
                return EnumFacing.DOWN;
            }
        }
        return p_185647_1_.getHorizontalFacing().getOpposite();
    }

    public static boolean func_185646_a(IBlockState p_185646_0_, World p_185646_1_, BlockPos p_185646_2_, EnumFacing p_185646_3_, boolean p_185646_4_) {
        Block block = p_185646_0_.getBlock();
        if (block == Blocks.obsidian) {
            return false;
        }
        if (!p_185646_1_.getWorldBorder().contains(p_185646_2_)) {
            return false;
        }
        if (p_185646_2_.getY() >= 0 && (p_185646_3_ != EnumFacing.DOWN || p_185646_2_.getY() != 0)) {
            if (p_185646_2_.getY() <= p_185646_1_.getHeight() - 1 && (p_185646_3_ != EnumFacing.UP || p_185646_2_.getY() != p_185646_1_.getHeight() - 1)) {
                if (block != Blocks.piston && block != Blocks.sticky_piston) {
                    if (p_185646_0_.getBlockHardness(p_185646_1_, p_185646_2_) == -1.0f) {
                        return false;
                    }
                    if (p_185646_0_.getMobilityFlag() == EnumPushReaction.BLOCK) {
                        return false;
                    }
                    if (p_185646_0_.getMobilityFlag() == EnumPushReaction.DESTROY) {
                        return p_185646_4_;
                    }
                } else if (p_185646_0_.getValue(EXTENDED).booleanValue()) {
                    return false;
                }
                return !block.hasTileEntity();
            }
            return false;
        }
        return false;
    }

    private boolean doMove(World worldIn, BlockPos pos, EnumFacing direction, boolean extending) {
        BlockPistonStructureHelper blockpistonstructurehelper;
        if (!extending) {
            worldIn.setBlockToAir(pos.offset(direction));
        }
        if (!(blockpistonstructurehelper = new BlockPistonStructureHelper(worldIn, pos, direction, extending)).canMove()) {
            return false;
        }
        List<BlockPos> list = blockpistonstructurehelper.getBlocksToMove();
        ArrayList list1 = Lists.newArrayList();
        int i = 0;
        while (i < list.size()) {
            BlockPos blockpos = list.get(i);
            list1.add(worldIn.getBlockState(blockpos).getActualState(worldIn, blockpos));
            ++i;
        }
        List<BlockPos> list2 = blockpistonstructurehelper.getBlocksToDestroy();
        int k = list.size() + list2.size();
        IBlockState[] aiblockstate = new IBlockState[k];
        EnumFacing enumfacing = extending ? direction : direction.getOpposite();
        int j = list2.size() - 1;
        while (j >= 0) {
            BlockPos blockpos1 = list2.get(j);
            IBlockState iblockstate = worldIn.getBlockState(blockpos1);
            iblockstate.getBlock().dropBlockAsItem(worldIn, blockpos1, iblockstate, 0);
            worldIn.setBlockToAir(blockpos1);
            aiblockstate[--k] = iblockstate;
            --j;
        }
        int l = list.size() - 1;
        while (l >= 0) {
            BlockPos blockpos3 = list.get(l);
            IBlockState iblockstate2 = worldIn.getBlockState(blockpos3);
            worldIn.setBlockState(blockpos3, Blocks.air.getDefaultState(), 4);
            blockpos3 = blockpos3.offset(enumfacing);
            worldIn.setBlockState(blockpos3, Blocks.piston_extension.getDefaultState().withProperty(FACING, (Comparable<?>)((Object)direction)), 4);
            worldIn.setTileEntity(blockpos3, BlockPistonMoving.func_185588_a((IBlockState)list1.get(l), direction, extending, false));
            aiblockstate[--k] = iblockstate2;
            --l;
        }
        BlockPos blockpos2 = pos.offset(direction);
        if (extending) {
            BlockPistonExtension.EnumPistonType blockpistonextension$enumpistontype = this.isSticky ? BlockPistonExtension.EnumPistonType.STICKY : BlockPistonExtension.EnumPistonType.DEFAULT;
            IBlockState iblockstate3 = Blocks.piston_head.getDefaultState().withProperty(BlockPistonExtension.FACING, (Comparable<?>)((Object)direction)).withProperty(BlockPistonExtension.TYPE, (Comparable<?>)((Object)blockpistonextension$enumpistontype));
            IBlockState iblockstate1 = Blocks.piston_extension.getDefaultState().withProperty(BlockPistonMoving.FACING, (Comparable<?>)((Object)direction)).withProperty(BlockPistonMoving.TYPE, (Comparable<?>)((Object)(this.isSticky ? BlockPistonExtension.EnumPistonType.STICKY : BlockPistonExtension.EnumPistonType.DEFAULT)));
            worldIn.setBlockState(blockpos2, iblockstate1, 4);
            worldIn.setTileEntity(blockpos2, BlockPistonMoving.func_185588_a(iblockstate3, direction, true, false));
        }
        int i1 = list2.size() - 1;
        while (i1 >= 0) {
            worldIn.notifyNeighborsOfStateChange(list2.get(i1), aiblockstate[k++].getBlock());
            --i1;
        }
        int j1 = list.size() - 1;
        while (j1 >= 0) {
            worldIn.notifyNeighborsOfStateChange(list.get(j1), aiblockstate[k++].getBlock());
            --j1;
        }
        if (extending) {
            worldIn.notifyNeighborsOfStateChange(blockpos2, Blocks.piston_head);
            worldIn.notifyNeighborsOfStateChange(pos, this);
        }
        return true;
    }

    @Override
    public IBlockState getStateFromMeta(int meta) {
        return this.getDefaultState().withProperty(FACING, (Comparable<?>)((Object)BlockPistonBase.getFacing(meta))).withProperty(EXTENDED, Boolean.valueOf((meta & 8) > 0));
    }

    @Override
    public int getMetaFromState(IBlockState state) {
        int i = 0;
        i |= state.getValue(FACING).getIndex();
        if (state.getValue(EXTENDED).booleanValue()) {
            i |= 8;
        }
        return i;
    }

    @Override
    public IBlockState withRotation(IBlockState state, Rotation rot) {
        return state.withProperty(FACING, (Comparable<?>)((Object)rot.func_185831_a(state.getValue(FACING))));
    }

    @Override
    public IBlockState withMirror(IBlockState state, Mirror mirrorIn) {
        return state.withRotation(mirrorIn.func_185800_a(state.getValue(FACING)));
    }

    @Override
    protected BlockStateContainer createBlockState() {
        return new BlockStateContainer(this, FACING, EXTENDED);
    }
}

