/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public abstract class BlockSlab
extends Block {
    public static final PropertyEnum<EnumBlockHalf> HALF = PropertyEnum.create("half", EnumBlockHalf.class);
    protected static final AxisAlignedBB field_185676_b = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0);
    protected static final AxisAlignedBB field_185677_c = new AxisAlignedBB(0.0, 0.5, 0.0, 1.0, 1.0, 1.0);

    public BlockSlab(Material materialIn) {
        super(materialIn);
        this.fullBlock = this.isDouble();
        this.setLightOpacity(255);
    }

    @Override
    protected boolean canSilkHarvest() {
        return false;
    }

    @Override
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return this.isDouble() ? FULL_BLOCK_AABB : (state.getValue(HALF) == EnumBlockHalf.TOP ? field_185677_c : field_185676_b);
    }

    @Override
    public boolean isFullyOpaque(IBlockState state) {
        return ((BlockSlab)state.getBlock()).isDouble() || state.getValue(HALF) == EnumBlockHalf.TOP;
    }

    @Override
    public boolean isOpaqueCube(IBlockState p_149662_1_) {
        return this.isDouble();
    }

    @Override
    public IBlockState onBlockPlaced(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        IBlockState iblockstate = super.onBlockPlaced(worldIn, pos, facing, hitX, hitY, hitZ, meta, placer).withProperty(HALF, (Comparable<?>)((Object)EnumBlockHalf.BOTTOM));
        return this.isDouble() ? iblockstate : (facing != EnumFacing.DOWN && (facing == EnumFacing.UP || (double)hitY <= 0.5) ? iblockstate : iblockstate.withProperty(HALF, (Comparable<?>)((Object)EnumBlockHalf.TOP)));
    }

    @Override
    public int quantityDropped(Random random) {
        return this.isDouble() ? 2 : 1;
    }

    @Override
    public boolean isFullCube(IBlockState state) {
        return this.isDouble();
    }

    @Override
    public boolean shouldSideBeRendered(IBlockState worldIn, IBlockAccess pos, BlockPos side, EnumFacing facing) {
        boolean flag1;
        if (this.isDouble()) {
            return super.shouldSideBeRendered(worldIn, pos, side, facing);
        }
        if (facing != EnumFacing.UP && facing != EnumFacing.DOWN && !super.shouldSideBeRendered(worldIn, pos, side, facing)) {
            return false;
        }
        IBlockState iblockstate = pos.getBlockState(side.offset(facing));
        boolean flag = BlockSlab.func_185675_i(iblockstate) && iblockstate.getValue(HALF) == EnumBlockHalf.TOP;
        boolean bl = flag1 = BlockSlab.func_185675_i(worldIn) && worldIn.getValue(HALF) == EnumBlockHalf.TOP;
        return flag1 ? (facing == EnumFacing.DOWN ? true : (facing == EnumFacing.UP && super.shouldSideBeRendered(worldIn, pos, side, facing) ? true : !BlockSlab.func_185675_i(iblockstate) || !flag)) : (facing == EnumFacing.UP ? true : (facing == EnumFacing.DOWN && super.shouldSideBeRendered(worldIn, pos, side, facing) ? true : !BlockSlab.func_185675_i(iblockstate) || flag));
    }

    protected static boolean func_185675_i(IBlockState p_185675_0_) {
        Block block = p_185675_0_.getBlock();
        return block == Blocks.stone_slab || block == Blocks.wooden_slab || block == Blocks.stone_slab2 || block == Blocks.purpur_slab;
    }

    public abstract String getUnlocalizedName(int var1);

    public abstract boolean isDouble();

    public abstract IProperty<?> getVariantProperty();

    public abstract Comparable<?> func_185674_a(ItemStack var1);

    public static enum EnumBlockHalf implements IStringSerializable
    {
        TOP("top"),
        BOTTOM("bottom");

        private final String name;

        private EnumBlockHalf(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        @Override
        public String getName() {
            return this.name;
        }
    }
}

