/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockTrapDoor
extends Block {
    public static final PropertyDirection FACING = BlockHorizontal.FACING;
    public static final PropertyBool OPEN = PropertyBool.create("open");
    public static final PropertyEnum<DoorHalf> HALF = PropertyEnum.create("half", DoorHalf.class);
    protected static final AxisAlignedBB field_185734_d = new AxisAlignedBB(0.0, 0.0, 0.0, 0.1875, 1.0, 1.0);
    protected static final AxisAlignedBB field_185735_e = new AxisAlignedBB(0.8125, 0.0, 0.0, 1.0, 1.0, 1.0);
    protected static final AxisAlignedBB field_185736_f = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 0.1875);
    protected static final AxisAlignedBB field_185737_g = new AxisAlignedBB(0.0, 0.0, 0.8125, 1.0, 1.0, 1.0);
    protected static final AxisAlignedBB field_185732_B = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.1875, 1.0);
    protected static final AxisAlignedBB field_185733_C = new AxisAlignedBB(0.0, 0.8125, 0.0, 1.0, 1.0, 1.0);

    protected BlockTrapDoor(Material materialIn) {
        super(materialIn);
        this.setDefaultState(this.blockState.getBaseState().withProperty(FACING, (Comparable<?>)((Object)EnumFacing.NORTH)).withProperty(OPEN, Boolean.valueOf(false)).withProperty(HALF, (Comparable<?>)((Object)DoorHalf.BOTTOM)));
        float f = 0.5f;
        float f1 = 1.0f;
        this.setCreativeTab(CreativeTabs.tabRedstone);
    }

    @Override
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        AxisAlignedBB axisalignedbb;
        if (state.getValue(OPEN).booleanValue()) {
            switch (state.getValue(FACING)) {
                default: {
                    axisalignedbb = field_185737_g;
                    break;
                }
                case SOUTH: {
                    axisalignedbb = field_185736_f;
                    break;
                }
                case WEST: {
                    axisalignedbb = field_185735_e;
                    break;
                }
                case EAST: {
                    axisalignedbb = field_185734_d;
                    break;
                }
            }
        } else {
            axisalignedbb = state.getValue(HALF) == DoorHalf.TOP ? field_185733_C : field_185732_B;
        }
        return axisalignedbb;
    }

    @Override
    public boolean isOpaqueCube(IBlockState p_149662_1_) {
        return false;
    }

    @Override
    public boolean isFullCube(IBlockState state) {
        return false;
    }

    @Override
    public boolean isPassable(IBlockAccess worldIn, BlockPos pos) {
        return worldIn.getBlockState(pos).getValue(OPEN) == false;
    }

    @Override
    public boolean onBlockActivated(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand side, ItemStack hitX, EnumFacing hitY, float hitZ, float p_180639_9_, float p_180639_10_) {
        if (this.blockMaterial == Material.iron) {
            return true;
        }
        state = state.cycleProperty(OPEN);
        worldIn.setBlockState(pos, state, 2);
        this.func_185731_a(playerIn, worldIn, pos, state.getValue(OPEN));
        return true;
    }

    protected void func_185731_a(EntityPlayer p_185731_1_, World p_185731_2_, BlockPos p_185731_3_, boolean p_185731_4_) {
        if (p_185731_4_) {
            int i = this.blockMaterial == Material.iron ? 1037 : 1007;
            p_185731_2_.playAuxSFXAtEntity(p_185731_1_, i, p_185731_3_, 0);
        } else {
            int j = this.blockMaterial == Material.iron ? 1036 : 1013;
            p_185731_2_.playAuxSFXAtEntity(p_185731_1_, j, p_185731_3_, 0);
        }
    }

    @Override
    public void onNeighborBlockChange(World worldIn, BlockPos pos, IBlockState state, Block neighborBlock) {
        boolean flag1;
        boolean flag;
        if (!worldIn.isRemote && ((flag = worldIn.isBlockPowered(pos)) || neighborBlock.getDefaultState().canProvidePower()) && (flag1 = state.getValue(OPEN).booleanValue()) != flag) {
            worldIn.setBlockState(pos, state.withProperty(OPEN, Boolean.valueOf(flag)), 2);
            this.func_185731_a(null, worldIn, pos, flag);
        }
    }

    @Override
    public IBlockState onBlockPlaced(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        IBlockState iblockstate = this.getDefaultState();
        if (facing.getAxis().isHorizontal()) {
            iblockstate = iblockstate.withProperty(FACING, (Comparable<?>)((Object)facing)).withProperty(OPEN, Boolean.valueOf(false));
            iblockstate = iblockstate.withProperty(HALF, (Comparable<?>)((Object)(hitY > 0.5f ? DoorHalf.TOP : DoorHalf.BOTTOM)));
        } else {
            iblockstate = iblockstate.withProperty(FACING, (Comparable<?>)((Object)placer.getHorizontalFacing().getOpposite())).withProperty(OPEN, Boolean.valueOf(false));
            iblockstate = iblockstate.withProperty(HALF, (Comparable<?>)((Object)(facing == EnumFacing.UP ? DoorHalf.BOTTOM : DoorHalf.TOP)));
        }
        return iblockstate;
    }

    @Override
    public boolean canPlaceBlockOnSide(World worldIn, BlockPos pos, EnumFacing side) {
        return true;
    }

    protected static EnumFacing getFacing(int meta) {
        switch (meta & 3) {
            case 0: {
                return EnumFacing.NORTH;
            }
            case 1: {
                return EnumFacing.SOUTH;
            }
            case 2: {
                return EnumFacing.WEST;
            }
        }
        return EnumFacing.EAST;
    }

    protected static int getMetaForFacing(EnumFacing facing) {
        switch (facing) {
            case NORTH: {
                return 0;
            }
            case SOUTH: {
                return 1;
            }
            case WEST: {
                return 2;
            }
        }
        return 3;
    }

    @Override
    public BlockRenderLayer getBlockLayer() {
        return BlockRenderLayer.CUTOUT;
    }

    @Override
    public IBlockState getStateFromMeta(int meta) {
        return this.getDefaultState().withProperty(FACING, (Comparable<?>)((Object)BlockTrapDoor.getFacing(meta))).withProperty(OPEN, Boolean.valueOf((meta & 4) != 0)).withProperty(HALF, (Comparable<?>)((Object)((meta & 8) == 0 ? DoorHalf.BOTTOM : DoorHalf.TOP)));
    }

    @Override
    public int getMetaFromState(IBlockState state) {
        int i = 0;
        i |= BlockTrapDoor.getMetaForFacing(state.getValue(FACING));
        if (state.getValue(OPEN).booleanValue()) {
            i |= 4;
        }
        if (state.getValue(HALF) == DoorHalf.TOP) {
            i |= 8;
        }
        return i;
    }

    @Override
    public IBlockState withRotation(IBlockState state, Rotation rot) {
        return state.withProperty(FACING, (Comparable<?>)((Object)rot.func_185831_a(state.getValue(FACING))));
    }

    @Override
    public IBlockState withMirror(IBlockState state, Mirror mirrorIn) {
        return state.withRotation(mirrorIn.func_185800_a(state.getValue(FACING)));
    }

    @Override
    protected BlockStateContainer createBlockState() {
        return new BlockStateContainer(this, FACING, OPEN, HALF);
    }

    public static enum DoorHalf implements IStringSerializable
    {
        TOP("top"),
        BOTTOM("bottom");

        private final String name;

        private DoorHalf(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        @Override
        public String getName() {
            return this.name;
        }
    }
}

