/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui;

import com.google.common.collect.Lists;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;
import java.util.Random;
import net.minecraft.client.audio.MusicTicker;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.IResource;
import net.minecraft.network.play.client.CPacketClientStatus;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import org.apache.commons.io.Charsets;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GuiWinGame
extends GuiScreen {
    private static final Logger logger = LogManager.getLogger();
    private static final ResourceLocation MINECRAFT_LOGO = new ResourceLocation("textures/gui/title/minecraft.png");
    private static final ResourceLocation VIGNETTE_TEXTURE = new ResourceLocation("textures/misc/vignette.png");
    private int field_146581_h;
    private List<String> field_146582_i;
    private int field_146579_r;
    private float field_146578_s = 0.5f;

    @Override
    public void updateScreen() {
        MusicTicker musicticker = this.mc.getMusicTicker();
        SoundHandler soundhandler = this.mc.getSoundHandler();
        if (this.field_146581_h == 0) {
            musicticker.func_181557_a();
            musicticker.func_181558_a(MusicTicker.MusicType.CREDITS);
            soundhandler.resumeSounds();
        }
        soundhandler.update();
        ++this.field_146581_h;
        float f = (float)(this.field_146579_r + this.height + this.height + 24) / this.field_146578_s;
        if ((float)this.field_146581_h > f) {
            this.sendRespawnPacket();
        }
    }

    @Override
    protected void keyTyped(char typedChar, int keyCode) throws IOException {
        if (keyCode == 1) {
            this.sendRespawnPacket();
        }
    }

    private void sendRespawnPacket() {
        this.mc.thePlayer.sendQueue.addToSendQueue(new CPacketClientStatus(CPacketClientStatus.State.PERFORM_RESPAWN));
        this.mc.displayGuiScreen(null);
    }

    @Override
    public boolean doesGuiPauseGame() {
        return true;
    }

    @Override
    public void initGui() {
        block10: {
            if (this.field_146582_i == null) {
                this.field_146582_i = Lists.newArrayList();
                IResource iresource = null;
                try {
                    try {
                        String s = "";
                        String s1 = "" + (Object)((Object)TextFormatting.WHITE) + (Object)((Object)TextFormatting.OBFUSCATED) + (Object)((Object)TextFormatting.GREEN) + (Object)((Object)TextFormatting.AQUA);
                        int i = 274;
                        iresource = this.mc.getResourceManager().getResource(new ResourceLocation("texts/end.txt"));
                        InputStream inputstream = iresource.getInputStream();
                        BufferedReader bufferedreader = new BufferedReader(new InputStreamReader(inputstream, Charsets.UTF_8));
                        Random random = new Random(8124371L);
                        while ((s = bufferedreader.readLine()) != null) {
                            s = s.replaceAll("PLAYERNAME", this.mc.getSession().getUsername());
                            while (s.contains(s1)) {
                                int j = s.indexOf(s1);
                                String s2 = s.substring(0, j);
                                String s3 = s.substring(j + s1.length());
                                s = String.valueOf(s2) + (Object)((Object)TextFormatting.WHITE) + (Object)((Object)TextFormatting.OBFUSCATED) + "XXXXXXXX".substring(0, random.nextInt(4) + 3) + s3;
                            }
                            this.field_146582_i.addAll(this.mc.fontRendererObj.listFormattedStringToWidth(s, i));
                            this.field_146582_i.add("");
                        }
                        inputstream.close();
                        int k = 0;
                        while (k < 8) {
                            this.field_146582_i.add("");
                            ++k;
                        }
                        inputstream = this.mc.getResourceManager().getResource(new ResourceLocation("texts/credits.txt")).getInputStream();
                        bufferedreader = new BufferedReader(new InputStreamReader(inputstream, Charsets.UTF_8));
                        while ((s = bufferedreader.readLine()) != null) {
                            s = s.replaceAll("PLAYERNAME", this.mc.getSession().getUsername());
                            s = s.replaceAll("\t", "    ");
                            this.field_146582_i.addAll(this.mc.fontRendererObj.listFormattedStringToWidth(s, i));
                            this.field_146582_i.add("");
                        }
                        inputstream.close();
                        this.field_146579_r = this.field_146582_i.size() * 12;
                    }
                    catch (Exception exception) {
                        logger.error("Couldn't load credits", (Throwable)exception);
                        IOUtils.closeQuietly(iresource);
                        break block10;
                    }
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(iresource);
                    throw throwable;
                }
                IOUtils.closeQuietly((Closeable)iresource);
            }
        }
    }

    private void drawWinGameScreen(int p_146575_1_, int p_146575_2_, float p_146575_3_) {
        Tessellator tessellator = Tessellator.getInstance();
        VertexBuffer vertexbuffer = tessellator.getBuffer();
        this.mc.getTextureManager().bindTexture(Gui.optionsBackground);
        vertexbuffer.begin(7, DefaultVertexFormats.POSITION_TEX_COLOR);
        int i = this.width;
        float f = 0.0f - ((float)this.field_146581_h + p_146575_3_) * 0.5f * this.field_146578_s;
        float f1 = (float)this.height - ((float)this.field_146581_h + p_146575_3_) * 0.5f * this.field_146578_s;
        float f2 = 0.015625f;
        float f3 = ((float)this.field_146581_h + p_146575_3_ - 0.0f) * 0.02f;
        float f4 = (float)(this.field_146579_r + this.height + this.height + 24) / this.field_146578_s;
        float f5 = (f4 - 20.0f - ((float)this.field_146581_h + p_146575_3_)) * 0.005f;
        if (f5 < f3) {
            f3 = f5;
        }
        if (f3 > 1.0f) {
            f3 = 1.0f;
        }
        f3 *= f3;
        f3 = f3 * 96.0f / 255.0f;
        vertexbuffer.pos(0.0, this.height, this.zLevel).tex(0.0, f * f2).color(f3, f3, f3, 1.0f).endVertex();
        vertexbuffer.pos(i, this.height, this.zLevel).tex((float)i * f2, f * f2).color(f3, f3, f3, 1.0f).endVertex();
        vertexbuffer.pos(i, 0.0, this.zLevel).tex((float)i * f2, f1 * f2).color(f3, f3, f3, 1.0f).endVertex();
        vertexbuffer.pos(0.0, 0.0, this.zLevel).tex(0.0, f1 * f2).color(f3, f3, f3, 1.0f).endVertex();
        tessellator.draw();
    }

    @Override
    public void drawScreen(int mouseX, int mouseY, float partialTicks) {
        this.drawWinGameScreen(mouseX, mouseY, partialTicks);
        Tessellator tessellator = Tessellator.getInstance();
        VertexBuffer vertexbuffer = tessellator.getBuffer();
        int i = 274;
        int j = this.width / 2 - i / 2;
        int k = this.height + 50;
        float f = -((float)this.field_146581_h + partialTicks) * this.field_146578_s;
        GlStateManager.pushMatrix();
        GlStateManager.translate(0.0f, f, 0.0f);
        this.mc.getTextureManager().bindTexture(MINECRAFT_LOGO);
        GlStateManager.color(1.0f, 1.0f, 1.0f, 1.0f);
        this.drawTexturedModalRect(j, k, 0, 0, 155, 44);
        this.drawTexturedModalRect(j + 155, k, 0, 45, 155, 44);
        int l = k + 200;
        int i1 = 0;
        while (i1 < this.field_146582_i.size()) {
            float f1;
            if (i1 == this.field_146582_i.size() - 1 && (f1 = (float)l + f - (float)(this.height / 2 - 6)) < 0.0f) {
                GlStateManager.translate(0.0f, -f1, 0.0f);
            }
            if ((float)l + f + 12.0f + 8.0f > 0.0f && (float)l + f < (float)this.height) {
                String s = this.field_146582_i.get(i1);
                if (s.startsWith("[C]")) {
                    this.fontRendererObj.drawStringWithShadow(s.substring(3), j + (i - this.fontRendererObj.getStringWidth(s.substring(3))) / 2, l, 0xFFFFFF);
                } else {
                    this.fontRendererObj.fontRandom.setSeed((long)i1 * 4238972211L + (long)(this.field_146581_h / 4));
                    this.fontRendererObj.drawStringWithShadow(s, j, l, 0xFFFFFF);
                }
            }
            l += 12;
            ++i1;
        }
        GlStateManager.popMatrix();
        this.mc.getTextureManager().bindTexture(VIGNETTE_TEXTURE);
        GlStateManager.enableBlend();
        GlStateManager.blendFunc(GlStateManager.SourceFactor.ZERO, GlStateManager.DestFactor.ONE_MINUS_SRC_COLOR);
        int j1 = this.width;
        int k1 = this.height;
        vertexbuffer.begin(7, DefaultVertexFormats.POSITION_TEX_COLOR);
        vertexbuffer.pos(0.0, k1, this.zLevel).tex(0.0, 1.0).color(1.0f, 1.0f, 1.0f, 1.0f).endVertex();
        vertexbuffer.pos(j1, k1, this.zLevel).tex(1.0, 1.0).color(1.0f, 1.0f, 1.0f, 1.0f).endVertex();
        vertexbuffer.pos(j1, 0.0, this.zLevel).tex(1.0, 0.0).color(1.0f, 1.0f, 1.0f, 1.0f).endVertex();
        vertexbuffer.pos(0.0, 0.0, this.zLevel).tex(0.0, 0.0).color(1.0f, 1.0f, 1.0f, 1.0f).endVertex();
        tessellator.draw();
        GlStateManager.disableBlend();
        super.drawScreen(mouseX, mouseY, partialTicks);
    }
}

