/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer;

import java.util.BitSet;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.EntityRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ReportedException;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;

public class BlockModelRenderer {
    private final BlockColors field_187499_a;

    public BlockModelRenderer(BlockColors p_i46575_1_) {
        this.field_187499_a = p_i46575_1_;
    }

    public boolean renderModel(IBlockAccess blockAccessIn, IBakedModel modelIn, IBlockState blockStateIn, BlockPos blockPosIn, VertexBuffer buffer, boolean checkSides) {
        return this.renderModel(blockAccessIn, modelIn, blockStateIn, blockPosIn, buffer, checkSides, MathHelper.getPositionRandom(blockPosIn));
    }

    public boolean renderModel(IBlockAccess worldIn, IBakedModel modelIn, IBlockState stateIn, BlockPos posIn, VertexBuffer buffer, boolean checkSides, long rand) {
        boolean flag = Minecraft.isAmbientOcclusionEnabled() && stateIn.getlightValue() == 0 && modelIn.isAmbientOcclusion();
        try {
            return flag ? this.renderModelSmooth(worldIn, modelIn, stateIn, posIn, buffer, checkSides, rand) : this.renderModelFlat(worldIn, modelIn, stateIn, posIn, buffer, checkSides, rand);
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.makeCrashReport(throwable, "Tesselating block model");
            CrashReportCategory crashreportcategory = crashreport.makeCategory("Block model being tesselated");
            CrashReportCategory.addBlockInfo(crashreportcategory, posIn, stateIn);
            crashreportcategory.addCrashSection("Using AO", flag);
            throw new ReportedException(crashreport);
        }
    }

    public boolean renderModelSmooth(IBlockAccess worldIn, IBakedModel modelIn, IBlockState stateIn, BlockPos posIn, VertexBuffer buffer, boolean checkSides, long rand) {
        boolean flag = false;
        float[] afloat = new float[EnumFacing.values().length * 2];
        BitSet bitset = new BitSet(3);
        AmbientOcclusionFace blockmodelrenderer$ambientocclusionface = new AmbientOcclusionFace();
        EnumFacing[] enumFacingArray = EnumFacing.values();
        int n = enumFacingArray.length;
        int n2 = 0;
        while (n2 < n) {
            EnumFacing enumfacing = enumFacingArray[n2];
            List<BakedQuad> list = modelIn.getQuads(stateIn, enumfacing, rand);
            if (!(list.isEmpty() || checkSides && !stateIn.shouldSideBeRendered(worldIn, posIn, enumfacing))) {
                this.renderQuadsSmooth(worldIn, stateIn, posIn, buffer, list, afloat, bitset, blockmodelrenderer$ambientocclusionface);
                flag = true;
            }
            ++n2;
        }
        List<BakedQuad> list1 = modelIn.getQuads(stateIn, null, rand);
        if (!list1.isEmpty()) {
            this.renderQuadsSmooth(worldIn, stateIn, posIn, buffer, list1, afloat, bitset, blockmodelrenderer$ambientocclusionface);
            flag = true;
        }
        return flag;
    }

    public boolean renderModelFlat(IBlockAccess worldIn, IBakedModel modelIn, IBlockState stateIn, BlockPos posIn, VertexBuffer buffer, boolean checkSides, long rand) {
        boolean flag = false;
        BitSet bitset = new BitSet(3);
        EnumFacing[] enumFacingArray = EnumFacing.values();
        int n = enumFacingArray.length;
        int n2 = 0;
        while (n2 < n) {
            EnumFacing enumfacing = enumFacingArray[n2];
            List<BakedQuad> list = modelIn.getQuads(stateIn, enumfacing, rand);
            if (!(list.isEmpty() || checkSides && !stateIn.shouldSideBeRendered(worldIn, posIn, enumfacing))) {
                int i = stateIn.getPackedLightmapCoords(worldIn, posIn.offset(enumfacing));
                this.renderQuadsFlat(worldIn, stateIn, posIn, i, false, buffer, list, bitset);
                flag = true;
            }
            ++n2;
        }
        List<BakedQuad> list1 = modelIn.getQuads(stateIn, null, rand);
        if (!list1.isEmpty()) {
            this.renderQuadsFlat(worldIn, stateIn, posIn, -1, true, buffer, list1, bitset);
            flag = true;
        }
        return flag;
    }

    private void renderQuadsSmooth(IBlockAccess p_187492_1_, IBlockState p_187492_2_, BlockPos p_187492_3_, VertexBuffer p_187492_4_, List<BakedQuad> p_187492_5_, float[] p_187492_6_, BitSet p_187492_7_, AmbientOcclusionFace p_187492_8_) {
        double d0 = p_187492_3_.getX();
        double d1 = p_187492_3_.getY();
        double d2 = p_187492_3_.getZ();
        Block block = p_187492_2_.getBlock();
        Block.EnumOffsetType block$enumoffsettype = block.getOffsetType();
        if (block$enumoffsettype != Block.EnumOffsetType.NONE) {
            long i = MathHelper.getPositionRandom(p_187492_3_);
            d0 += ((double)((float)(i >> 16 & 0xFL) / 15.0f) - 0.5) * 0.5;
            d2 += ((double)((float)(i >> 24 & 0xFL) / 15.0f) - 0.5) * 0.5;
            if (block$enumoffsettype == Block.EnumOffsetType.XYZ) {
                d1 += ((double)((float)(i >> 20 & 0xFL) / 15.0f) - 1.0) * 0.2;
            }
        }
        int l = 0;
        int j = p_187492_5_.size();
        while (l < j) {
            BakedQuad bakedquad = p_187492_5_.get(l);
            this.fillQuadBounds(p_187492_2_, bakedquad.getVertexData(), bakedquad.getFace(), p_187492_6_, p_187492_7_);
            p_187492_8_.updateVertexBrightness(p_187492_1_, p_187492_2_, p_187492_3_, bakedquad.getFace(), p_187492_6_, p_187492_7_);
            p_187492_4_.addVertexData(bakedquad.getVertexData());
            p_187492_4_.putBrightness4(p_187492_8_.vertexBrightness[0], p_187492_8_.vertexBrightness[1], p_187492_8_.vertexBrightness[2], p_187492_8_.vertexBrightness[3]);
            if (bakedquad.hasTintIndex()) {
                int k = this.field_187499_a.func_186724_a(p_187492_2_, p_187492_1_, p_187492_3_, bakedquad.getTintIndex());
                if (EntityRenderer.anaglyphEnable) {
                    k = TextureUtil.anaglyphColor(k);
                }
                float f = (float)(k >> 16 & 0xFF) / 255.0f;
                float f1 = (float)(k >> 8 & 0xFF) / 255.0f;
                float f2 = (float)(k & 0xFF) / 255.0f;
                p_187492_4_.putColorMultiplier(p_187492_8_.vertexColorMultiplier[0] * f, p_187492_8_.vertexColorMultiplier[0] * f1, p_187492_8_.vertexColorMultiplier[0] * f2, 4);
                p_187492_4_.putColorMultiplier(p_187492_8_.vertexColorMultiplier[1] * f, p_187492_8_.vertexColorMultiplier[1] * f1, p_187492_8_.vertexColorMultiplier[1] * f2, 3);
                p_187492_4_.putColorMultiplier(p_187492_8_.vertexColorMultiplier[2] * f, p_187492_8_.vertexColorMultiplier[2] * f1, p_187492_8_.vertexColorMultiplier[2] * f2, 2);
                p_187492_4_.putColorMultiplier(p_187492_8_.vertexColorMultiplier[3] * f, p_187492_8_.vertexColorMultiplier[3] * f1, p_187492_8_.vertexColorMultiplier[3] * f2, 1);
            } else {
                p_187492_4_.putColorMultiplier(p_187492_8_.vertexColorMultiplier[0], p_187492_8_.vertexColorMultiplier[0], p_187492_8_.vertexColorMultiplier[0], 4);
                p_187492_4_.putColorMultiplier(p_187492_8_.vertexColorMultiplier[1], p_187492_8_.vertexColorMultiplier[1], p_187492_8_.vertexColorMultiplier[1], 3);
                p_187492_4_.putColorMultiplier(p_187492_8_.vertexColorMultiplier[2], p_187492_8_.vertexColorMultiplier[2], p_187492_8_.vertexColorMultiplier[2], 2);
                p_187492_4_.putColorMultiplier(p_187492_8_.vertexColorMultiplier[3], p_187492_8_.vertexColorMultiplier[3], p_187492_8_.vertexColorMultiplier[3], 1);
            }
            p_187492_4_.putPosition(d0, d1, d2);
            ++l;
        }
    }

    private void fillQuadBounds(IBlockState p_187494_1_, int[] p_187494_2_, EnumFacing p_187494_3_, float[] p_187494_4_, BitSet p_187494_5_) {
        float f = 32.0f;
        float f1 = 32.0f;
        float f2 = 32.0f;
        float f3 = -32.0f;
        float f4 = -32.0f;
        float f5 = -32.0f;
        int i = 0;
        while (i < 4) {
            float f6 = Float.intBitsToFloat(p_187494_2_[i * 7]);
            float f7 = Float.intBitsToFloat(p_187494_2_[i * 7 + 1]);
            float f8 = Float.intBitsToFloat(p_187494_2_[i * 7 + 2]);
            f = Math.min(f, f6);
            f1 = Math.min(f1, f7);
            f2 = Math.min(f2, f8);
            f3 = Math.max(f3, f6);
            f4 = Math.max(f4, f7);
            f5 = Math.max(f5, f8);
            ++i;
        }
        if (p_187494_4_ != null) {
            p_187494_4_[EnumFacing.WEST.getIndex()] = f;
            p_187494_4_[EnumFacing.EAST.getIndex()] = f3;
            p_187494_4_[EnumFacing.DOWN.getIndex()] = f1;
            p_187494_4_[EnumFacing.UP.getIndex()] = f4;
            p_187494_4_[EnumFacing.NORTH.getIndex()] = f2;
            p_187494_4_[EnumFacing.SOUTH.getIndex()] = f5;
            p_187494_4_[EnumFacing.WEST.getIndex() + EnumFacing.values().length] = 1.0f - f;
            p_187494_4_[EnumFacing.EAST.getIndex() + EnumFacing.values().length] = 1.0f - f3;
            p_187494_4_[EnumFacing.DOWN.getIndex() + EnumFacing.values().length] = 1.0f - f1;
            p_187494_4_[EnumFacing.UP.getIndex() + EnumFacing.values().length] = 1.0f - f4;
            p_187494_4_[EnumFacing.NORTH.getIndex() + EnumFacing.values().length] = 1.0f - f2;
            p_187494_4_[EnumFacing.SOUTH.getIndex() + EnumFacing.values().length] = 1.0f - f5;
        }
        float f9 = 1.0E-4f;
        float f10 = 0.9999f;
        switch (p_187494_3_) {
            case DOWN: {
                p_187494_5_.set(1, f >= 1.0E-4f || f2 >= 1.0E-4f || f3 <= 0.9999f || f5 <= 0.9999f);
                p_187494_5_.set(0, (f1 < 1.0E-4f || p_187494_1_.isFullCube()) && f1 == f4);
                break;
            }
            case UP: {
                p_187494_5_.set(1, f >= 1.0E-4f || f2 >= 1.0E-4f || f3 <= 0.9999f || f5 <= 0.9999f);
                p_187494_5_.set(0, (f4 > 0.9999f || p_187494_1_.isFullCube()) && f1 == f4);
                break;
            }
            case NORTH: {
                p_187494_5_.set(1, f >= 1.0E-4f || f1 >= 1.0E-4f || f3 <= 0.9999f || f4 <= 0.9999f);
                p_187494_5_.set(0, (f2 < 1.0E-4f || p_187494_1_.isFullCube()) && f2 == f5);
                break;
            }
            case SOUTH: {
                p_187494_5_.set(1, f >= 1.0E-4f || f1 >= 1.0E-4f || f3 <= 0.9999f || f4 <= 0.9999f);
                p_187494_5_.set(0, (f5 > 0.9999f || p_187494_1_.isFullCube()) && f2 == f5);
                break;
            }
            case WEST: {
                p_187494_5_.set(1, f1 >= 1.0E-4f || f2 >= 1.0E-4f || f4 <= 0.9999f || f5 <= 0.9999f);
                p_187494_5_.set(0, (f < 1.0E-4f || p_187494_1_.isFullCube()) && f == f3);
                break;
            }
            case EAST: {
                p_187494_5_.set(1, f1 >= 1.0E-4f || f2 >= 1.0E-4f || f4 <= 0.9999f || f5 <= 0.9999f);
                p_187494_5_.set(0, (f3 > 0.9999f || p_187494_1_.isFullCube()) && f == f3);
            }
        }
    }

    private void renderQuadsFlat(IBlockAccess p_187496_1_, IBlockState p_187496_2_, BlockPos p_187496_3_, int p_187496_4_, boolean p_187496_5_, VertexBuffer p_187496_6_, List<BakedQuad> p_187496_7_, BitSet p_187496_8_) {
        double d0 = p_187496_3_.getX();
        double d1 = p_187496_3_.getY();
        double d2 = p_187496_3_.getZ();
        Block block = p_187496_2_.getBlock();
        Block.EnumOffsetType block$enumoffsettype = block.getOffsetType();
        if (block$enumoffsettype != Block.EnumOffsetType.NONE) {
            int i = p_187496_3_.getX();
            int j = p_187496_3_.getZ();
            long k = (long)(i * 3129871) ^ (long)j * 116129781L;
            k = k * k * 42317861L + k * 11L;
            d0 += ((double)((float)(k >> 16 & 0xFL) / 15.0f) - 0.5) * 0.5;
            d2 += ((double)((float)(k >> 24 & 0xFL) / 15.0f) - 0.5) * 0.5;
            if (block$enumoffsettype == Block.EnumOffsetType.XYZ) {
                d1 += ((double)((float)(k >> 20 & 0xFL) / 15.0f) - 1.0) * 0.2;
            }
        }
        int i1 = 0;
        int j1 = p_187496_7_.size();
        while (i1 < j1) {
            BakedQuad bakedquad = p_187496_7_.get(i1);
            if (p_187496_5_) {
                this.fillQuadBounds(p_187496_2_, bakedquad.getVertexData(), bakedquad.getFace(), null, p_187496_8_);
                p_187496_4_ = p_187496_8_.get(0) ? p_187496_2_.getPackedLightmapCoords(p_187496_1_, p_187496_3_.offset(bakedquad.getFace())) : p_187496_2_.getPackedLightmapCoords(p_187496_1_, p_187496_3_);
            }
            p_187496_6_.addVertexData(bakedquad.getVertexData());
            p_187496_6_.putBrightness4(p_187496_4_, p_187496_4_, p_187496_4_, p_187496_4_);
            if (bakedquad.hasTintIndex()) {
                int l = this.field_187499_a.func_186724_a(p_187496_2_, p_187496_1_, p_187496_3_, bakedquad.getTintIndex());
                if (EntityRenderer.anaglyphEnable) {
                    l = TextureUtil.anaglyphColor(l);
                }
                float f = (float)(l >> 16 & 0xFF) / 255.0f;
                float f1 = (float)(l >> 8 & 0xFF) / 255.0f;
                float f2 = (float)(l & 0xFF) / 255.0f;
                p_187496_6_.putColorMultiplier(f, f1, f2, 4);
                p_187496_6_.putColorMultiplier(f, f1, f2, 3);
                p_187496_6_.putColorMultiplier(f, f1, f2, 2);
                p_187496_6_.putColorMultiplier(f, f1, f2, 1);
            }
            p_187496_6_.putPosition(d0, d1, d2);
            ++i1;
        }
    }

    public void renderModelBrightnessColor(IBakedModel bakedModel, float p_178262_2_, float red, float green, float blue) {
        this.renderModelBrightnessColor(null, bakedModel, p_178262_2_, red, green, blue);
    }

    public void renderModelBrightnessColor(IBlockState p_187495_1_, IBakedModel p_187495_2_, float p_187495_3_, float p_187495_4_, float p_187495_5_, float p_187495_6_) {
        EnumFacing[] enumFacingArray = EnumFacing.values();
        int n = enumFacingArray.length;
        int n2 = 0;
        while (n2 < n) {
            EnumFacing enumfacing = enumFacingArray[n2];
            this.renderModelBrightnessColorQuads(p_187495_3_, p_187495_4_, p_187495_5_, p_187495_6_, p_187495_2_.getQuads(p_187495_1_, enumfacing, 0L));
            ++n2;
        }
        this.renderModelBrightnessColorQuads(p_187495_3_, p_187495_4_, p_187495_5_, p_187495_6_, p_187495_2_.getQuads(p_187495_1_, null, 0L));
    }

    public void renderModelBrightness(IBakedModel model, IBlockState p_178266_2_, float brightness, boolean p_178266_4_) {
        Block block = p_178266_2_.getBlock();
        GlStateManager.rotate(90.0f, 0.0f, 1.0f, 0.0f);
        int i = this.field_187499_a.func_186724_a(p_178266_2_, null, null, 0);
        if (EntityRenderer.anaglyphEnable) {
            i = TextureUtil.anaglyphColor(i);
        }
        float f = (float)(i >> 16 & 0xFF) / 255.0f;
        float f1 = (float)(i >> 8 & 0xFF) / 255.0f;
        float f2 = (float)(i & 0xFF) / 255.0f;
        if (!p_178266_4_) {
            GlStateManager.color(brightness, brightness, brightness, 1.0f);
        }
        this.renderModelBrightnessColor(p_178266_2_, model, brightness, f, f1, f2);
    }

    private void renderModelBrightnessColorQuads(float brightness, float red, float green, float blue, List<BakedQuad> listQuads) {
        Tessellator tessellator = Tessellator.getInstance();
        VertexBuffer vertexbuffer = tessellator.getBuffer();
        int i = 0;
        int j = listQuads.size();
        while (i < j) {
            BakedQuad bakedquad = listQuads.get(i);
            vertexbuffer.begin(7, DefaultVertexFormats.ITEM);
            vertexbuffer.addVertexData(bakedquad.getVertexData());
            if (bakedquad.hasTintIndex()) {
                vertexbuffer.putColorRGB_F4(red * brightness, green * brightness, blue * brightness);
            } else {
                vertexbuffer.putColorRGB_F4(brightness, brightness, brightness);
            }
            Vec3i vec3i = bakedquad.getFace().getDirectionVec();
            vertexbuffer.putNormal(vec3i.getX(), vec3i.getY(), vec3i.getZ());
            tessellator.draw();
            ++i;
        }
    }

    class AmbientOcclusionFace {
        private final float[] vertexColorMultiplier = new float[4];
        private final int[] vertexBrightness = new int[4];

        AmbientOcclusionFace() {
        }

        public void updateVertexBrightness(IBlockAccess p_187491_1_, IBlockState p_187491_2_, BlockPos p_187491_3_, EnumFacing p_187491_4_, float[] p_187491_5_, BitSet p_187491_6_) {
            int l1;
            float f7;
            int k1;
            float f6;
            int j1;
            float f5;
            int i1;
            float f4;
            BlockPos blockpos = p_187491_6_.get(0) ? p_187491_3_.offset(p_187491_4_) : p_187491_3_;
            BlockPos.PooledMutableBlockPos blockpos$pooledmutableblockpos = BlockPos.PooledMutableBlockPos.retain();
            EnumNeighborInfo blockmodelrenderer$enumneighborinfo = EnumNeighborInfo.getNeighbourInfo(p_187491_4_);
            BlockPos.PooledMutableBlockPos blockpos$pooledmutableblockpos1 = BlockPos.PooledMutableBlockPos.retain(blockpos).func_185341_c(blockmodelrenderer$enumneighborinfo.field_178276_g[0]);
            BlockPos.PooledMutableBlockPos blockpos$pooledmutableblockpos2 = BlockPos.PooledMutableBlockPos.retain(blockpos).func_185341_c(blockmodelrenderer$enumneighborinfo.field_178276_g[1]);
            BlockPos.PooledMutableBlockPos blockpos$pooledmutableblockpos3 = BlockPos.PooledMutableBlockPos.retain(blockpos).func_185341_c(blockmodelrenderer$enumneighborinfo.field_178276_g[2]);
            BlockPos.PooledMutableBlockPos blockpos$pooledmutableblockpos4 = BlockPos.PooledMutableBlockPos.retain(blockpos).func_185341_c(blockmodelrenderer$enumneighborinfo.field_178276_g[3]);
            int i = p_187491_2_.getPackedLightmapCoords(p_187491_1_, blockpos$pooledmutableblockpos1);
            int j = p_187491_2_.getPackedLightmapCoords(p_187491_1_, blockpos$pooledmutableblockpos2);
            int k = p_187491_2_.getPackedLightmapCoords(p_187491_1_, blockpos$pooledmutableblockpos3);
            int l = p_187491_2_.getPackedLightmapCoords(p_187491_1_, blockpos$pooledmutableblockpos4);
            float f = p_187491_1_.getBlockState(blockpos$pooledmutableblockpos1).func_185892_j();
            float f1 = p_187491_1_.getBlockState(blockpos$pooledmutableblockpos2).func_185892_j();
            float f2 = p_187491_1_.getBlockState(blockpos$pooledmutableblockpos3).func_185892_j();
            float f3 = p_187491_1_.getBlockState(blockpos$pooledmutableblockpos4).func_185892_j();
            boolean flag = p_187491_1_.getBlockState(blockpos$pooledmutableblockpos.set(blockpos$pooledmutableblockpos1).func_185341_c(p_187491_4_)).isTranslucent();
            boolean flag1 = p_187491_1_.getBlockState(blockpos$pooledmutableblockpos.set(blockpos$pooledmutableblockpos2).func_185341_c(p_187491_4_)).isTranslucent();
            boolean flag2 = p_187491_1_.getBlockState(blockpos$pooledmutableblockpos.set(blockpos$pooledmutableblockpos3).func_185341_c(p_187491_4_)).isTranslucent();
            boolean flag3 = p_187491_1_.getBlockState(blockpos$pooledmutableblockpos.set(blockpos$pooledmutableblockpos4).func_185341_c(p_187491_4_)).isTranslucent();
            if (!flag2 && !flag) {
                f4 = f;
                i1 = i;
            } else {
                BlockPos.PooledMutableBlockPos blockpos1 = blockpos$pooledmutableblockpos.set(blockpos$pooledmutableblockpos1).func_185341_c(blockmodelrenderer$enumneighborinfo.field_178276_g[2]);
                f4 = p_187491_1_.getBlockState(blockpos1).func_185892_j();
                i1 = p_187491_2_.getPackedLightmapCoords(p_187491_1_, blockpos1);
            }
            if (!flag3 && !flag) {
                f5 = f;
                j1 = i;
            } else {
                BlockPos.PooledMutableBlockPos blockpos2 = blockpos$pooledmutableblockpos.set(blockpos$pooledmutableblockpos1).func_185341_c(blockmodelrenderer$enumneighborinfo.field_178276_g[3]);
                f5 = p_187491_1_.getBlockState(blockpos2).func_185892_j();
                j1 = p_187491_2_.getPackedLightmapCoords(p_187491_1_, blockpos2);
            }
            if (!flag2 && !flag1) {
                f6 = f1;
                k1 = j;
            } else {
                BlockPos.PooledMutableBlockPos blockpos3 = blockpos$pooledmutableblockpos.set(blockpos$pooledmutableblockpos2).func_185341_c(blockmodelrenderer$enumneighborinfo.field_178276_g[2]);
                f6 = p_187491_1_.getBlockState(blockpos3).func_185892_j();
                k1 = p_187491_2_.getPackedLightmapCoords(p_187491_1_, blockpos3);
            }
            if (!flag3 && !flag1) {
                f7 = f1;
                l1 = j;
            } else {
                BlockPos.PooledMutableBlockPos blockpos4 = blockpos$pooledmutableblockpos.set(blockpos$pooledmutableblockpos2).func_185341_c(blockmodelrenderer$enumneighborinfo.field_178276_g[3]);
                f7 = p_187491_1_.getBlockState(blockpos4).func_185892_j();
                l1 = p_187491_2_.getPackedLightmapCoords(p_187491_1_, blockpos4);
            }
            int i3 = p_187491_2_.getPackedLightmapCoords(p_187491_1_, p_187491_3_);
            if (p_187491_6_.get(0) || !p_187491_1_.getBlockState(p_187491_3_.offset(p_187491_4_)).isOpaqueCube()) {
                i3 = p_187491_2_.getPackedLightmapCoords(p_187491_1_, p_187491_3_.offset(p_187491_4_));
            }
            float f8 = p_187491_6_.get(0) ? p_187491_1_.getBlockState(blockpos).func_185892_j() : p_187491_1_.getBlockState(p_187491_3_).func_185892_j();
            VertexTranslations blockmodelrenderer$vertextranslations = VertexTranslations.getVertexTranslations(p_187491_4_);
            blockpos$pooledmutableblockpos.release();
            blockpos$pooledmutableblockpos1.release();
            blockpos$pooledmutableblockpos2.release();
            blockpos$pooledmutableblockpos3.release();
            blockpos$pooledmutableblockpos4.release();
            if (p_187491_6_.get(1) && blockmodelrenderer$enumneighborinfo.field_178289_i) {
                float f29 = (f3 + f + f5 + f8) * 0.25f;
                float f30 = (f2 + f + f4 + f8) * 0.25f;
                float f31 = (f2 + f1 + f6 + f8) * 0.25f;
                float f32 = (f3 + f1 + f7 + f8) * 0.25f;
                float f13 = p_187491_5_[blockmodelrenderer$enumneighborinfo.field_178286_j[0].field_178229_m] * p_187491_5_[blockmodelrenderer$enumneighborinfo.field_178286_j[1].field_178229_m];
                float f14 = p_187491_5_[blockmodelrenderer$enumneighborinfo.field_178286_j[2].field_178229_m] * p_187491_5_[blockmodelrenderer$enumneighborinfo.field_178286_j[3].field_178229_m];
                float f15 = p_187491_5_[blockmodelrenderer$enumneighborinfo.field_178286_j[4].field_178229_m] * p_187491_5_[blockmodelrenderer$enumneighborinfo.field_178286_j[5].field_178229_m];
                float f16 = p_187491_5_[blockmodelrenderer$enumneighborinfo.field_178286_j[6].field_178229_m] * p_187491_5_[blockmodelrenderer$enumneighborinfo.field_178286_j[7].field_178229_m];
                float f17 = p_187491_5_[blockmodelrenderer$enumneighborinfo.field_178287_k[0].field_178229_m] * p_187491_5_[blockmodelrenderer$enumneighborinfo.field_178287_k[1].field_178229_m];
                float f18 = p_187491_5_[blockmodelrenderer$enumneighborinfo.field_178287_k[2].field_178229_m] * p_187491_5_[blockmodelrenderer$enumneighborinfo.field_178287_k[3].field_178229_m];
                float f19 = p_187491_5_[blockmodelrenderer$enumneighborinfo.field_178287_k[4].field_178229_m] * p_187491_5_[blockmodelrenderer$enumneighborinfo.field_178287_k[5].field_178229_m];
                float f20 = p_187491_5_[blockmodelrenderer$enumneighborinfo.field_178287_k[6].field_178229_m] * p_187491_5_[blockmodelrenderer$enumneighborinfo.field_178287_k[7].field_178229_m];
                float f21 = p_187491_5_[blockmodelrenderer$enumneighborinfo.field_178284_l[0].field_178229_m] * p_187491_5_[blockmodelrenderer$enumneighborinfo.field_178284_l[1].field_178229_m];
                float f22 = p_187491_5_[blockmodelrenderer$enumneighborinfo.field_178284_l[2].field_178229_m] * p_187491_5_[blockmodelrenderer$enumneighborinfo.field_178284_l[3].field_178229_m];
                float f23 = p_187491_5_[blockmodelrenderer$enumneighborinfo.field_178284_l[4].field_178229_m] * p_187491_5_[blockmodelrenderer$enumneighborinfo.field_178284_l[5].field_178229_m];
                float f24 = p_187491_5_[blockmodelrenderer$enumneighborinfo.field_178284_l[6].field_178229_m] * p_187491_5_[blockmodelrenderer$enumneighborinfo.field_178284_l[7].field_178229_m];
                float f25 = p_187491_5_[blockmodelrenderer$enumneighborinfo.field_178285_m[0].field_178229_m] * p_187491_5_[blockmodelrenderer$enumneighborinfo.field_178285_m[1].field_178229_m];
                float f26 = p_187491_5_[blockmodelrenderer$enumneighborinfo.field_178285_m[2].field_178229_m] * p_187491_5_[blockmodelrenderer$enumneighborinfo.field_178285_m[3].field_178229_m];
                float f27 = p_187491_5_[blockmodelrenderer$enumneighborinfo.field_178285_m[4].field_178229_m] * p_187491_5_[blockmodelrenderer$enumneighborinfo.field_178285_m[5].field_178229_m];
                float f28 = p_187491_5_[blockmodelrenderer$enumneighborinfo.field_178285_m[6].field_178229_m] * p_187491_5_[blockmodelrenderer$enumneighborinfo.field_178285_m[7].field_178229_m];
                this.vertexColorMultiplier[((VertexTranslations)blockmodelrenderer$vertextranslations).field_178191_g] = f29 * f13 + f30 * f14 + f31 * f15 + f32 * f16;
                this.vertexColorMultiplier[((VertexTranslations)blockmodelrenderer$vertextranslations).field_178200_h] = f29 * f17 + f30 * f18 + f31 * f19 + f32 * f20;
                this.vertexColorMultiplier[((VertexTranslations)blockmodelrenderer$vertextranslations).field_178201_i] = f29 * f21 + f30 * f22 + f31 * f23 + f32 * f24;
                this.vertexColorMultiplier[((VertexTranslations)blockmodelrenderer$vertextranslations).field_178198_j] = f29 * f25 + f30 * f26 + f31 * f27 + f32 * f28;
                int i2 = this.getAoBrightness(l, i, j1, i3);
                int j2 = this.getAoBrightness(k, i, i1, i3);
                int k2 = this.getAoBrightness(k, j, k1, i3);
                int l2 = this.getAoBrightness(l, j, l1, i3);
                this.vertexBrightness[((VertexTranslations)blockmodelrenderer$vertextranslations).field_178191_g] = this.getVertexBrightness(i2, j2, k2, l2, f13, f14, f15, f16);
                this.vertexBrightness[((VertexTranslations)blockmodelrenderer$vertextranslations).field_178200_h] = this.getVertexBrightness(i2, j2, k2, l2, f17, f18, f19, f20);
                this.vertexBrightness[((VertexTranslations)blockmodelrenderer$vertextranslations).field_178201_i] = this.getVertexBrightness(i2, j2, k2, l2, f21, f22, f23, f24);
                this.vertexBrightness[((VertexTranslations)blockmodelrenderer$vertextranslations).field_178198_j] = this.getVertexBrightness(i2, j2, k2, l2, f25, f26, f27, f28);
            } else {
                float f9 = (f3 + f + f5 + f8) * 0.25f;
                float f10 = (f2 + f + f4 + f8) * 0.25f;
                float f11 = (f2 + f1 + f6 + f8) * 0.25f;
                float f12 = (f3 + f1 + f7 + f8) * 0.25f;
                this.vertexBrightness[((VertexTranslations)blockmodelrenderer$vertextranslations).field_178191_g] = this.getAoBrightness(l, i, j1, i3);
                this.vertexBrightness[((VertexTranslations)blockmodelrenderer$vertextranslations).field_178200_h] = this.getAoBrightness(k, i, i1, i3);
                this.vertexBrightness[((VertexTranslations)blockmodelrenderer$vertextranslations).field_178201_i] = this.getAoBrightness(k, j, k1, i3);
                this.vertexBrightness[((VertexTranslations)blockmodelrenderer$vertextranslations).field_178198_j] = this.getAoBrightness(l, j, l1, i3);
                this.vertexColorMultiplier[((VertexTranslations)blockmodelrenderer$vertextranslations).field_178191_g] = f9;
                this.vertexColorMultiplier[((VertexTranslations)blockmodelrenderer$vertextranslations).field_178200_h] = f10;
                this.vertexColorMultiplier[((VertexTranslations)blockmodelrenderer$vertextranslations).field_178201_i] = f11;
                this.vertexColorMultiplier[((VertexTranslations)blockmodelrenderer$vertextranslations).field_178198_j] = f12;
            }
        }

        private int getAoBrightness(int br1, int br2, int br3, int br4) {
            if (br1 == 0) {
                br1 = br4;
            }
            if (br2 == 0) {
                br2 = br4;
            }
            if (br3 == 0) {
                br3 = br4;
            }
            return br1 + br2 + br3 + br4 >> 2 & 0xFF00FF;
        }

        private int getVertexBrightness(int p_178203_1_, int p_178203_2_, int p_178203_3_, int p_178203_4_, float p_178203_5_, float p_178203_6_, float p_178203_7_, float p_178203_8_) {
            int i = (int)((float)(p_178203_1_ >> 16 & 0xFF) * p_178203_5_ + (float)(p_178203_2_ >> 16 & 0xFF) * p_178203_6_ + (float)(p_178203_3_ >> 16 & 0xFF) * p_178203_7_ + (float)(p_178203_4_ >> 16 & 0xFF) * p_178203_8_) & 0xFF;
            int j = (int)((float)(p_178203_1_ & 0xFF) * p_178203_5_ + (float)(p_178203_2_ & 0xFF) * p_178203_6_ + (float)(p_178203_3_ & 0xFF) * p_178203_7_ + (float)(p_178203_4_ & 0xFF) * p_178203_8_) & 0xFF;
            return i << 16 | j;
        }
    }

    public static enum EnumNeighborInfo {
        DOWN(new EnumFacing[]{EnumFacing.WEST, EnumFacing.EAST, EnumFacing.NORTH, EnumFacing.SOUTH}, 0.5f, true, new Orientation[]{Orientation.FLIP_WEST, Orientation.SOUTH, Orientation.FLIP_WEST, Orientation.FLIP_SOUTH, Orientation.WEST, Orientation.FLIP_SOUTH, Orientation.WEST, Orientation.SOUTH}, new Orientation[]{Orientation.FLIP_WEST, Orientation.NORTH, Orientation.FLIP_WEST, Orientation.FLIP_NORTH, Orientation.WEST, Orientation.FLIP_NORTH, Orientation.WEST, Orientation.NORTH}, new Orientation[]{Orientation.FLIP_EAST, Orientation.NORTH, Orientation.FLIP_EAST, Orientation.FLIP_NORTH, Orientation.EAST, Orientation.FLIP_NORTH, Orientation.EAST, Orientation.NORTH}, new Orientation[]{Orientation.FLIP_EAST, Orientation.SOUTH, Orientation.FLIP_EAST, Orientation.FLIP_SOUTH, Orientation.EAST, Orientation.FLIP_SOUTH, Orientation.EAST, Orientation.SOUTH}),
        UP(new EnumFacing[]{EnumFacing.EAST, EnumFacing.WEST, EnumFacing.NORTH, EnumFacing.SOUTH}, 1.0f, true, new Orientation[]{Orientation.EAST, Orientation.SOUTH, Orientation.EAST, Orientation.FLIP_SOUTH, Orientation.FLIP_EAST, Orientation.FLIP_SOUTH, Orientation.FLIP_EAST, Orientation.SOUTH}, new Orientation[]{Orientation.EAST, Orientation.NORTH, Orientation.EAST, Orientation.FLIP_NORTH, Orientation.FLIP_EAST, Orientation.FLIP_NORTH, Orientation.FLIP_EAST, Orientation.NORTH}, new Orientation[]{Orientation.WEST, Orientation.NORTH, Orientation.WEST, Orientation.FLIP_NORTH, Orientation.FLIP_WEST, Orientation.FLIP_NORTH, Orientation.FLIP_WEST, Orientation.NORTH}, new Orientation[]{Orientation.WEST, Orientation.SOUTH, Orientation.WEST, Orientation.FLIP_SOUTH, Orientation.FLIP_WEST, Orientation.FLIP_SOUTH, Orientation.FLIP_WEST, Orientation.SOUTH}),
        NORTH(new EnumFacing[]{EnumFacing.UP, EnumFacing.DOWN, EnumFacing.EAST, EnumFacing.WEST}, 0.8f, true, new Orientation[]{Orientation.UP, Orientation.FLIP_WEST, Orientation.UP, Orientation.WEST, Orientation.FLIP_UP, Orientation.WEST, Orientation.FLIP_UP, Orientation.FLIP_WEST}, new Orientation[]{Orientation.UP, Orientation.FLIP_EAST, Orientation.UP, Orientation.EAST, Orientation.FLIP_UP, Orientation.EAST, Orientation.FLIP_UP, Orientation.FLIP_EAST}, new Orientation[]{Orientation.DOWN, Orientation.FLIP_EAST, Orientation.DOWN, Orientation.EAST, Orientation.FLIP_DOWN, Orientation.EAST, Orientation.FLIP_DOWN, Orientation.FLIP_EAST}, new Orientation[]{Orientation.DOWN, Orientation.FLIP_WEST, Orientation.DOWN, Orientation.WEST, Orientation.FLIP_DOWN, Orientation.WEST, Orientation.FLIP_DOWN, Orientation.FLIP_WEST}),
        SOUTH(new EnumFacing[]{EnumFacing.WEST, EnumFacing.EAST, EnumFacing.DOWN, EnumFacing.UP}, 0.8f, true, new Orientation[]{Orientation.UP, Orientation.FLIP_WEST, Orientation.FLIP_UP, Orientation.FLIP_WEST, Orientation.FLIP_UP, Orientation.WEST, Orientation.UP, Orientation.WEST}, new Orientation[]{Orientation.DOWN, Orientation.FLIP_WEST, Orientation.FLIP_DOWN, Orientation.FLIP_WEST, Orientation.FLIP_DOWN, Orientation.WEST, Orientation.DOWN, Orientation.WEST}, new Orientation[]{Orientation.DOWN, Orientation.FLIP_EAST, Orientation.FLIP_DOWN, Orientation.FLIP_EAST, Orientation.FLIP_DOWN, Orientation.EAST, Orientation.DOWN, Orientation.EAST}, new Orientation[]{Orientation.UP, Orientation.FLIP_EAST, Orientation.FLIP_UP, Orientation.FLIP_EAST, Orientation.FLIP_UP, Orientation.EAST, Orientation.UP, Orientation.EAST}),
        WEST(new EnumFacing[]{EnumFacing.UP, EnumFacing.DOWN, EnumFacing.NORTH, EnumFacing.SOUTH}, 0.6f, true, new Orientation[]{Orientation.UP, Orientation.SOUTH, Orientation.UP, Orientation.FLIP_SOUTH, Orientation.FLIP_UP, Orientation.FLIP_SOUTH, Orientation.FLIP_UP, Orientation.SOUTH}, new Orientation[]{Orientation.UP, Orientation.NORTH, Orientation.UP, Orientation.FLIP_NORTH, Orientation.FLIP_UP, Orientation.FLIP_NORTH, Orientation.FLIP_UP, Orientation.NORTH}, new Orientation[]{Orientation.DOWN, Orientation.NORTH, Orientation.DOWN, Orientation.FLIP_NORTH, Orientation.FLIP_DOWN, Orientation.FLIP_NORTH, Orientation.FLIP_DOWN, Orientation.NORTH}, new Orientation[]{Orientation.DOWN, Orientation.SOUTH, Orientation.DOWN, Orientation.FLIP_SOUTH, Orientation.FLIP_DOWN, Orientation.FLIP_SOUTH, Orientation.FLIP_DOWN, Orientation.SOUTH}),
        EAST(new EnumFacing[]{EnumFacing.DOWN, EnumFacing.UP, EnumFacing.NORTH, EnumFacing.SOUTH}, 0.6f, true, new Orientation[]{Orientation.FLIP_DOWN, Orientation.SOUTH, Orientation.FLIP_DOWN, Orientation.FLIP_SOUTH, Orientation.DOWN, Orientation.FLIP_SOUTH, Orientation.DOWN, Orientation.SOUTH}, new Orientation[]{Orientation.FLIP_DOWN, Orientation.NORTH, Orientation.FLIP_DOWN, Orientation.FLIP_NORTH, Orientation.DOWN, Orientation.FLIP_NORTH, Orientation.DOWN, Orientation.NORTH}, new Orientation[]{Orientation.FLIP_UP, Orientation.NORTH, Orientation.FLIP_UP, Orientation.FLIP_NORTH, Orientation.UP, Orientation.FLIP_NORTH, Orientation.UP, Orientation.NORTH}, new Orientation[]{Orientation.FLIP_UP, Orientation.SOUTH, Orientation.FLIP_UP, Orientation.FLIP_SOUTH, Orientation.UP, Orientation.FLIP_SOUTH, Orientation.UP, Orientation.SOUTH});

        protected final EnumFacing[] field_178276_g;
        protected final float field_178288_h;
        protected final boolean field_178289_i;
        protected final Orientation[] field_178286_j;
        protected final Orientation[] field_178287_k;
        protected final Orientation[] field_178284_l;
        protected final Orientation[] field_178285_m;
        private static final EnumNeighborInfo[] VALUES;

        static {
            VALUES = new EnumNeighborInfo[6];
            EnumNeighborInfo.VALUES[EnumFacing.DOWN.getIndex()] = DOWN;
            EnumNeighborInfo.VALUES[EnumFacing.UP.getIndex()] = UP;
            EnumNeighborInfo.VALUES[EnumFacing.NORTH.getIndex()] = NORTH;
            EnumNeighborInfo.VALUES[EnumFacing.SOUTH.getIndex()] = SOUTH;
            EnumNeighborInfo.VALUES[EnumFacing.WEST.getIndex()] = WEST;
            EnumNeighborInfo.VALUES[EnumFacing.EAST.getIndex()] = EAST;
        }

        private EnumNeighborInfo(EnumFacing[] p_i46236_3_, float p_i46236_4_, boolean p_i46236_5_, Orientation[] p_i46236_6_, Orientation[] p_i46236_7_, Orientation[] p_i46236_8_, Orientation[] p_i46236_9_) {
            this.field_178276_g = p_i46236_3_;
            this.field_178288_h = p_i46236_4_;
            this.field_178289_i = p_i46236_5_;
            this.field_178286_j = p_i46236_6_;
            this.field_178287_k = p_i46236_7_;
            this.field_178284_l = p_i46236_8_;
            this.field_178285_m = p_i46236_9_;
        }

        public static EnumNeighborInfo getNeighbourInfo(EnumFacing p_178273_0_) {
            return VALUES[p_178273_0_.getIndex()];
        }
    }

    public static enum Orientation {
        DOWN(EnumFacing.DOWN, false),
        UP(EnumFacing.UP, false),
        NORTH(EnumFacing.NORTH, false),
        SOUTH(EnumFacing.SOUTH, false),
        WEST(EnumFacing.WEST, false),
        EAST(EnumFacing.EAST, false),
        FLIP_DOWN(EnumFacing.DOWN, true),
        FLIP_UP(EnumFacing.UP, true),
        FLIP_NORTH(EnumFacing.NORTH, true),
        FLIP_SOUTH(EnumFacing.SOUTH, true),
        FLIP_WEST(EnumFacing.WEST, true),
        FLIP_EAST(EnumFacing.EAST, true);

        protected final int field_178229_m;

        private Orientation(EnumFacing p_i46233_3_, boolean p_i46233_4_) {
            this.field_178229_m = p_i46233_3_.getIndex() + (p_i46233_4_ ? EnumFacing.values().length : 0);
        }
    }

    static enum VertexTranslations {
        DOWN(0, 1, 2, 3),
        UP(2, 3, 0, 1),
        NORTH(3, 0, 1, 2),
        SOUTH(0, 1, 2, 3),
        WEST(3, 0, 1, 2),
        EAST(1, 2, 3, 0);

        private final int field_178191_g;
        private final int field_178200_h;
        private final int field_178201_i;
        private final int field_178198_j;
        private static final VertexTranslations[] VALUES;

        static {
            VALUES = new VertexTranslations[6];
            VertexTranslations.VALUES[EnumFacing.DOWN.getIndex()] = DOWN;
            VertexTranslations.VALUES[EnumFacing.UP.getIndex()] = UP;
            VertexTranslations.VALUES[EnumFacing.NORTH.getIndex()] = NORTH;
            VertexTranslations.VALUES[EnumFacing.SOUTH.getIndex()] = SOUTH;
            VertexTranslations.VALUES[EnumFacing.WEST.getIndex()] = WEST;
            VertexTranslations.VALUES[EnumFacing.EAST.getIndex()] = EAST;
        }

        private VertexTranslations(int p_i46234_3_, int p_i46234_4_, int p_i46234_5_, int p_i46234_6_) {
            this.field_178191_g = p_i46234_3_;
            this.field_178200_h = p_i46234_4_;
            this.field_178201_i = p_i46234_5_;
            this.field_178198_j = p_i46234_6_;
        }

        public static VertexTranslations getVertexTranslations(EnumFacing p_178184_0_) {
            return VALUES[p_178184_0_.getIndex()];
        }
    }
}

