/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.entity;

import net.minecraft.client.model.IMultipassModel;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelBoat;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.item.EntityBoat;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;

public class RenderBoat
extends Render<EntityBoat> {
    private static final ResourceLocation[] boatTextures = new ResourceLocation[]{new ResourceLocation("textures/entity/boat/boat_oak.png"), new ResourceLocation("textures/entity/boat/boat_spruce.png"), new ResourceLocation("textures/entity/boat/boat_birch.png"), new ResourceLocation("textures/entity/boat/boat_jungle.png"), new ResourceLocation("textures/entity/boat/boat_acacia.png"), new ResourceLocation("textures/entity/boat/boat_darkoak.png")};
    protected ModelBase modelBoat = new ModelBoat();

    public RenderBoat(RenderManager renderManagerIn) {
        super(renderManagerIn);
        this.shadowSize = 0.5f;
    }

    @Override
    public void doRender(EntityBoat entity, double x, double y, double z, float entityYaw, float partialTicks) {
        GlStateManager.pushMatrix();
        this.func_188309_a(x, y, z);
        this.func_188311_a(entity, entityYaw, partialTicks);
        this.bindEntityTexture(entity);
        if (this.field_188301_f) {
            GlStateManager.enableColorMaterial();
            GlStateManager.func_187431_e(this.func_188298_c(entity));
        }
        this.modelBoat.render(entity, partialTicks, 0.0f, -0.1f, 0.0f, 0.0f, 0.0625f);
        if (this.field_188301_f) {
            GlStateManager.func_187417_n();
            GlStateManager.disableColorMaterial();
        }
        GlStateManager.popMatrix();
        super.doRender(entity, x, y, z, entityYaw, partialTicks);
    }

    public void func_188311_a(EntityBoat p_188311_1_, float p_188311_2_, float p_188311_3_) {
        GlStateManager.rotate(180.0f - p_188311_2_, 0.0f, 1.0f, 0.0f);
        float f = (float)p_188311_1_.getTimeSinceHit() - p_188311_3_;
        float f1 = p_188311_1_.getDamageTaken() - p_188311_3_;
        if (f1 < 0.0f) {
            f1 = 0.0f;
        }
        if (f > 0.0f) {
            GlStateManager.rotate(MathHelper.sin(f) * f * f1 / 10.0f * (float)p_188311_1_.getForwardDirection(), 1.0f, 0.0f, 0.0f);
        }
        GlStateManager.scale(-1.0f, -1.0f, 1.0f);
    }

    public void func_188309_a(double p_188309_1_, double p_188309_3_, double p_188309_5_) {
        GlStateManager.translate((float)p_188309_1_, (float)p_188309_3_ + 0.375f, (float)p_188309_5_);
    }

    @Override
    protected ResourceLocation getEntityTexture(EntityBoat entity) {
        return boatTextures[entity.func_184453_r().ordinal()];
    }

    @Override
    public boolean func_188295_H_() {
        return true;
    }

    @Override
    public void func_188300_b(EntityBoat p_188300_1_, double p_188300_2_, double p_188300_4_, double p_188300_6_, float p_188300_8_, float p_188300_9_) {
        GlStateManager.pushMatrix();
        this.func_188309_a(p_188300_2_, p_188300_4_, p_188300_6_);
        this.func_188311_a(p_188300_1_, p_188300_8_, p_188300_9_);
        this.bindEntityTexture(p_188300_1_);
        ((IMultipassModel)((Object)this.modelBoat)).func_187054_b(p_188300_1_, p_188300_9_, 0.0f, -0.1f, 0.0f, 0.0f, 0.0625f);
        GlStateManager.popMatrix();
    }
}

