/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.boss.dragon.phase;

import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.boss.dragon.phase.PhaseBase;
import net.minecraft.entity.boss.dragon.phase.PhaseList;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.gen.feature.WorldGenEndPodium;

public class PhaseLanding
extends PhaseBase {
    private Vec3d field_188685_b;

    public PhaseLanding(EntityDragon dragonIn) {
        super(dragonIn);
    }

    @Override
    public void func_188657_b() {
        Vec3d vec3d = this.dragon.func_184665_a(1.0f).normalize();
        vec3d.rotateYaw(-0.7853982f);
        double d0 = this.dragon.dragonPartHead.posX;
        double d1 = this.dragon.dragonPartHead.posY + (double)(this.dragon.dragonPartHead.height / 2.0f);
        double d2 = this.dragon.dragonPartHead.posZ;
        int i = 0;
        while (i < 8) {
            double d3 = d0 + this.dragon.getRNG().nextGaussian() / 2.0;
            double d4 = d1 + this.dragon.getRNG().nextGaussian() / 2.0;
            double d5 = d2 + this.dragon.getRNG().nextGaussian() / 2.0;
            this.dragon.worldObj.spawnParticle(EnumParticleTypes.DRAGON_BREATH, d3, d4, d5, -vec3d.xCoord * (double)0.08f + this.dragon.motionX, -vec3d.yCoord * (double)0.3f + this.dragon.motionY, -vec3d.zCoord * (double)0.08f + this.dragon.motionZ, new int[0]);
            vec3d.rotateYaw(0.19634955f);
            ++i;
        }
    }

    @Override
    public void func_188659_c() {
        if (this.field_188685_b == null) {
            this.field_188685_b = new Vec3d(this.dragon.worldObj.getTopSolidOrLiquidBlock(WorldGenEndPodium.field_186139_a));
        }
        if (this.field_188685_b.func_186679_c(this.dragon.posX, this.dragon.posY, this.dragon.posZ) < 1.0) {
            this.dragon.getPhaseManager().func_188757_b(PhaseList.SITTING_FLAMING).func_188663_j();
            this.dragon.getPhaseManager().func_188758_a(PhaseList.SITTING_SCANNING);
        }
    }

    @Override
    public float func_188651_f() {
        return 1.5f;
    }

    @Override
    public float func_188653_h() {
        float f = MathHelper.sqrt_double(this.dragon.motionX * this.dragon.motionX + this.dragon.motionZ * this.dragon.motionZ) + 1.0f;
        float f1 = Math.min(f, 40.0f);
        return f1 / f;
    }

    @Override
    public void func_188660_d() {
        this.field_188685_b = null;
    }

    @Override
    public Vec3d func_188650_g() {
        return this.field_188685_b;
    }

    public PhaseList<PhaseLanding> func_188652_i() {
        return PhaseList.LANDING;
    }
}

