/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.item;

import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.ILockableContainer;
import net.minecraft.world.LockCode;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.loot.ILootContainer;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootTable;

public abstract class EntityMinecartContainer
extends EntityMinecart
implements ILockableContainer,
ILootContainer {
    private ItemStack[] minecartContainerItems = new ItemStack[36];
    private boolean dropContentsWhenDead = true;
    private ResourceLocation field_184290_c;
    private long field_184291_d;

    public EntityMinecartContainer(World worldIn) {
        super(worldIn);
    }

    public EntityMinecartContainer(World worldIn, double x, double y, double z) {
        super(worldIn, x, y, z);
    }

    @Override
    public void killMinecart(DamageSource source) {
        super.killMinecart(source);
        if (this.worldObj.getGameRules().getBoolean("doEntityDrops")) {
            InventoryHelper.dropInventoryItems(this.worldObj, this, (IInventory)this);
        }
    }

    @Override
    public ItemStack getStackInSlot(int index) {
        this.func_184288_f(null);
        return this.minecartContainerItems[index];
    }

    @Override
    public ItemStack decrStackSize(int index, int count) {
        this.func_184288_f(null);
        return ItemStackHelper.func_188382_a(this.minecartContainerItems, index, count);
    }

    @Override
    public ItemStack removeStackFromSlot(int index) {
        this.func_184288_f(null);
        if (this.minecartContainerItems[index] != null) {
            ItemStack itemstack = this.minecartContainerItems[index];
            this.minecartContainerItems[index] = null;
            return itemstack;
        }
        return null;
    }

    @Override
    public void setInventorySlotContents(int index, ItemStack stack) {
        this.func_184288_f(null);
        this.minecartContainerItems[index] = stack;
        if (stack != null && stack.stackSize > this.getInventoryStackLimit()) {
            stack.stackSize = this.getInventoryStackLimit();
        }
    }

    @Override
    public void markDirty() {
    }

    @Override
    public boolean isUseableByPlayer(EntityPlayer player) {
        return this.isDead ? false : player.getDistanceSqToEntity(this) <= 64.0;
    }

    @Override
    public void openInventory(EntityPlayer player) {
    }

    @Override
    public void closeInventory(EntityPlayer player) {
    }

    @Override
    public boolean isItemValidForSlot(int index, ItemStack stack) {
        return true;
    }

    @Override
    public String getName() {
        return this.hasCustomName() ? this.getCustomNameTag() : "container.minecart";
    }

    @Override
    public int getInventoryStackLimit() {
        return 64;
    }

    @Override
    public Entity changeDimension(int dimensionIn) {
        this.dropContentsWhenDead = false;
        return super.changeDimension(dimensionIn);
    }

    @Override
    public void setDead() {
        if (this.dropContentsWhenDead) {
            InventoryHelper.dropInventoryItems(this.worldObj, this, (IInventory)this);
        }
        super.setDead();
    }

    @Override
    public void func_184174_b(boolean p_184174_1_) {
        this.dropContentsWhenDead = p_184174_1_;
    }

    @Override
    protected void writeEntityToNBT(NBTTagCompound tagCompound) {
        super.writeEntityToNBT(tagCompound);
        if (this.field_184290_c != null) {
            tagCompound.setString("LootTable", this.field_184290_c.toString());
            if (this.field_184291_d != 0L) {
                tagCompound.setLong("LootTableSeed", this.field_184291_d);
            }
        } else {
            NBTTagList nbttaglist = new NBTTagList();
            int i = 0;
            while (i < this.minecartContainerItems.length) {
                if (this.minecartContainerItems[i] != null) {
                    NBTTagCompound nbttagcompound = new NBTTagCompound();
                    nbttagcompound.setByte("Slot", (byte)i);
                    this.minecartContainerItems[i].writeToNBT(nbttagcompound);
                    nbttaglist.appendTag(nbttagcompound);
                }
                ++i;
            }
            tagCompound.setTag("Items", nbttaglist);
        }
    }

    @Override
    protected void readEntityFromNBT(NBTTagCompound tagCompund) {
        super.readEntityFromNBT(tagCompund);
        this.minecartContainerItems = new ItemStack[this.getSizeInventory()];
        if (tagCompund.hasKey("LootTable", 8)) {
            this.field_184290_c = new ResourceLocation(tagCompund.getString("LootTable"));
            this.field_184291_d = tagCompund.getLong("LootTableSeed");
        } else {
            NBTTagList nbttaglist = tagCompund.getTagList("Items", 10);
            int i = 0;
            while (i < nbttaglist.tagCount()) {
                NBTTagCompound nbttagcompound = nbttaglist.getCompoundTagAt(i);
                int j = nbttagcompound.getByte("Slot") & 0xFF;
                if (j >= 0 && j < this.minecartContainerItems.length) {
                    this.minecartContainerItems[j] = ItemStack.loadItemStackFromNBT(nbttagcompound);
                }
                ++i;
            }
        }
    }

    @Override
    public boolean func_184230_a(EntityPlayer p_184230_1_, ItemStack p_184230_2_, EnumHand p_184230_3_) {
        if (!this.worldObj.isRemote) {
            p_184230_1_.displayGUIChest(this);
        }
        return true;
    }

    @Override
    protected void applyDrag() {
        float f = 0.98f;
        if (this.field_184290_c == null) {
            int i = 15 - Container.calcRedstoneFromInventory(this);
            f += (float)i * 0.001f;
        }
        this.motionX *= (double)f;
        this.motionY *= 0.0;
        this.motionZ *= (double)f;
    }

    @Override
    public int getField(int id) {
        return 0;
    }

    @Override
    public void setField(int id, int value) {
    }

    @Override
    public int getFieldCount() {
        return 0;
    }

    @Override
    public boolean isLocked() {
        return false;
    }

    @Override
    public void setLockCode(LockCode code) {
    }

    @Override
    public LockCode getLockCode() {
        return LockCode.EMPTY_CODE;
    }

    public void func_184288_f(EntityPlayer p_184288_1_) {
        if (this.field_184290_c != null) {
            LootTable loottable = this.worldObj.getLootTableManager().func_186521_a(this.field_184290_c);
            this.field_184290_c = null;
            Random random = this.field_184291_d == 0L ? new Random() : new Random(this.field_184291_d);
            LootContext.Builder lootcontext$builder = new LootContext.Builder((WorldServer)this.worldObj);
            if (p_184288_1_ != null) {
                lootcontext$builder.withLuck(p_184288_1_.getLuck());
            }
            loottable.func_186460_a(this, random, lootcontext$builder.build());
        }
    }

    @Override
    public void clear() {
        this.func_184288_f(null);
        int i = 0;
        while (i < this.minecartContainerItems.length) {
            this.minecartContainerItems[i] = null;
            ++i;
        }
    }

    public void func_184289_a(ResourceLocation p_184289_1_, long p_184289_2_) {
        this.field_184290_c = p_184289_1_;
        this.field_184291_d = p_184289_2_;
    }

    @Override
    public ResourceLocation getLootTable() {
        return this.field_184290_c;
    }
}

