/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.pathfinding;

import net.minecraft.entity.Entity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.util.math.Vec3d;

public class PathEntity {
    private final PathPoint[] points;
    private PathPoint[] field_186312_b = new PathPoint[0];
    private PathPoint[] field_186313_c = new PathPoint[0];
    private PathPoint field_186314_d;
    private int currentPathIndex;
    private int pathLength;

    public PathEntity(PathPoint[] pathpoints) {
        this.points = pathpoints;
        this.pathLength = pathpoints.length;
    }

    public void incrementPathIndex() {
        ++this.currentPathIndex;
    }

    public boolean isFinished() {
        return this.currentPathIndex >= this.pathLength;
    }

    public PathPoint getFinalPathPoint() {
        return this.pathLength > 0 ? this.points[this.pathLength - 1] : null;
    }

    public PathPoint getPathPointFromIndex(int index) {
        return this.points[index];
    }

    public void func_186309_a(int p_186309_1_, PathPoint p_186309_2_) {
        this.points[p_186309_1_] = p_186309_2_;
    }

    public int getCurrentPathLength() {
        return this.pathLength;
    }

    public void setCurrentPathLength(int length) {
        this.pathLength = length;
    }

    public int getCurrentPathIndex() {
        return this.currentPathIndex;
    }

    public void setCurrentPathIndex(int currentPathIndexIn) {
        this.currentPathIndex = currentPathIndexIn;
    }

    public Vec3d getVectorFromIndex(Entity entityIn, int index) {
        double d0 = (double)this.points[index].xCoord + (double)((int)(entityIn.width + 1.0f)) * 0.5;
        double d1 = this.points[index].yCoord;
        double d2 = (double)this.points[index].zCoord + (double)((int)(entityIn.width + 1.0f)) * 0.5;
        return new Vec3d(d0, d1, d2);
    }

    public Vec3d getPosition(Entity entityIn) {
        return this.getVectorFromIndex(entityIn, this.currentPathIndex);
    }

    public Vec3d func_186310_f() {
        PathPoint pathpoint = this.points[this.currentPathIndex];
        return new Vec3d(pathpoint.xCoord, pathpoint.yCoord, pathpoint.zCoord);
    }

    public boolean isSamePath(PathEntity pathentityIn) {
        if (pathentityIn == null) {
            return false;
        }
        if (pathentityIn.points.length != this.points.length) {
            return false;
        }
        int i = 0;
        while (i < this.points.length) {
            if (this.points[i].xCoord != pathentityIn.points[i].xCoord || this.points[i].yCoord != pathentityIn.points[i].yCoord || this.points[i].zCoord != pathentityIn.points[i].zCoord) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean isDestinationSame(Vec3d vec) {
        PathPoint pathpoint = this.getFinalPathPoint();
        return pathpoint == null ? false : pathpoint.xCoord == (int)vec.xCoord && pathpoint.zCoord == (int)vec.zCoord;
    }

    public static PathEntity func_186311_b(PacketBuffer p_186311_0_) {
        int i = p_186311_0_.readInt();
        PathPoint pathpoint = PathPoint.func_186282_b(p_186311_0_);
        PathPoint[] apathpoint = new PathPoint[p_186311_0_.readInt()];
        int j = 0;
        while (j < apathpoint.length) {
            apathpoint[j] = PathPoint.func_186282_b(p_186311_0_);
            ++j;
        }
        PathPoint[] apathpoint1 = new PathPoint[p_186311_0_.readInt()];
        int k = 0;
        while (k < apathpoint1.length) {
            apathpoint1[k] = PathPoint.func_186282_b(p_186311_0_);
            ++k;
        }
        PathPoint[] apathpoint2 = new PathPoint[p_186311_0_.readInt()];
        int l = 0;
        while (l < apathpoint2.length) {
            apathpoint2[l] = PathPoint.func_186282_b(p_186311_0_);
            ++l;
        }
        PathEntity pathentity = new PathEntity(apathpoint);
        pathentity.field_186312_b = apathpoint1;
        pathentity.field_186313_c = apathpoint2;
        pathentity.field_186314_d = pathpoint;
        pathentity.currentPathIndex = i;
        return pathentity;
    }
}

