/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.tileentity;

import java.util.Arrays;
import net.minecraft.block.BlockBrewingStand;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ContainerBrewingStand;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.potion.PotionHelper;
import net.minecraft.tileentity.TileEntityLockable;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;

public class TileEntityBrewingStand
extends TileEntityLockable
implements ITickable,
ISidedInventory {
    private static final int[] inputSlots = new int[]{3};
    private static final int[] field_184277_f;
    private static final int[] outputSlots;
    private ItemStack[] brewingItemStacks = new ItemStack[5];
    private int brewTime;
    private boolean[] filledSlots;
    private Item ingredientID;
    private String customName;
    private int fuel;

    static {
        int[] nArray = new int[4];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 3;
        field_184277_f = nArray;
        int[] nArray2 = new int[4];
        nArray2[1] = 1;
        nArray2[2] = 2;
        nArray2[3] = 4;
        outputSlots = nArray2;
    }

    @Override
    public String getName() {
        return this.hasCustomName() ? this.customName : "container.brewing";
    }

    @Override
    public boolean hasCustomName() {
        return this.customName != null && !this.customName.isEmpty();
    }

    public void setName(String name) {
        this.customName = name;
    }

    @Override
    public int getSizeInventory() {
        return this.brewingItemStacks.length;
    }

    @Override
    public void update() {
        boolean[] aboolean;
        boolean flag1;
        if (this.fuel <= 0 && this.brewingItemStacks[4] != null && this.brewingItemStacks[4].getItem() == Items.blaze_powder) {
            this.fuel = 20;
            --this.brewingItemStacks[4].stackSize;
            if (this.brewingItemStacks[4].stackSize <= 0) {
                this.brewingItemStacks[4] = null;
            }
            this.markDirty();
        }
        boolean flag = this.canBrew();
        boolean bl = flag1 = this.brewTime > 0;
        if (flag1) {
            boolean flag2;
            --this.brewTime;
            boolean bl2 = flag2 = this.brewTime == 0;
            if (flag2 && flag) {
                this.brewPotions();
                this.markDirty();
            } else if (!flag) {
                this.brewTime = 0;
                this.markDirty();
            } else if (this.ingredientID != this.brewingItemStacks[3].getItem()) {
                this.brewTime = 0;
                this.markDirty();
            }
        } else if (flag && this.fuel > 0) {
            --this.fuel;
            this.brewTime = 400;
            this.ingredientID = this.brewingItemStacks[3].getItem();
            this.markDirty();
        }
        if (!this.worldObj.isRemote && !Arrays.equals(aboolean = this.func_174902_m(), this.filledSlots)) {
            this.filledSlots = aboolean;
            IBlockState iblockstate = this.worldObj.getBlockState(this.getPos());
            if (!(iblockstate.getBlock() instanceof BlockBrewingStand)) {
                return;
            }
            int i = 0;
            while (i < BlockBrewingStand.HAS_BOTTLE.length) {
                iblockstate = iblockstate.withProperty(BlockBrewingStand.HAS_BOTTLE[i], Boolean.valueOf(aboolean[i]));
                ++i;
            }
            this.worldObj.setBlockState(this.pos, iblockstate, 2);
        }
    }

    public boolean[] func_174902_m() {
        boolean[] aboolean = new boolean[3];
        int i = 0;
        while (i < 3) {
            if (this.brewingItemStacks[i] != null) {
                aboolean[i] = true;
            }
            ++i;
        }
        return aboolean;
    }

    private boolean canBrew() {
        if (this.brewingItemStacks[3] != null && this.brewingItemStacks[3].stackSize > 0) {
            ItemStack itemstack = this.brewingItemStacks[3];
            if (!PotionHelper.func_185205_a(itemstack)) {
                return false;
            }
            int i = 0;
            while (i < 3) {
                ItemStack itemstack1 = this.brewingItemStacks[i];
                if (itemstack1 != null && PotionHelper.func_185208_a(itemstack1, itemstack)) {
                    return true;
                }
                ++i;
            }
            return false;
        }
        return false;
    }

    private void brewPotions() {
        ItemStack itemstack = this.brewingItemStacks[3];
        int i = 0;
        while (i < 3) {
            this.brewingItemStacks[i] = PotionHelper.func_185212_d(itemstack, this.brewingItemStacks[i]);
            ++i;
        }
        --itemstack.stackSize;
        BlockPos blockpos = this.getPos();
        if (itemstack.getItem().hasContainerItem()) {
            ItemStack itemstack1 = new ItemStack(itemstack.getItem().getContainerItem());
            if (itemstack.stackSize <= 0) {
                itemstack = itemstack1;
            } else {
                InventoryHelper.spawnItemStack(this.worldObj, blockpos.getX(), blockpos.getY(), blockpos.getZ(), itemstack1);
            }
        }
        if (itemstack.stackSize <= 0) {
            itemstack = null;
        }
        this.brewingItemStacks[3] = itemstack;
        this.worldObj.playAuxSFX(1035, blockpos, 0);
    }

    @Override
    public void readFromNBT(NBTTagCompound compound) {
        super.readFromNBT(compound);
        NBTTagList nbttaglist = compound.getTagList("Items", 10);
        this.brewingItemStacks = new ItemStack[this.getSizeInventory()];
        int i = 0;
        while (i < nbttaglist.tagCount()) {
            NBTTagCompound nbttagcompound = nbttaglist.getCompoundTagAt(i);
            byte j = nbttagcompound.getByte("Slot");
            if (j >= 0 && j < this.brewingItemStacks.length) {
                this.brewingItemStacks[j] = ItemStack.loadItemStackFromNBT(nbttagcompound);
            }
            ++i;
        }
        this.brewTime = compound.getShort("BrewTime");
        if (compound.hasKey("CustomName", 8)) {
            this.customName = compound.getString("CustomName");
        }
        this.fuel = compound.getByte("Fuel");
    }

    @Override
    public void writeToNBT(NBTTagCompound compound) {
        super.writeToNBT(compound);
        compound.setShort("BrewTime", (short)this.brewTime);
        NBTTagList nbttaglist = new NBTTagList();
        int i = 0;
        while (i < this.brewingItemStacks.length) {
            if (this.brewingItemStacks[i] != null) {
                NBTTagCompound nbttagcompound = new NBTTagCompound();
                nbttagcompound.setByte("Slot", (byte)i);
                this.brewingItemStacks[i].writeToNBT(nbttagcompound);
                nbttaglist.appendTag(nbttagcompound);
            }
            ++i;
        }
        compound.setTag("Items", nbttaglist);
        if (this.hasCustomName()) {
            compound.setString("CustomName", this.customName);
        }
        compound.setByte("Fuel", (byte)this.fuel);
    }

    @Override
    public ItemStack getStackInSlot(int index) {
        return index >= 0 && index < this.brewingItemStacks.length ? this.brewingItemStacks[index] : null;
    }

    @Override
    public ItemStack decrStackSize(int index, int count) {
        return ItemStackHelper.func_188382_a(this.brewingItemStacks, index, count);
    }

    @Override
    public ItemStack removeStackFromSlot(int index) {
        return ItemStackHelper.func_188383_a(this.brewingItemStacks, index);
    }

    @Override
    public void setInventorySlotContents(int index, ItemStack stack) {
        if (index >= 0 && index < this.brewingItemStacks.length) {
            this.brewingItemStacks[index] = stack;
        }
    }

    @Override
    public int getInventoryStackLimit() {
        return 64;
    }

    @Override
    public boolean isUseableByPlayer(EntityPlayer player) {
        return this.worldObj.getTileEntity(this.pos) != this ? false : player.getDistanceSq((double)this.pos.getX() + 0.5, (double)this.pos.getY() + 0.5, (double)this.pos.getZ() + 0.5) <= 64.0;
    }

    @Override
    public void openInventory(EntityPlayer player) {
    }

    @Override
    public void closeInventory(EntityPlayer player) {
    }

    @Override
    public boolean isItemValidForSlot(int index, ItemStack stack) {
        if (index == 3) {
            return PotionHelper.func_185205_a(stack);
        }
        Item item = stack.getItem();
        return index == 4 ? item == Items.blaze_powder : item == Items.potionitem || item == Items.splash_potion || item == Items.lingering_potion || item == Items.glass_bottle;
    }

    @Override
    public int[] getSlotsForFace(EnumFacing side) {
        return side == EnumFacing.UP ? inputSlots : (side == EnumFacing.DOWN ? field_184277_f : outputSlots);
    }

    @Override
    public boolean canInsertItem(int index, ItemStack itemStackIn, EnumFacing direction) {
        return this.isItemValidForSlot(index, itemStackIn);
    }

    @Override
    public boolean canExtractItem(int index, ItemStack stack, EnumFacing direction) {
        return index == 3 ? stack.getItem() == Items.glass_bottle : true;
    }

    @Override
    public String getGuiID() {
        return "minecraft:brewing_stand";
    }

    @Override
    public Container createContainer(InventoryPlayer playerInventory, EntityPlayer playerIn) {
        return new ContainerBrewingStand(playerInventory, this);
    }

    @Override
    public int getField(int id) {
        switch (id) {
            case 0: {
                return this.brewTime;
            }
            case 1: {
                return this.fuel;
            }
        }
        return 0;
    }

    @Override
    public void setField(int id, int value) {
        switch (id) {
            case 0: {
                this.brewTime = value;
                break;
            }
            case 1: {
                this.fuel = value;
            }
        }
    }

    @Override
    public int getFieldCount() {
        return 2;
    }

    @Override
    public void clear() {
        Arrays.fill(this.brewingItemStacks, null);
    }
}

